/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTreeControl;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTreeViewer;
import org.jkiss.utils.CommonUtils;

public class DriverManagerDialog
extends HelpEnabledDialog
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_ID = "DBeaver.DriverManagerDialog";
    private static final String DEFAULT_DS_PROVIDER = "generic";
    private DataSourceProviderDescriptor selectedProvider;
    private DataSourceProviderDescriptor onlyManagableProvider;
    private String selectedCategory;
    private DriverDescriptor selectedDriver;
    private Button newButton;
    private Button copyButton;
    private Button editButton;
    private Button deleteButton;
    private DriverTreeControl treeControl;
    private Image dialogImage;
    private Text descText;

    public DriverManagerDialog(Shell shell) {
        super(shell, "database-drivers");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Control createDialogArea(Composite parent) {
        List<DataSourceProviderDescriptor> enabledProviders = DataSourceProviderRegistry.getInstance().getEnabledDataSourceProviders();
        DataSourceProviderDescriptor manProvider = null;
        for (DataSourceProviderDescriptor provider : DataSourceProviderRegistry.getInstance().getEnabledDataSourceProviders()) {
            if (!provider.isDriversManagable()) continue;
            if (manProvider != null) {
                manProvider = null;
                break;
            }
            manProvider = provider;
        }
        if (manProvider != null) {
            this.onlyManagableProvider = manProvider;
        }
        this.getShell().setText(CoreMessages.dialog_driver_manager_title);
        this.getShell().setMinimumSize(300, 300);
        this.dialogImage = DBeaverIcons.getImage((DBPImage)UIIcon.DRIVER_MANAGER);
        this.getShell().setImage(this.dialogImage);
        Composite group = UIUtils.createPlaceholder((Composite)((Composite)super.createDialogArea(parent)), (int)2);
        group.setLayoutData((Object)new GridData(1808));
        this.treeControl = new DriverTreeControl(group, (Object)this, enabledProviders, false);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.treeControl.setLayoutData(gd);
        Composite buttonBar = new Composite(group, 128);
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        GridData gd2 = new GridData(1040);
        buttonBar.setLayoutData((Object)gd2);
        this.newButton = UIUtils.createPushButton((Composite)buttonBar, (String)CoreMessages.dialog_driver_manager_button_new, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverManagerDialog.this.createDriver();
            }
        });
        this.newButton.setLayoutData((Object)new GridData(768));
        this.copyButton = UIUtils.createPushButton((Composite)buttonBar, (String)CoreMessages.dialog_driver_manager_button_copy, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverManagerDialog.this.copyDriver();
            }
        });
        this.copyButton.setLayoutData((Object)new GridData(768));
        this.editButton = UIUtils.createPushButton((Composite)buttonBar, (String)CoreMessages.dialog_driver_manager_button_edit, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverManagerDialog.this.editDriver();
            }
        });
        this.editButton.setLayoutData((Object)new GridData(768));
        this.deleteButton = UIUtils.createPushButton((Composite)buttonBar, (String)CoreMessages.dialog_driver_manager_button_delete, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverManagerDialog.this.deleteDriver();
            }
        });
        this.deleteButton.setLayoutData((Object)new GridData(768));
        Composite legend = UIUtils.createPlaceholder((Composite)buttonBar, (int)2, (int)5);
        gd2 = new GridData(768);
        gd2.verticalIndent = 5;
        gd2.horizontalSpan = 2;
        legend.setLayoutData((Object)gd2);
        UIUtils.createLabel((Composite)legend, (DBPImage)DBIcon.OVER_LAMP);
        UIUtils.createLabel((Composite)legend, (String)CoreMessages.dialog_driver_manager_label_user_defined);
        UIUtils.createLabel((Composite)legend, (DBPImage)DBIcon.OVER_ERROR);
        UIUtils.createLabel((Composite)legend, (String)CoreMessages.dialog_driver_manager_label_unavailable);
        this.descText = new Text(group, 8);
        gd = new GridData(768);
        gd.verticalIndent = 5;
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.descText.setLayoutData((Object)gd);
        this.setDefaultSelection();
        this.updateButtons();
        return group;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.setReturnCode(0);
            this.close();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setDefaultSelection();
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof DriverDescriptor) {
                this.selectedDriver = (DriverDescriptor)((Object)selectedObject);
                this.selectedCategory = this.selectedDriver.getCategory();
                this.selectedProvider = this.selectedDriver.getProviderDescriptor();
            } else if (selectedObject instanceof DataSourceProviderDescriptor) {
                this.selectedProvider = (DataSourceProviderDescriptor)((Object)selectedObject);
            } else if (selectedObject instanceof DriverTreeViewer.DriverCategory) {
                this.selectedCategory = ((DriverTreeViewer.DriverCategory)selectedObject).getName();
            }
        }
        this.updateButtons();
    }

    private void setDefaultSelection() {
        this.selectedDriver = null;
        this.selectedProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(DEFAULT_DS_PROVIDER);
        this.selectedCategory = null;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.selectedDriver != null) {
            this.editDriver();
        }
    }

    private void updateButtons() {
        this.newButton.setEnabled(this.onlyManagableProvider != null || this.selectedProvider != null && this.selectedProvider.isDriversManagable());
        this.copyButton.setEnabled(this.selectedDriver != null && this.selectedDriver.isManagable());
        this.editButton.setEnabled(this.selectedDriver != null);
        this.deleteButton.setEnabled(this.selectedDriver != null && this.selectedDriver.getProviderDescriptor().isDriversManagable());
        if (this.selectedDriver != null) {
            this.descText.setText(CommonUtils.toString((Object)this.selectedDriver.getDescription()));
        } else if (this.selectedCategory != null) {
            this.descText.setText(String.valueOf(this.selectedCategory) + " drivers");
        } else if (this.selectedProvider != null) {
            this.descText.setText(String.valueOf(this.selectedProvider.getName()) + " provider");
        } else {
            this.descText.setText("");
        }
    }

    private void createDriver() {
        if (this.onlyManagableProvider != null || this.selectedProvider != null) {
            DriverEditDialog dialog;
            DataSourceProviderDescriptor provider = this.selectedProvider;
            if (provider == null || !provider.isDriversManagable()) {
                provider = this.onlyManagableProvider;
            }
            if ((dialog = new DriverEditDialog(this.getShell(), provider, this.selectedCategory)).open() == 0) {
                this.treeControl.getViewer().refresh();
                this.treeControl.getViewer().setSelection((ISelection)new StructuredSelection((Object)dialog.getDriver()));
            }
        }
    }

    private void copyDriver() {
        DriverEditDialog dialog;
        if (this.selectedDriver != null && (dialog = new DriverEditDialog(this.getShell(), this.selectedDriver.getProviderDescriptor(), this.selectedDriver)).open() == 0) {
            this.treeControl.getViewer().refresh();
            this.treeControl.getViewer().setSelection((ISelection)new StructuredSelection((Object)dialog.getDriver()));
        }
    }

    private void editDriver() {
        DriverDescriptor driver = this.selectedDriver;
        if (driver != null) {
            DriverEditDialog dialog = new DriverEditDialog(this.getShell(), driver);
            dialog.open();
            this.treeControl.getViewer().refresh((Object)driver);
        }
    }

    private void deleteDriver() {
        List<DataSourceDescriptor> usedDS = this.selectedDriver.getUsedBy();
        if (!usedDS.isEmpty()) {
            StringBuilder message = new StringBuilder(NLS.bind((String)CoreMessages.dialog_driver_manager_message_cant_delete_text, (Object)this.selectedDriver.getName()));
            for (DataSourceDescriptor ds : usedDS) {
                message.append("\n - ").append(ds.getName());
            }
            UIUtils.showMessageBox((Shell)this.getShell(), (String)CoreMessages.dialog_driver_manager_message_cant_delete_title, (String)message.toString(), (int)1);
            return;
        }
        if (UIUtils.confirmAction((Shell)this.getShell(), (String)CoreMessages.dialog_driver_manager_message_delete_driver_title, (String)(String.valueOf(CoreMessages.dialog_driver_manager_message_delete_driver_text) + this.selectedDriver.getName() + "'?"))) {
            this.selectedDriver.getProviderDescriptor().removeDriver(this.selectedDriver);
            this.selectedDriver.getProviderDescriptor().getRegistry().saveDrivers();
            this.treeControl.getViewer().refresh();
        }
    }

    public boolean close() {
        UIUtils.dispose((Resource)this.dialogImage);
        return super.close();
    }
}

