/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.registry.driver.DriverDependencies;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

class DriverDependenciesTree {
    private DBRRunnableContext runnableContext;
    private DBPDriver driver;
    private Collection<? extends DBPDriverLibrary> libraries;
    private final DriverDependencies dependencies;
    private boolean editable;
    private Tree filesTree;
    private TreeEditor treeEditor;
    private Font boldFont;

    public DriverDependenciesTree(Composite parent, DBRRunnableContext runnableContext, DriverDependencies dependencies, DBPDriver driver, Collection<? extends DBPDriverLibrary> libraries, boolean editable) {
        this.runnableContext = runnableContext;
        this.driver = driver;
        this.libraries = libraries;
        this.dependencies = dependencies;
        this.editable = editable;
        this.filesTree = new Tree(parent, 67584);
        this.filesTree.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.minimumHeight = this.filesTree.getHeaderHeight() + this.filesTree.getItemHeight() * 3;
        this.filesTree.setLayoutData((Object)gd);
        UIUtils.createTreeColumn((Tree)this.filesTree, (int)16384, (String)"File");
        UIUtils.createTreeColumn((Tree)this.filesTree, (int)16384, (String)"Version");
        UIUtils.createTreeColumn((Tree)this.filesTree, (int)16384, (String)"Description");
        if (editable) {
            this.boldFont = UIUtils.makeBoldFont((Font)this.filesTree.getFont());
            this.treeEditor = new TreeEditor(this.filesTree);
            this.treeEditor.horizontalAlignment = 131072;
            this.treeEditor.verticalAlignment = 0x1000000;
            this.treeEditor.grabHorizontal = true;
            this.treeEditor.minimumWidth = 50;
            this.filesTree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    TreeItem item = DriverDependenciesTree.this.filesTree.getItem(new Point(e.x, e.y));
                    if (item != null && item.getData() instanceof DBPDriverDependencies.DependencyNode && UIUtils.getColumnAtPos((TreeItem)item, (int)e.x, (int)e.y) == 1) {
                        DriverDependenciesTree.this.showVersionEditor(item);
                        return;
                    }
                    DriverDependenciesTree.this.disposeOldEditor();
                }
            });
            this.filesTree.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    UIUtils.dispose((Resource)DriverDependenciesTree.this.boldFont);
                }
            });
        }
    }

    public Tree getTree() {
        return this.filesTree;
    }

    public DBPDriver getDriver() {
        return this.driver;
    }

    public Collection<? extends DBPDriverLibrary> getLibraries() {
        return this.libraries;
    }

    public boolean resolveLibraries() {
        boolean resolved = false;
        try {
            this.runnableContext.run(true, true, new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Resolve dependencies", 100);
                    try {
                        try {
                            DriverDependenciesTree.this.dependencies.resolveDependencies(monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            resolved = true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            DBUserInterface.getInstance().showError("Resolve libraries", "Error resolving driver libraries", e.getTargetException());
        }
        this.filesTree.removeAll();
        int totalItems = 1;
        for (DBPDriverDependencies.DependencyNode node : this.dependencies.getLibraryMap()) {
            DBPDriverLibrary library = node.library;
            TreeItem item = new TreeItem(this.filesTree, 0);
            item.setData((Object)node);
            item.setImage(DBeaverIcons.getImage((DBPImage)library.getIcon()));
            item.setText(0, library.getDisplayName());
            item.setText(1, CommonUtils.notEmpty((String)library.getVersion()));
            item.setText(2, CommonUtils.notEmpty((String)library.getDescription()));
            if (this.editable) {
                item.setFont(1, this.boldFont);
            }
            ++totalItems;
            if (!this.addDependencies(item, node)) continue;
            item.setExpanded(true);
            totalItems += item.getItemCount();
        }
        UIUtils.packColumns((Tree)this.filesTree);
        int missingFiles = 0;
        for (DBPDriverDependencies.DependencyNode node : this.dependencies.getLibraryList()) {
            File localFile = node.library.getLocalFile();
            if (localFile != null && localFile.exists()) continue;
            ++missingFiles;
        }
        return resolved;
    }

    public void resizeTree() {
        Shell shell = this.filesTree.getShell();
        Point curSize = shell.getSize();
        int itemHeight = this.filesTree.getItemHeight();
        shell.setSize(curSize.x, Math.min((int)((double)UIUtils.getActiveWorkbenchWindow().getShell().getSize().y * 0.66), shell.computeSize((int)-1, (int)-1).y) + itemHeight * 2);
        shell.layout();
    }

    private boolean addDependencies(TreeItem parent, DBPDriverDependencies.DependencyNode node) {
        List dependencies = node.dependencies;
        if (dependencies != null && !dependencies.isEmpty()) {
            for (DBPDriverDependencies.DependencyNode dep : dependencies) {
                TreeItem item = new TreeItem(parent, 0);
                item.setImage(DBeaverIcons.getImage((DBPImage)dep.library.getIcon()));
                item.setText(0, dep.library.getDisplayName());
                item.setText(1, CommonUtils.notEmpty((String)dep.library.getVersion()));
                item.setText(2, CommonUtils.notEmpty((String)dep.library.getDescription()));
                if (dep.duplicate) {
                    item.setForeground(this.filesTree.getDisplay().getSystemColor(17));
                    continue;
                }
                this.addDependencies(item, dep);
            }
            return true;
        }
        return false;
    }

    private void disposeOldEditor() {
        Control oldEditor;
        if (this.treeEditor.getEditor() != null) {
            this.treeEditor.getEditor().dispose();
        }
        if ((oldEditor = this.treeEditor.getEditor()) != null) {
            oldEditor.dispose();
        }
    }

    private void showVersionEditor(TreeItem item) {
        this.disposeOldEditor();
        final DBPDriverDependencies.DependencyNode dependencyNode = (DBPDriverDependencies.DependencyNode)item.getData();
        if (dependencyNode == null || dependencyNode.library == null || !dependencyNode.library.isDownloadable()) {
            return;
        }
        final ArrayList<String> allVersions = new ArrayList<String>();
        try {
            this.runnableContext.run(true, true, new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        allVersions.addAll(dependencyNode.library.getAvailableVersions(monitor));
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBUserInterface.getInstance().showError("Versions", "Error reading versions", e.getTargetException());
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        String currentVersion = dependencyNode.library.getVersion();
        if (currentVersion != null && !allVersions.contains(currentVersion)) {
            allVersions.add(currentVersion);
        }
        final Combo editor = new Combo((Composite)this.filesTree, 12);
        int versionIndex = -1;
        int i = 0;
        while (i < allVersions.size()) {
            String version = (String)allVersions.get(i);
            editor.add(version);
            if (version.equals(currentVersion)) {
                versionIndex = i;
            }
            ++i;
        }
        if (versionIndex >= 0) {
            editor.select(versionIndex);
        }
        editor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newVersion = editor.getItem(editor.getSelectionIndex());
                DriverDependenciesTree.this.disposeOldEditor();
                DriverDependenciesTree.this.setLibraryVersion(dependencyNode.library, newVersion);
            }
        });
        this.treeEditor.setEditor((Control)editor, item, 1);
        editor.setListVisible(true);
    }

    protected void setLibraryVersion(DBPDriverLibrary library, String version) {
    }
}

