/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.data;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.ReferenceValueEditor;
import org.jkiss.dbeaver.ui.dialogs.data.ValueViewDialog;
import org.jkiss.dbeaver.ui.editors.binary.BinaryContent;
import org.jkiss.dbeaver.ui.editors.binary.HexEditControl;
import org.jkiss.dbeaver.ui.editors.content.ContentEditor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class TextViewDialog
extends ValueViewDialog {
    private static final Log log = Log.getLog(TextViewDialog.class);
    private static final String VALUE_TYPE_SELECTOR = "string.value.type";
    private StyledText textEdit;
    private Label lengthLabel;
    private HexEditControl hexEditControl;
    private CTabFolder editorContainer;
    private boolean dirty;

    public TextViewDialog(IValueController valueController) {
        super(valueController);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        CTabItem item;
        Composite dialogGroup = (Composite)super.createDialogArea(parent);
        ReferenceValueEditor referenceValueEditor = new ReferenceValueEditor(this.getValueController(), this);
        boolean isForeignKey = referenceValueEditor.isReferenceValue();
        Label label = new Label(dialogGroup, 0);
        label.setText(CoreMessages.dialog_data_label_value);
        boolean readOnly = this.getValueController().isReadOnly();
        boolean useHex = !isForeignKey;
        DBSTypedObject valueType = this.getValueController().getValueType();
        long maxSize = valueType.getMaxLength();
        if (useHex) {
            this.editorContainer = new CTabFolder(dialogGroup, 0x800080);
            this.editorContainer.setLayoutData((Object)new GridData(1808));
            this.lengthLabel = new Label((Composite)this.editorContainer, 131072);
            this.lengthLabel.setLayoutData((Object)new GridData(768));
            this.editorContainer.setTopRight((Control)this.lengthLabel, 4);
        }
        int selectedType = 0;
        if (this.getDialogSettings().get(VALUE_TYPE_SELECTOR) != null) {
            selectedType = this.getDialogSettings().getInt(VALUE_TYPE_SELECTOR);
        }
        int style = 0;
        if (readOnly) {
            style |= 8;
        }
        style = useHex ? (style |= 0x342) : (style |= 0x800);
        this.textEdit = new StyledText((Composite)(useHex ? this.editorContainer : dialogGroup), style);
        this.textEdit.setMargins(3, 3, 3, 3);
        if (maxSize > 0L && valueType.getDataKind() == DBPDataKind.STRING) {
            this.textEdit.setTextLimit((int)maxSize);
        }
        GridData gd = new GridData(isForeignKey ? 768 : 1808);
        gd.widthHint = 300;
        if (!isForeignKey) {
            gd.heightHint = 200;
            gd.grabExcessVerticalSpace = true;
        }
        this.textEdit.setLayoutData((Object)gd);
        this.textEdit.setFocus();
        this.textEdit.setEditable(!readOnly);
        this.textEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextViewDialog.this.dirty = true;
                TextViewDialog.this.updateValueLength();
            }
        });
        StyledTextUtils.fillDefaultStyledTextContextMenu((StyledText)this.textEdit);
        if (useHex) {
            item = new CTabItem(this.editorContainer, 524288);
            item.setText("Text");
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_TEXT));
            item.setControl((Control)this.textEdit);
        }
        Point minSize = null;
        if (useHex) {
            this.hexEditControl = new HexEditControl((Composite)this.editorContainer, readOnly ? 8 : 0, 6, 8);
            gd = new GridData(1808);
            gd.heightHint = 200;
            gd.minimumWidth = this.hexEditControl.computeSize((int)-1, (int)-1).x;
            this.hexEditControl.setLayoutData(gd);
            minSize = this.hexEditControl.computeSize(-1, -1);
            minSize.x += 50;
            minSize.y += 50;
            item = new CTabItem(this.editorContainer, 524288);
            item.setText("Hex");
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_BINARY));
            item.setControl((Control)this.hexEditControl);
            if (selectedType >= this.editorContainer.getItemCount()) {
                selectedType = 0;
            }
            this.editorContainer.setSelection(selectedType);
            this.editorContainer.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextViewDialog.this.getDialogSettings().put(TextViewDialog.VALUE_TYPE_SELECTOR, TextViewDialog.this.editorContainer.getSelectionIndex());
                }
            });
            this.hexEditControl.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    TextViewDialog.this.dirty = true;
                }
            });
            this.updateValueLength();
        }
        this.primeEditorValue(this.getValueController().getValue());
        if (isForeignKey) {
            referenceValueEditor.createEditorSelector(dialogGroup);
        }
        if (minSize != null) {
            this.getShell().setMinimumSize(minSize);
        }
        return dialogGroup;
    }

    private byte[] getBinaryContent() {
        BinaryContent content = this.hexEditControl.getContent();
        ByteBuffer buffer = ByteBuffer.allocate((int)content.length());
        try {
            content.get(buffer, 0L);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return buffer.array();
    }

    private String getBinaryString() {
        String stringValue;
        byte[] bytes = this.getBinaryContent();
        int length = bytes.length;
        try {
            stringValue = new String(bytes, 0, length, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            stringValue = new String(bytes);
        }
        return stringValue;
    }

    private void setBinaryContent(String stringValue) {
        byte[] bytes;
        String charset = this.getDefaultCharset();
        try {
            bytes = stringValue.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            bytes = stringValue.getBytes(Charset.defaultCharset());
        }
        this.hexEditControl.setContent(bytes, charset);
    }

    private String getDefaultCharset() {
        return DBValueFormatting.getDefaultBinaryFileEncoding((DBPDataSource)this.getValueController().getExecutionContext().getDataSource());
    }

    @Override
    public Object extractEditorValue() {
        Object prevValue = this.getValueController().getValue();
        Object rawValue = prevValue instanceof DBDContent ? (ContentUtils.isTextContent((DBDContent)((DBDContent)prevValue)) ? (this.isTextEditorActive() ? this.textEdit.getText() : this.getBinaryString()) : (Object)(this.isTextEditorActive() ? GeneralUtils.convertToBytes((String)this.textEdit.getText()) : this.getBinaryContent())) : (this.isTextEditorActive() ? this.textEdit.getText() : this.getBinaryString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DBCSession session = this.getValueController().getExecutionContext().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Make text value from editor");){
                return this.getValueController().getValueHandler().getValueFromObject(session, this.getValueController().getValueType(), rawValue, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DBUserInterface.getInstance().showError("Extract editor value", "Can't extract editor value", (Throwable)e);
            return null;
        }
    }

    @Override
    public Control getControl() {
        if (this.isTextEditorActive()) {
            return this.textEdit;
        }
        return this.hexEditControl;
    }

    private boolean isTextEditorActive() {
        return this.editorContainer == null || this.editorContainer.getSelectionIndex() == 0;
    }

    private void updateValueLength() {
        if (this.lengthLabel != null) {
            long maxSize = this.getValueController().getValueType().getMaxLength();
            long length = this.textEdit.getText().length();
            this.lengthLabel.setText("Length: " + length + (maxSize > 0L ? " [" + maxSize + "]" : ""));
        }
    }

    @Override
    public void primeEditorValue(@Nullable Object value) {
        if (value instanceof DBDContentCached) {
            value = ((DBDContentCached)value).getCachedValue();
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            this.textEdit.setText(GeneralUtils.convertToString((byte[])bytes, (int)0, (int)bytes.length));
            if (this.hexEditControl != null) {
                this.hexEditControl.setContent(bytes, this.getDefaultCharset());
            }
        } else {
            IValueController valueController = this.getValueController();
            String strValue = valueController.getValueHandler().getValueDisplayString(valueController.getValueType(), value, DBDDisplayFormat.EDIT);
            this.textEdit.setText(strValue);
            if (this.hexEditControl != null) {
                this.setBinaryContent(strValue);
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.getValueController().getValueType().getDataKind() == DBPDataKind.STRING) {
            Button button = this.createButton(parent, 10, CoreMessages.dialog_text_view_open_editor, false);
            button.setToolTipText(CoreMessages.dialog_text_view_open_editor_tip);
        }
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 10) {
            ContentEditor editor = ContentEditor.openEditor(this.getValueController());
            this.cancelPressed();
            return;
        }
        super.buttonPressed(buttonId);
    }
}

