/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;

public class DataFormatProfilesEditDialog
extends Dialog {
    private static final int NEW_ID = 1025;
    private static final int DELETE_ID = 1026;
    private org.eclipse.swt.widgets.List profileList;

    public DataFormatProfilesEditDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CoreMessages.dialog_data_format_profiles_title);
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        this.profileList = new org.eclipse.swt.widgets.List(group, 2052);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 200;
        this.profileList.setLayoutData((Object)gd);
        this.profileList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataFormatProfilesEditDialog.this.getButton(1026).setEnabled(DataFormatProfilesEditDialog.this.profileList.getSelectionIndex() >= 0);
            }
        });
        this.loadProfiles();
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, CoreMessages.dialog_data_format_profiles_button_new_profile, false);
        this.createButton(parent, 1026, CoreMessages.dialog_data_format_profiles_button_delete_profile, false);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        this.getButton(1026).setEnabled(false);
    }

    protected void buttonPressed(int buttonId) {
        DataFormatterRegistry registry = DataFormatterRegistry.getInstance();
        if (buttonId == 1025) {
            String profileName = EnterNameDialog.chooseName(this.getShell(), CoreMessages.dialog_data_format_profiles_dialog_name_chooser_title);
            if (registry.getCustomProfile(profileName) != null) {
                UIUtils.showMessageBox((Shell)this.getShell(), (String)CoreMessages.dialog_data_format_profiles_error_title, (String)NLS.bind((String)CoreMessages.dialog_data_format_profiles_error_message, (Object)profileName), (int)1);
            } else {
                registry.createCustomProfile(profileName);
                this.loadProfiles();
            }
        } else if (buttonId == 1026) {
            DBDDataFormatterProfile profile;
            int selectionIndex = this.profileList.getSelectionIndex();
            if (selectionIndex >= 0 && (profile = registry.getCustomProfile(this.profileList.getItem(selectionIndex))) != null && UIUtils.confirmAction((Shell)this.getShell(), (String)CoreMessages.dialog_data_format_profiles_confirm_delete_title, (String)CoreMessages.dialog_data_format_profiles_confirm_delete_message)) {
                registry.deleteCustomProfile(profile);
                this.loadProfiles();
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void loadProfiles() {
        this.profileList.removeAll();
        List<DBDDataFormatterProfile> profiles = DataFormatterRegistry.getInstance().getCustomProfiles();
        for (DBDDataFormatterProfile profile : profiles) {
            this.profileList.add(profile.getProfileName());
        }
        Button deleteButton = this.getButton(1026);
        if (deleteButton != null) {
            deleteButton.setEnabled(false);
        }
    }
}

