/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.valuefilter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSConstraintEnumerable;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.editors.ReferenceValueEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class GenericFilterValueEdit {
    TableViewer table;
    String filterPattern;
    private KeyLoadJob loadJob;
    IValueEditor editor;
    Text textControl;
    @NotNull
    final ResultSetViewer viewer;
    @NotNull
    final DBDAttributeBinding attr;
    @NotNull
    final ResultSetRow[] rows;
    @NotNull
    final DBCLogicalOperator operator;
    private boolean isCheckedTable;
    private static final int MAX_MULTI_VALUES = 1000;
    private static final String MULTI_KEY_LABEL = "...";

    GenericFilterValueEdit(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attr, @NotNull ResultSetRow[] rows, @NotNull DBCLogicalOperator operator) {
        this.viewer = viewer;
        this.attr = attr;
        this.rows = rows;
        this.operator = operator;
    }

    void setupTable(Composite composite, int style, boolean visibleLines, boolean visibleHeader, Object layoutData) {
        this.table = new TableViewer(composite, style);
        this.table.getTable().setLinesVisible(visibleLines);
        this.table.getTable().setHeaderVisible(visibleHeader);
        this.table.getTable().setLayoutData(layoutData);
        this.table.setContentProvider((IContentProvider)new ListContentProvider());
        this.isCheckedTable = (style & 0x20) == 32;
    }

    void addContextMenu(Action[] actions) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            UIUtils.fillDefaultTableContextMenu((IMenuManager)manager, (Table)this.table.getTable());
            manager.add((IContributionItem)new Separator());
            Action[] actionArray2 = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action act = actionArray2[n2];
                manager.add((IAction)act);
                ++n2;
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.table.getTable().setMenu(menuMgr.createContextMenu((Control)this.table.getTable()));
    }

    Collection<DBDLabelValuePair> getMultiValues() {
        return (Collection)this.table.getInput();
    }

    Text addFilterTextbox(Composite composite) {
        Text valueFilterText = new Text(composite, 2048);
        valueFilterText.setLayoutData((Object)new GridData(768));
        valueFilterText.addModifyListener(e -> {
            this.filterPattern = valueFilterText.getText();
            if (this.filterPattern.isEmpty()) {
                this.filterPattern = null;
            }
            this.loadValues();
        });
        return valueFilterText;
    }

    void loadValues() {
        if (this.loadJob != null) {
            if (this.loadJob.getState() == 4) {
                this.loadJob.cancel();
            }
            this.loadJob.schedule(100L);
            return;
        }
        DBSEntityReferrer enumerableConstraint = ReferenceValueEditor.getEnumerableConstraint(this.attr);
        if (enumerableConstraint != null) {
            this.loadConstraintEnum(enumerableConstraint);
        } else if (this.attr.getEntityAttribute() instanceof DBSAttributeEnumerable) {
            this.loadAttributeEnum((DBSAttributeEnumerable)this.attr.getEntityAttribute());
        } else {
            this.loadMultiValueList(Collections.emptyList());
        }
    }

    private void loadConstraintEnum(final DBSEntityReferrer refConstraint) {
        this.loadJob = new KeyLoadJob(this, "Load constraint '" + refConstraint.getName() + "' values"){

            @Override
            Collection<DBDLabelValuePair> readEnumeration(DBCSession session) throws DBException {
                DBSEntityAttribute tableColumn = attr.getEntityAttribute();
                if (tableColumn == null) {
                    return null;
                }
                DBSEntityAttributeRef fkColumn = DBUtils.getConstraintAttribute((DBRProgressMonitor)session.getProgressMonitor(), (DBSEntityReferrer)refConstraint, (DBSEntityAttribute)tableColumn);
                if (fkColumn == null) {
                    return null;
                }
                if (!(refConstraint instanceof DBSEntityAssociation)) {
                    return null;
                }
                DBSEntityAssociation association = (DBSEntityAssociation)refConstraint;
                DBSEntityAttribute refColumn = DBUtils.getReferenceAttribute((DBRProgressMonitor)session.getProgressMonitor(), (DBSEntityAssociation)association, (DBSEntityAttribute)tableColumn, (boolean)false);
                if (refColumn == null) {
                    return null;
                }
                DBSEntityAttribute fkAttribute = fkColumn.getAttribute();
                DBSEntityConstraint refConstraint2 = association.getReferencedConstraint();
                DBSConstraintEnumerable enumConstraint = (DBSConstraintEnumerable)refConstraint2;
                if (fkAttribute != null && enumConstraint != null) {
                    return enumConstraint.getKeyEnumeration(session, refColumn, (Object)filterPattern, null, true, true, 1000);
                }
                return null;
            }
        };
        this.loadJob.schedule();
    }

    private void loadAttributeEnum(final DBSAttributeEnumerable attributeEnumerable) {
        if (this.table.getTable().getColumns().length > 1) {
            this.table.getTable().getColumn(1).setText("Count");
        }
        this.loadJob = new KeyLoadJob(this, "Load '" + this.attr.getName() + "' values"){

            @Override
            Collection<DBDLabelValuePair> readEnumeration(DBCSession session) throws DBException {
                return attributeEnumerable.getValueEnumeration(session, (Object)filterPattern, 1000);
            }
        };
        this.loadJob.schedule();
    }

    private void loadMultiValueList(@NotNull Collection<DBDLabelValuePair> values) {
        Widget item;
        ViewerColumnController vcc;
        String itemString;
        Pattern pattern = null;
        if (!CommonUtils.isEmpty((String)this.filterPattern)) {
            pattern = Pattern.compile(SQLUtils.makeLikePattern((String)("%" + this.filterPattern + "%")), 2);
        }
        boolean hasNulls = false;
        HashMap<Object, DBDLabelValuePair> rowData = new HashMap<Object, DBDLabelValuePair>();
        for (DBDLabelValuePair pair : values) {
            DBDLabelValuePair oldLabel = (DBDLabelValuePair)rowData.get(pair.getValue());
            if (oldLabel != null) {
                String multiLabel = String.valueOf(oldLabel.getLabel()) + "," + pair.getLabel();
                if (multiLabel.length() > 200) {
                    multiLabel = String.valueOf(multiLabel.substring(0, 200)) + MULTI_KEY_LABEL;
                }
                rowData.put(pair.getValue(), new DBDLabelValuePair(multiLabel, pair.getValue()));
                continue;
            }
            rowData.put(pair.getValue(), pair);
        }
        for (ResultSetRow row : this.viewer.getModel().getAllRows()) {
            Object cellValue = this.viewer.getModel().getCellValue(this.attr, row);
            if (DBUtils.isNullValue((Object)cellValue)) {
                hasNulls = true;
                continue;
            }
            if (rowData.containsKey(cellValue)) continue;
            itemString = this.attr.getValueHandler().getValueDisplayString((DBSTypedObject)this.attr, cellValue, DBDDisplayFormat.UI);
            rowData.put(cellValue, new DBDLabelValuePair(itemString, cellValue));
        }
        ArrayList sortedList = new ArrayList(rowData.values());
        Collections.sort(sortedList);
        if (pattern != null) {
            Iterator iter = sortedList.iterator();
            while (iter.hasNext()) {
                DBDLabelValuePair valuePair = (DBDLabelValuePair)iter.next();
                itemString = this.attr.getValueHandler().getValueDisplayString((DBSTypedObject)this.attr, valuePair.getValue(), DBDDisplayFormat.UI);
                if (pattern.matcher(itemString).matches() || valuePair.getLabel() != null && pattern.matcher(valuePair.getLabel()).matches()) continue;
                iter.remove();
            }
        }
        Collections.sort(sortedList);
        if (hasNulls && !rowData.containsKey(null)) {
            sortedList.add(0, new DBDLabelValuePair(DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)DBDDisplayFormat.UI), null));
        }
        HashSet<Object> checkedValues = new HashSet<Object>();
        ResultSetRow[] resultSetRowArray = this.rows;
        int n = this.rows.length;
        int itemString2 = 0;
        while (itemString2 < n) {
            ResultSetRow row = resultSetRowArray[itemString2];
            Object value = this.viewer.getModel().getCellValue(this.attr, row);
            checkedValues.add(value);
            ++itemString2;
        }
        this.table.setInput(sortedList);
        DBDLabelValuePair firstVisibleItem = null;
        if (this.isCheckedTable) {
            for (DBDLabelValuePair row : sortedList) {
                Object cellValue = row.getValue();
                if (!checkedValues.contains(cellValue)) continue;
                TableItem t = (TableItem)this.table.testFindItem((Object)row);
                t.setChecked(true);
                if (firstVisibleItem != null) continue;
                firstVisibleItem = row;
            }
        }
        if ((vcc = ViewerColumnController.getFromControl((Control)this.table.getTable())) != null) {
            vcc.repackColumns();
        }
        if (firstVisibleItem != null && (item = this.table.testFindItem(firstVisibleItem)) != null) {
            this.table.getTable().setSelection((TableItem)item);
            this.table.getTable().showItem((TableItem)item);
        }
    }

    private abstract class KeyLoadJob
    extends AbstractJob {
        KeyLoadJob(String name) {
            super(name);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            DBCExecutionContext executionContext = GenericFilterValueEdit.this.viewer.getExecutionContext();
            if (executionContext == null) {
                return Status.OK_STATUS;
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBPDataSource)executionContext.getDataSource(), (String)"Read value enumeration");
                    try {
                        Collection<DBDLabelValuePair> valueEnumeration = this.readEnumeration(session);
                        if (valueEnumeration == null) {
                            return Status.OK_STATUS;
                        }
                        this.populateValues(valueEnumeration);
                        return Status.OK_STATUS;
                    }
                    finally {
                        if (session == null) return Status.OK_STATUS;
                        session.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (DBException e) {
                this.populateValues(Collections.emptyList());
                return GeneralUtils.makeExceptionStatus((Throwable)e);
            }
        }

        @Nullable
        abstract Collection<DBDLabelValuePair> readEnumeration(DBCSession var1) throws DBException;

        void populateValues(final @NotNull Collection<DBDLabelValuePair> values) {
            UIUtils.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    GenericFilterValueEdit.this.loadMultiValueList(values);
                }
            });
        }
    }
}

