/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetListenerAdapter;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingConfigDialog;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;
import org.jkiss.utils.CommonUtils;

public class GroupingPanel
implements IResultSetPanel {
    public static final String PANEL_ID = "results-grouping";
    public static final String SETTINGS_SECTION_GROUPING = "panel-results-grouping";
    private IResultSetPresentation presentation;
    private IDialogSettings panelSettings;
    private GroupingResultsContainer resultsContainer;

    @Override
    public Control createContents(final IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.panelSettings = ResultSetUtils.getViewerSettings(SETTINGS_SECTION_GROUPING);
        this.loadSettings();
        this.resultsContainer = new GroupingResultsContainer(parent, presentation);
        IResultSetController groupingViewer = this.resultsContainer.getResultSetController();
        ResultSetListenerAdapter ownerListener = new ResultSetListenerAdapter(){
            String prevQueryText = null;

            @Override
            public void handleResultSetLoad() {
                String queryText = presentation.getController().getDataContainer().getName();
                if (this.prevQueryText != null && !CommonUtils.equalObjects((Object)this.prevQueryText, (Object)queryText)) {
                    GroupingPanel.this.resultsContainer.clearGrouping();
                } else {
                    try {
                        GroupingPanel.this.resultsContainer.rebuildGrouping();
                    }
                    catch (DBException e) {
                        DBUserInterface.getInstance().showError("Grouping error", "Can't refresh grouping query", (Throwable)e);
                    }
                }
                this.prevQueryText = queryText;
            }
        };
        this.presentation.getController().addListener(ownerListener);
        groupingViewer.getControl().addDisposeListener(e -> this.presentation.getController().removeListener(ownerListener));
        ResultSetListenerAdapter groupingResultsListener = new ResultSetListenerAdapter(){

            @Override
            public void handleResultSetLoad() {
                GroupingPanel.this.updateControls();
            }

            @Override
            public void handleResultSetSelectionChange(SelectionChangedEvent event) {
                GroupingPanel.this.updateControls();
            }
        };
        groupingViewer.addListener(groupingResultsListener);
        return groupingViewer.getControl();
    }

    @Override
    public boolean isDirty() {
        return !this.resultsContainer.getGroupAttributes().isEmpty();
    }

    private void updateControls() {
        this.presentation.getController().updatePanelActions();
    }

    private void loadSettings() {
        IDialogSettings functionsSection = this.panelSettings.getSection("groups");
    }

    private void saveSettings() {
        IDialogSettings functionsSection = UIUtils.getSettingsSection((IDialogSettings)this.panelSettings, (String)"groups");
    }

    @Override
    public void activatePanel() {
        this.refresh(false);
    }

    @Override
    public void deactivatePanel() {
    }

    @Override
    public void refresh(boolean force) {
    }

    @Override
    public void contributeActions(ToolBarManager manager) {
        this.fillToolBar((IContributionManager)manager);
    }

    private void fillToolBar(IContributionManager contributionManager) {
        contributionManager.add((IAction)new EditColumnsAction(this.resultsContainer));
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new DeleteColumnAction(this.resultsContainer));
        contributionManager.add((IAction)new ClearGroupingAction(this.resultsContainer));
    }

    static class ClearGroupingAction
    extends GroupingAction {
        public ClearGroupingAction(GroupingResultsContainer resultsContainer) {
            super(resultsContainer, CoreMessages.controls_resultset_grouping_clear, UIUtils.getShardImageDescriptor((String)"IMG_ETOOL_CLEAR"));
        }

        public boolean isEnabled() {
            return !this.resultsContainer.getGroupAttributes().isEmpty();
        }

        public void run() {
            this.resultsContainer.clearGrouping();
            this.resultsContainer.getOwnerPresentation().getController().updatePanelActions();
        }
    }

    static class DeleteColumnAction
    extends GroupingAction {
        public DeleteColumnAction(GroupingResultsContainer resultsContainer) {
            super(resultsContainer, CoreMessages.controls_resultset_grouping_remove_column, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ACTION_OBJECT_DELETE));
        }

        public boolean isEnabled() {
            return !this.resultsContainer.getResultSetController().getSelection().isEmpty();
        }

        public void run() {
            List<String> attributes;
            DBDAttributeBinding currentAttribute = this.resultsContainer.getResultSetController().getActivePresentation().getCurrentAttribute();
            if (currentAttribute != null && (this.resultsContainer.removeGroupingAttribute(attributes = Collections.singletonList(currentAttribute.getFullyQualifiedName(DBPEvaluationContext.UI))) || this.resultsContainer.removeGroupingFunction(attributes))) {
                try {
                    this.resultsContainer.rebuildGrouping();
                }
                catch (DBException e) {
                    DBUserInterface.getInstance().showError("Grouping error", "Can't change grouping query", (Throwable)e);
                }
            }
        }
    }

    static class EditColumnsAction
    extends GroupingAction {
        public EditColumnsAction(GroupingResultsContainer resultsContainer) {
            super(resultsContainer, CoreMessages.controls_resultset_grouping_edit, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.OBJ_ADD));
        }

        public void run() {
            GroupingConfigDialog dialog = new GroupingConfigDialog(this.resultsContainer.getResultSetController().getControl().getShell(), this.resultsContainer);
            if (dialog.open() == 0) {
                try {
                    this.resultsContainer.rebuildGrouping();
                }
                catch (DBException e) {
                    DBUserInterface.getInstance().showError("Grouping error", "Can't change grouping settings", (Throwable)e);
                }
            }
        }
    }

    static abstract class GroupingAction
    extends Action {
        protected final GroupingResultsContainer resultsContainer;

        public GroupingAction(GroupingResultsContainer resultsContainer, String text, ImageDescriptor image) {
            super(text, image);
            this.resultsContainer = resultsContainer;
        }
    }
}

