/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

class TransformerSettingsDialog
extends BaseDialog {
    private static final Log log = Log.getLog(TransformerSettingsDialog.class);
    private final ResultSetViewer viewer;
    private final DBDAttributeBinding attr;
    private final DBVTransformSettings settings;
    private PropertyTreeViewer propertiesEditor;
    private PropertySourceCustom propertySource;

    public TransformerSettingsDialog(ResultSetViewer viewer, DBDAttributeBinding attr, DBVTransformSettings settings) {
        super(viewer.getControl().getShell(), "Transformer settings", null);
        this.viewer = viewer;
        this.attr = attr;
        this.settings = settings;
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        Map transformOptions;
        DBDAttributeTransformerDescriptor transformer;
        Composite composite = super.createDialogArea(parent);
        DBPDataSource dataSource = this.viewer.getDataContainer() == null ? null : this.viewer.getDataContainer().getDataSource();
        List properties = Collections.emptyList();
        if (dataSource != null && !CommonUtils.isEmpty((String)this.settings.getCustomTransformer())) {
            transformer = dataSource.getContainer().getPlatform().getValueHandlerRegistry().getTransformer(this.settings.getCustomTransformer());
            if (transformer != null) {
                properties = transformer.getProperties();
            }
        } else {
            transformer = null;
        }
        if (transformer != null) {
            Group placeholder = UIUtils.createControlGroup((Composite)composite, (String)"Transformer", (int)2, (int)768, (int)-1);
            UIUtils.createLabelText((Composite)placeholder, (String)"Name", (String)transformer.getName(), (int)8);
            Label infoLabel = UIUtils.createControlLabel((Composite)placeholder, (String)"Info");
            infoLabel.setLayoutData((Object)new GridData(2));
            Text infoText = new Text((Composite)placeholder, 72);
            if (transformer.getDescription() != null) {
                infoText.setText(transformer.getDescription());
            }
            GridData gd = new GridData(768);
            gd.widthHint = 300;
            infoText.setLayoutData((Object)gd);
        }
        if ((transformOptions = this.settings.getTransformOptions()) == null) {
            transformOptions = Collections.emptyMap();
        }
        this.propertiesEditor = new PropertyTreeViewer(composite, 2048);
        this.propertySource = new PropertySourceCustom(properties, transformOptions);
        this.propertiesEditor.loadProperties(this.propertySource);
        this.propertiesEditor.getControl().setFocus();
        if (CommonUtils.isEmpty((Collection)properties)) {
            UIUtils.asyncExec(this::okPressed);
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        Map<Object, Object> properties = this.propertySource.getPropertiesWithDefaults();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            if (prop.getValue() == null) continue;
            this.settings.setTransformOption(prop.getKey().toString(), prop.getValue().toString());
        }
        super.okPressed();
    }
}

