/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.ui.dialogs.ViewExceptionDialog;
import org.jkiss.utils.CommonUtils;

class StatusDetailsDialog
extends EditTextDialog {
    private static final String DIALOG_ID = "DBeaver.StatusDetailsDialog";
    private final List<Throwable> warnings;
    private Table warnTable;

    public StatusDetailsDialog(Shell shell, String message, List<Throwable> warnings) {
        super(shell, "Status details", message);
        this.warnings = warnings;
        this.textHeight = 100;
        this.setReadonly(true);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    @Override
    protected void createControlsBeforeText(Composite composite) {
        UIUtils.createControlLabel((Composite)composite, (String)"Message");
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        if (!CommonUtils.isEmpty(this.warnings)) {
            UIUtils.createControlLabel((Composite)composite, (String)"Warnings");
            this.warnTable = new Table(composite, 67584);
            TableColumn exColumn = UIUtils.createTableColumn((Table)this.warnTable, (int)0, (String)"Exception");
            TableColumn msgColumn = UIUtils.createTableColumn((Table)this.warnTable, (int)0, (String)"Message");
            this.warnTable.setLinesVisible(true);
            GridData gd = new GridData(1808);
            gd.minimumHeight = 100;
            this.warnTable.setLayoutData((Object)gd);
            for (Throwable ex : this.warnings) {
                TableItem warnItem = new TableItem(this.warnTable, 0);
                warnItem.setText(0, ex.getClass().getName());
                if (ex.getMessage() != null) {
                    warnItem.setText(1, ex.getMessage());
                }
                warnItem.setData((Object)ex);
            }
            exColumn.pack();
            msgColumn.pack();
            this.warnTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    StatusDetailsDialog.this.openWarning();
                }
            });
            this.warnTable.addTraverseListener(e -> {
                if (e.detail == 4) {
                    this.openWarning();
                    e.doit = false;
                }
            });
        }
        return composite;
    }

    private void openWarning() {
        TableItem[] selection = this.warnTable.getSelection();
        if (selection.length == 0) {
            return;
        }
        Throwable error = (Throwable)selection[0].getData();
        ViewExceptionDialog veDialog = new ViewExceptionDialog(this.getShell(), error);
        veDialog.open();
    }
}

