/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Collection;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCommandHandler;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.utils.CommonUtils;

public class ResultSetPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.resultset";
    public static final String PROP_ACTIVE = "active";
    public static final String PROP_HAS_DATA = "hasData";
    public static final String PROP_HAS_MORE_DATA = "hasMoreData";
    public static final String PROP_CAN_COPY = "canCopy";
    public static final String PROP_CAN_PASTE = "canPaste";
    public static final String PROP_CAN_CUT = "canCut";
    public static final String PROP_CAN_MOVE = "canMove";
    public static final String PROP_CAN_TOGGLE = "canToggle";
    public static final String PROP_CAN_SWITCH_PRESENTATION = "canSwitchPresentation";
    public static final String PROP_CAN_NAVIGATE_LINK = "canNavigateLink";
    public static final String PROP_SUPPORTS_COUNT = "supportsCount";
    public static final String PROP_CAN_NAVIGATE_HISTORY = "canNavigateHistory";
    public static final String PROP_EDITABLE = "editable";
    public static final String PROP_CHANGED = "changed";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        ResultSetViewer rsv = (ResultSetViewer)ResultSetCommandHandler.getActiveResultSet((IWorkbenchPart)receiver);
        return rsv != null && this.checkResultSetProperty(rsv, property, expectedValue);
    }

    private boolean checkResultSetProperty(ResultSetViewer rsv, String property, Object expectedValue) {
        boolean actionsDisabled = rsv.isActionsDisabled();
        switch (property) {
            case "active": {
                return true;
            }
            case "hasData": {
                return rsv.getModel().hasData();
            }
            case "hasMoreData": {
                return rsv.isHasMoreData();
            }
            case "canCopy": {
                return !actionsDisabled && rsv.getModel().hasData();
            }
            case "canCut": 
            case "canPaste": {
                DBDAttributeBinding attr = rsv.getActivePresentation().getCurrentAttribute();
                return !actionsDisabled && attr != null && !rsv.isAttributeReadOnly(attr);
            }
            case "canMove": {
                if (actionsDisabled) {
                    return false;
                }
                ResultSetRow currentRow = rsv.getCurrentRow();
                if ("back".equals(expectedValue)) {
                    return currentRow != null && currentRow.getVisualNumber() > 0;
                }
                if (!"forward".equals(expectedValue)) break;
                return currentRow != null && currentRow.getVisualNumber() < rsv.getModel().getRowCount() - 1;
            }
            case "editable": {
                if (actionsDisabled || !rsv.hasData()) {
                    return false;
                }
                if ("edit".equals(expectedValue) || "inline".equals(expectedValue)) {
                    DBDAttributeBinding attr = rsv.getActivePresentation().getCurrentAttribute();
                    if (attr == null) {
                        return false;
                    }
                    if ("inline".equals(expectedValue)) {
                        return !rsv.isAttributeReadOnly(attr);
                    }
                    return true;
                }
                if ("add".equals(expectedValue)) {
                    return rsv.isInsertable();
                }
                if ("copy".equals(expectedValue) || "delete".equals(expectedValue)) {
                    ResultSetRow currentRow = rsv.getCurrentRow();
                    return currentRow != null && rsv.isInsertable();
                }
                return false;
            }
            case "changed": {
                return rsv.isDirty();
            }
            case "canToggle": {
                return !actionsDisabled && rsv.isPresentationInFocus();
            }
            case "canSwitchPresentation": {
                return !actionsDisabled && !rsv.isRefreshInProgress() && rsv.getAvailablePresentations() != null && rsv.getAvailablePresentations().size() > 1;
            }
            case "supportsCount": {
                return rsv.hasData() && rsv.isHasMoreData() && (rsv.getDataContainer().getSupportedFeatures() & 1) != 0;
            }
            case "canNavigateLink": {
                DBDAttributeBinding attr;
                ResultSetRow row;
                if (!actionsDisabled && rsv.getModel().hasData() && (row = rsv.getCurrentRow()) != null && (attr = rsv.getActivePresentation().getCurrentAttribute()) != null) {
                    Object value = rsv.getModel().getCellValue(attr, row);
                    return !CommonUtils.isEmpty((Collection)attr.getReferrers()) && !DBUtils.isNullValue((Object)value);
                }
                return false;
            }
            case "canNavigateHistory": {
                if (actionsDisabled || !rsv.getModel().hasData()) break;
                if (expectedValue instanceof Number && ((Number)expectedValue).intValue() == 1 || "1".equals(expectedValue)) {
                    return rsv.getHistoryPosition() < rsv.getHistorySize() - 1;
                }
                return rsv.getHistoryPosition() > 0;
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.resultset." + propName));
    }
}

