/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.ILazyPropertyLoadListener;
import org.jkiss.dbeaver.runtime.properties.PropertiesContributor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;

public class PropertyPageStandard
extends PropertySheetPage
implements ILazyPropertyLoadListener,
IPropertySourceProvider {
    private PropertySourceCache[] curSelection = null;

    public PropertyPageStandard() {
        this.setSorter(new PropertySheetSorter(){

            public int compare(IPropertySheetEntry entryA, IPropertySheetEntry entryB) {
                return 0;
            }
        });
        this.setPropertySourceProvider(this);
        PropertiesContributor.getInstance().addLazyListener(this);
    }

    public void dispose() {
        PropertiesContributor.getInstance().removeLazyListener(this);
        super.dispose();
    }

    @Override
    public void handlePropertyLoad(Object object, DBPPropertyDescriptor property, Object propertyValue, boolean completed) {
        if (!ArrayUtils.isEmpty((Object[])this.curSelection) && !this.getControl().isDisposed()) {
            PropertySourceCache[] propertySourceCacheArray = this.curSelection;
            int n = this.curSelection.length;
            int n2 = 0;
            while (n2 < n) {
                PropertySourceCache cache = propertySourceCacheArray[n2];
                if (cache.propertySource != null && cache.propertySource.getEditableValue() == object || cache.object == object) {
                    this.refresh();
                    return;
                }
                ++n2;
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.curSelection = new PropertySourceCache[ss.size()];
            if (ss.size() == 1) {
                this.curSelection[0] = new PropertySourceCache(ss.getFirstElement());
            } else {
                int index = 0;
                Iterator iter = ss.iterator();
                while (iter.hasNext()) {
                    this.curSelection[index++] = new PropertySourceCache(iter.next());
                }
            }
        }
        this.getControl().setRedraw(false);
        try {
            super.selectionChanged(part, selection);
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    public IPropertySource getPropertySource(Object object) {
        if (object == null || object.getClass().isPrimitive() || object instanceof CharSequence || object instanceof Number || object instanceof Boolean) {
            return null;
        }
        if (!ArrayUtils.isEmpty((Object[])this.curSelection)) {
            PropertySourceCache[] propertySourceCacheArray = this.curSelection;
            int n = this.curSelection.length;
            int n2 = 0;
            while (n2 < n) {
                PropertySourceCache cache = propertySourceCacheArray[n2];
                if (cache.object == object) {
                    if (!cache.cached) {
                        cache.propertySource = (IPropertySource)RuntimeUtils.getObjectAdapter((Object)object, IPropertySource.class);
                        cache.cached = true;
                    }
                    return cache.propertySource;
                }
                ++n2;
            }
        }
        return (IPropertySource)RuntimeUtils.getObjectAdapter((Object)object, IPropertySource.class);
    }

    private static class PropertySourceCache {
        Object object;
        IPropertySource propertySource;
        boolean cached;

        public PropertySourceCache(Object object) {
            this.object = object instanceof IPropertySource ? ((IPropertySource)object).getEditableValue() : object;
        }
    }
}

