/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.IDataSourceContainerProviderEx;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.runtime.jobs.DisconnectJob;
import org.jkiss.dbeaver.runtime.jobs.InvalidateJob;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.ConnectionLostDialog;
import org.jkiss.dbeaver.ui.dialogs.StandardErrorDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;

public class DataSourceInvalidateHandler
extends AbstractDataSourceHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBCExecutionContext context = this.getExecutionContext(event, false);
        if (context != null) {
            DataSourceInvalidateHandler.invalidateDataSource(context.getDataSource());
        } else {
            DBPDataSourceContainer dsContainer;
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editor instanceof IDataSourceContainerProviderEx && (dsContainer = ((IDataSourceContainerProviderEx)editor).getDataSourceContainer()) != null) {
                ((IDataSourceContainerProviderEx)editor).setDataSourceContainer(dsContainer);
            }
        }
        return null;
    }

    public static void invalidateDataSource(final DBPDataSource dataSource) {
        if (dataSource != null) {
            if (!ArrayUtils.isEmpty((Object[])Job.getJobManager().find((Object)dataSource.getContainer()))) {
                return;
            }
            final InvalidateJob invalidateJob = new InvalidateJob(dataSource);
            invalidateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    StringBuilder message = new StringBuilder();
                    Exception error = null;
                    int totalNum = 0;
                    int connectedNum = 0;
                    int aliveNum = 0;
                    for (InvalidateJob.ContextInvalidateResult result : invalidateJob.getInvalidateResults()) {
                        ++totalNum;
                        if (result.error != null) {
                            error = result.error;
                        }
                        switch (result.result) {
                            case CONNECTED: 
                            case RECONNECTED: {
                                ++connectedNum;
                                break;
                            }
                            case ALIVE: {
                                ++aliveNum;
                                break;
                            }
                        }
                    }
                    if (connectedNum > 0) {
                        message.insert(0, "Connections reopened: " + connectedNum + " (of " + totalNum + ")");
                    } else if (message.length() == 0) {
                        message.insert(0, "All connections (" + totalNum + ") are alive!");
                    }
                    if (error != null) {
                        UIUtils.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                        final DBPDataSourceContainer container = dataSource.getContainer();
                        final Exception dialogError = error;
                        Integer result = (Integer)new UITask<Integer>(){

                            protected Integer runTask() {
                                ConnectionLostDialog clDialog = new ConnectionLostDialog(null, container, dialogError, "Disconnect");
                                return clDialog.open();
                            }
                        }.execute();
                        if (result == 6) {
                            new DisconnectJob(container).schedule();
                        } else if (result == 8) {
                            DataSourceInvalidateHandler.invalidateDataSource(dataSource);
                        }
                    } else {
                        log.debug((Object)message);
                    }
                }
            });
            invalidateJob.schedule();
        }
    }

    public static void showConnectionLostDialog(Shell shell, String message, DBException error) {
        Runnable runnable = () -> {
            DBPDataSource dataSource = error.getDataSource();
            if (dataSource == null) {
                throw new IllegalStateException("No data source in error");
            }
            String title = "Connection with [" + dataSource.getContainer().getName() + "] lost";
            ConnectionRecoverDialog dialog = new ConnectionRecoverDialog(shell, title, message == null ? title : message, error);
            dialog.open();
        };
        UIUtils.syncExec((Runnable)runnable);
    }

    private static class ConnectionRecoverDialog
    extends StandardErrorDialog {
        private final DBPDataSource dataSource;

        ConnectionRecoverDialog(Shell shell, String title, String message, DBException error) {
            super(shell == null ? UIUtils.getActiveWorkbenchShell() : shell, title, message, GeneralUtils.makeExceptionStatus((Throwable)error), 4);
            this.dataSource = error.getDataSource();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 8, "&Reconnect", true);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.createDetailsButton(parent);
        }

        protected void buttonPressed(int id) {
            if (id == 8) {
                DataSourceInvalidateHandler.invalidateDataSource(this.dataSource);
                super.buttonPressed(0);
            }
            super.buttonPressed(id);
        }
    }
}

