/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.transfer.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.registry.transfer.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.registry.transfer.DataTransferRegistry;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferSettings {
    private static final Log log = Log.getLog(DataTransferSettings.class);
    private static final int DEFAULT_THREADS_NUM = 1;
    private List<DataTransferPipe> dataPipes;
    private DataTransferNodeDescriptor producer;
    private DataTransferNodeDescriptor consumer;
    private DataTransferProcessorDescriptor processor;
    private Map<DataTransferProcessorDescriptor, Map<Object, Object>> processorPropsHistory = new HashMap<DataTransferProcessorDescriptor, Map<Object, Object>>();
    private Map<Class, NodeSettings> nodeSettings = new LinkedHashMap<Class, NodeSettings>();
    private boolean consumerOptional;
    private int maxJobCount = 1;
    private transient int curPipeNum = 0;

    public DataTransferSettings(@Nullable IDataTransferProducer[] producers, @Nullable IDataTransferConsumer[] consumers) {
        DataTransferNodeDescriptor node;
        int n;
        int n2;
        IDataTransferNode<SETTINGS>[] iDataTransferNodeArray;
        int n3;
        IDataTransferNode<SETTINGS>[] iDataTransferNodeArray2;
        this.dataPipes = new ArrayList<DataTransferPipe>();
        if (!ArrayUtils.isEmpty((Object[])producers) && !ArrayUtils.isEmpty((Object[])consumers)) {
            if (producers.length != consumers.length) {
                throw new IllegalArgumentException("Producers number must match consumers number");
            }
            int i = 0;
            while (i < producers.length) {
                this.dataPipes.add(new DataTransferPipe(producers[i], consumers[i]));
                ++i;
            }
            this.consumerOptional = false;
        } else if (!ArrayUtils.isEmpty((Object[])producers)) {
            iDataTransferNodeArray2 = producers;
            n3 = producers.length;
            int n4 = 0;
            while (n4 < n3) {
                IDataTransferNode source = iDataTransferNodeArray2[n4];
                this.dataPipes.add(new DataTransferPipe((IDataTransferProducer)source, null));
                ++n4;
            }
            Class<?> producerType = this.dataPipes.get(0).getProducer().getClass();
            DataTransferNodeDescriptor producerDesc = DataTransferRegistry.getInstance().getNodeByType(producerType);
            if (producerDesc != null) {
                this.selectProducer(producerDesc);
                this.consumerOptional = true;
            } else {
                DBUserInterface.getInstance().showError("Can't find producer", "Can't find data propducer descriptor in registry");
            }
        } else if (!ArrayUtils.isEmpty((Object[])consumers)) {
            iDataTransferNodeArray2 = consumers;
            n3 = consumers.length;
            int producerDesc = 0;
            while (producerDesc < n3) {
                IDataTransferNode target = iDataTransferNodeArray2[producerDesc];
                this.dataPipes.add(new DataTransferPipe(null, (IDataTransferConsumer)target));
                ++producerDesc;
            }
            Class<?> consumerType = this.dataPipes.get(0).getConsumer().getClass();
            DataTransferNodeDescriptor consumerDesc = DataTransferRegistry.getInstance().getNodeByType(consumerType);
            if (consumerDesc != null) {
                this.selectConsumer(consumerDesc, null);
                this.consumerOptional = false;
            } else {
                DBUserInterface.getInstance().showError("Can't find producer", "Can't find data propducer descriptor in registry");
            }
        } else {
            throw new IllegalArgumentException("Producers or consumers must be specified");
        }
        Collection<DBSObject> objectTypes = this.getSourceObjects();
        ArrayList<DataTransferNodeDescriptor> nodes = new ArrayList<DataTransferNodeDescriptor>();
        DataTransferRegistry registry = DataTransferRegistry.getInstance();
        if (ArrayUtils.isEmpty((Object[])producers)) {
            nodes.addAll(registry.getAvailableProducers(objectTypes));
        } else {
            iDataTransferNodeArray = producers;
            n2 = producers.length;
            n = 0;
            while (n < n2) {
                IDataTransferProducer source = iDataTransferNodeArray[n];
                node = registry.getNodeByType(source.getClass());
                if (node != null && !nodes.contains((Object)node)) {
                    nodes.add(node);
                }
                ++n;
            }
        }
        if (ArrayUtils.isEmpty((Object[])consumers)) {
            nodes.addAll(registry.getAvailableConsumers(objectTypes));
        } else {
            iDataTransferNodeArray = consumers;
            n2 = consumers.length;
            n = 0;
            while (n < n2) {
                IDataTransferNode target = iDataTransferNodeArray[n];
                node = registry.getNodeByType(target.getClass());
                if (node != null && !nodes.contains((Object)node)) {
                    nodes.add(node);
                    this.consumer = node;
                }
                ++n;
            }
        }
        for (DataTransferNodeDescriptor node2 : nodes) {
            this.addNodeSettings(node2);
        }
    }

    private void addNodeSettings(DataTransferNodeDescriptor node) {
        if (node == null) {
            return;
        }
        Class<? extends IDataTransferNode> nodeClass = node.getNodeClass();
        if (this.nodeSettings.containsKey(nodeClass)) {
            return;
        }
        try {
            this.nodeSettings.put(nodeClass, new NodeSettings(node));
        }
        catch (DBException e) {
            log.error((Object)("Can't add node '" + node.getId() + "'"), (Throwable)e);
        }
    }

    void addWizardPages(DataTransferWizard wizard) {
        for (NodeSettings nodeSettings : this.nodeSettings.values()) {
            if (nodeSettings.pages == null) continue;
            IWizardPage[] iWizardPageArray = nodeSettings.pages;
            int n = nodeSettings.pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                wizard.addPage(page);
                ++n2;
            }
        }
    }

    public boolean isConsumerOptional() {
        return this.consumerOptional;
    }

    public boolean isPageValid(IWizardPage page) {
        return this.isPageValid(page, this.producer) || this.isPageValid(page, this.consumer);
    }

    private boolean isPageValid(IWizardPage page, DataTransferNodeDescriptor node) {
        NodeSettings nodeSettings;
        NodeSettings nodeSettings2 = nodeSettings = node == null ? null : this.nodeSettings.get(node.getNodeClass());
        return nodeSettings != null && ArrayUtils.contains((Object[])nodeSettings.pages, (Object)page);
    }

    public Collection<DBSObject> getSourceObjects() {
        List<DataTransferPipe> dataPipes = this.getDataPipes();
        HashSet<DBSObject> objects = new HashSet<DBSObject>();
        for (DataTransferPipe transferPipe : dataPipes) {
            if (transferPipe.getProducer() == null) continue;
            objects.add(transferPipe.getProducer().getSourceObject());
        }
        return objects;
    }

    public IDataTransferSettings getNodeSettings(IWizardPage page) {
        for (NodeSettings nodeSettings : this.nodeSettings.values()) {
            if (nodeSettings.pages == null) continue;
            IWizardPage[] iWizardPageArray = nodeSettings.pages;
            int n = nodeSettings.pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage nodePage = iWizardPageArray[n2];
                if (nodePage == page) {
                    return nodeSettings.settings;
                }
                ++n2;
            }
        }
        return null;
    }

    public IDataTransferSettings getNodeSettings(IDataTransferNode node) {
        NodeSettings nodeSettings = this.nodeSettings.get(node.getClass());
        return nodeSettings == null ? null : nodeSettings.settings;
    }

    public Map<Object, Object> getProcessorProperties() {
        if (this.processor == null) {
            throw new IllegalStateException("No processor selected");
        }
        return this.processorPropsHistory.get((Object)this.processor);
    }

    public void setProcessorProperties(Map<Object, Object> properties) {
        if (this.processor == null) {
            throw new IllegalStateException("No processor selected");
        }
        this.processorPropsHistory.put(this.processor, properties);
    }

    public List<DataTransferPipe> getDataPipes() {
        return this.dataPipes;
    }

    public synchronized DataTransferPipe acquireDataPipe(DBRProgressMonitor monitor) {
        if (this.curPipeNum >= this.dataPipes.size()) {
            if (!this.dataPipes.isEmpty()) {
                this.dataPipes.get(this.dataPipes.size() - 1).getConsumer().finishTransfer(monitor, true);
            }
            return null;
        }
        DataTransferPipe result = this.dataPipes.get(this.curPipeNum);
        ++this.curPipeNum;
        return result;
    }

    public DataTransferNodeDescriptor getProducer() {
        return this.producer;
    }

    public DataTransferNodeDescriptor getConsumer() {
        return this.consumer;
    }

    public DataTransferProcessorDescriptor getProcessor() {
        return this.processor;
    }

    private void selectProducer(DataTransferNodeDescriptor producer) {
        this.producer = producer;
    }

    void selectConsumer(DataTransferNodeDescriptor consumer, DataTransferProcessorDescriptor processor) {
        this.consumer = consumer;
        this.processor = processor;
        if (consumer != null && processor != null && !this.processorPropsHistory.containsKey((Object)processor)) {
            this.processorPropsHistory.put(processor, new HashMap());
        }
        for (DataTransferPipe pipe : this.dataPipes) {
            if (consumer != null) {
                try {
                    pipe.setConsumer((IDataTransferConsumer)consumer.createNode());
                }
                catch (DBException e) {
                    log.error((Object)e);
                    pipe.setConsumer(null);
                }
                continue;
            }
            pipe.setConsumer(null);
        }
    }

    public int getMaxJobCount() {
        return this.maxJobCount;
    }

    public void setMaxJobCount(int maxJobCount) {
        if (maxJobCount > 0) {
            this.maxJobCount = maxJobCount;
        }
    }

    /*
     * WARNING - void declaration
     */
    void loadFrom(IRunnableContext runnableContext, IDialogSettings dialogSettings) {
        String processorId;
        DataTransferNodeDescriptor dataTransferNodeDescriptor;
        try {
            this.maxJobCount = dialogSettings.getInt("maxJobCount");
        }
        catch (NumberFormatException e) {
            this.maxJobCount = 1;
        }
        String producerId = dialogSettings.get("producer");
        if (!CommonUtils.isEmpty((String)producerId) && (dataTransferNodeDescriptor = DataTransferRegistry.getInstance().getNodeById(producerId)) != null) {
            this.producer = dataTransferNodeDescriptor;
        }
        if (this.consumerOptional) {
            void var4_8;
            DataTransferNodeDescriptor consumerNode;
            Object var4_6 = null;
            String consumerId = dialogSettings.get("consumer");
            if (!CommonUtils.isEmpty((String)consumerId) && (consumerNode = DataTransferRegistry.getInstance().getNodeById(consumerId)) != null) {
                DataTransferNodeDescriptor dataTransferNodeDescriptor2 = consumerNode;
            }
            DataTransferProcessorDescriptor savedProcessor = null;
            if (var4_8 != null && !CommonUtils.isEmpty((String)(processorId = dialogSettings.get("processor")))) {
                savedProcessor = var4_8.getProcessor(processorId);
            }
            if (var4_8 != null) {
                this.selectConsumer((DataTransferNodeDescriptor)var4_8, savedProcessor);
            }
        }
        for (Map.Entry entry : this.nodeSettings.entrySet()) {
            IDialogSettings nodeSection = DialogSettings.getOrCreateSection((IDialogSettings)dialogSettings, (String)((Class)entry.getKey()).getSimpleName());
            ((NodeSettings)entry.getValue()).settings.loadSettings(runnableContext, this, nodeSection);
        }
        IDialogSettings iDialogSettings = dialogSettings.getSection("processors");
        if (iDialogSettings != null) {
            for (IDialogSettings procSection : ArrayUtils.safeArray((Object[])iDialogSettings.getSections())) {
                processorId = procSection.getName();
                String nodeId = procSection.get("@node");
                String propNamesId = procSection.get("@propNames");
                DataTransferNodeDescriptor node = DataTransferRegistry.getInstance().getNodeById(nodeId);
                if (node == null) continue;
                HashMap<String, String> props = new HashMap<String, String>();
                DataTransferProcessorDescriptor nodeProcessor = node.getProcessor(processorId);
                if (nodeProcessor == null) continue;
                for (String prop : CommonUtils.splitString((String)propNamesId, (char)',')) {
                    props.put(prop, procSection.get(prop));
                }
                this.processorPropsHistory.put(nodeProcessor, props);
                NodeSettings nodeSettings = this.nodeSettings.get(node.getNodeClass());
            }
        }
    }

    void saveTo(IDialogSettings dialogSettings) {
        dialogSettings.put("maxJobCount", this.maxJobCount);
        for (Map.Entry<Class, NodeSettings> entry : this.nodeSettings.entrySet()) {
            IDialogSettings nodeSection = DialogSettings.getOrCreateSection((IDialogSettings)dialogSettings, (String)entry.getKey().getSimpleName());
            entry.getValue().settings.saveSettings(nodeSection);
        }
        if (this.producer != null) {
            dialogSettings.put("producer", this.producer.getId());
        }
        if (this.consumer != null) {
            dialogSettings.put("consumer", this.consumer.getId());
        }
        if (this.processor != null) {
            dialogSettings.put("processor", this.processor.getId());
        }
        IDialogSettings processorsSection = DialogSettings.getOrCreateSection((IDialogSettings)dialogSettings, (String)"processors");
        for (DataTransferProcessorDescriptor procDescriptor : this.processorPropsHistory.keySet()) {
            IDialogSettings procSettings = DialogSettings.getOrCreateSection((IDialogSettings)processorsSection, (String)procDescriptor.getId());
            procSettings.put("@node", procDescriptor.getNode().getId());
            Map<Object, Object> props = this.processorPropsHistory.get((Object)procDescriptor);
            if (props == null) continue;
            StringBuilder propNames = new StringBuilder();
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                propNames.append(prop.getKey()).append(',');
            }
            procSettings.put("@propNames", propNames.toString());
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                procSettings.put(CommonUtils.toString((Object)prop.getKey()), CommonUtils.toString((Object)prop.getValue()));
            }
        }
    }

    public static class NodeSettings {
        DataTransferNodeDescriptor sourceNode;
        IDataTransferSettings settings;
        IWizardPage[] pages;

        private NodeSettings(DataTransferNodeDescriptor sourceNode) throws DBException {
            this.sourceNode = sourceNode;
            this.settings = sourceNode.createSettings();
            this.pages = sourceNode.createWizardPages();
        }
    }
}

