/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferErrorJob;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferJob
extends AbstractJob {
    private DataTransferSettings settings;

    public DataTransferJob(DataTransferSettings settings) {
        super(CoreMessages.data_transfer_wizard_job_name);
        this.settings = settings;
        this.setUser(true);
    }

    public boolean belongsTo(Object family) {
        return family == this.settings;
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        DataTransferPipe transferPipe;
        boolean hasErrors = false;
        long startTime = System.currentTimeMillis();
        while ((transferPipe = this.settings.acquireDataPipe(monitor)) != null) {
            if (this.transferData(monitor, transferPipe)) continue;
            hasErrors = true;
        }
        this.showResult(System.currentTimeMillis() - startTime, hasErrors);
        return Status.OK_STATUS;
    }

    private void showResult(final long time, final boolean hasErrors) {
        UIUtils.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Display.getCurrent().beep();
                if (time > DBeaverCore.getGlobalPreferenceStore().getLong("agent.long.operation.timeout") * 1000L) {
                    DBeaverUI.notifyAgent("Data transfer completed", !hasErrors ? 1 : 4);
                }
                UIUtils.showMessageBox(null, (String)"Data transfer", (String)("Data transfer completed " + (hasErrors ? "with errors " : "") + "(" + RuntimeUtils.formatExecutionTime((long)time) + ")"), (int)(hasErrors ? 1 : 2));
            }
        });
    }

    private boolean transferData(DBRProgressMonitor monitor, DataTransferPipe transferPipe) {
        IDataTransferProducer producer = transferPipe.getProducer();
        IDataTransferConsumer consumer = transferPipe.getConsumer();
        IDataTransferSettings consumerSettings = this.settings.getNodeSettings(consumer);
        this.setName(NLS.bind((String)CoreMessages.data_transfer_wizard_job_container_name, (Object)CommonUtils.truncateString((String)producer.getSourceObject().getName(), (int)200)));
        IDataTransferSettings nodeSettings = this.settings.getNodeSettings(producer);
        try {
            producer.transferData(monitor, consumer, nodeSettings);
            consumer.finishTransfer(monitor, false);
            return true;
        }
        catch (Exception e) {
            new DataTransferErrorJob(e).schedule();
            return false;
        }
    }
}

