/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.utils.CommonUtils;

public class DatabaseConsumerSettings
implements IDataTransferSettings {
    private static final Log log = Log.getLog(DatabaseConsumerSettings.class);
    private String containerNodePath;
    private DBNDatabaseNode containerNode;
    private Map<DBSDataContainer, DatabaseMappingContainer> dataMappings = new LinkedHashMap<DBSDataContainer, DatabaseMappingContainer>();
    private boolean openNewConnections = true;
    private boolean useTransactions = true;
    private int commitAfterRows = 10000;
    private boolean truncateBeforeLoad = false;
    private boolean openTableOnFinish = true;

    @Nullable
    public DBSObjectContainer getContainer() {
        if (this.containerNode == null) {
            return null;
        }
        return (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)this.containerNode.getObject());
    }

    public DBNDatabaseNode getContainerNode() {
        return this.containerNode;
    }

    public void setContainerNode(DBNDatabaseNode containerNode) {
        this.containerNode = containerNode;
    }

    public Map<DBSDataContainer, DatabaseMappingContainer> getDataMappings() {
        return this.dataMappings;
    }

    public DatabaseMappingContainer getDataMapping(DBSDataContainer dataContainer) {
        return this.dataMappings.get(dataContainer);
    }

    public boolean isCompleted(Collection<DataTransferPipe> pipes) {
        for (DataTransferPipe pipe : pipes) {
            DBSDataContainer sourceObject;
            DatabaseMappingContainer containerMapping;
            if (pipe.getProducer() == null || (containerMapping = this.dataMappings.get(sourceObject = (DBSDataContainer)pipe.getProducer().getSourceObject())) != null && containerMapping.getMappingType() != DatabaseMappingType.unspecified && containerMapping.isCompleted()) continue;
            return false;
        }
        return true;
    }

    public boolean isTruncateBeforeLoad() {
        return this.truncateBeforeLoad;
    }

    public void setTruncateBeforeLoad(boolean truncateBeforeLoad) {
        this.truncateBeforeLoad = truncateBeforeLoad;
    }

    public boolean isOpenTableOnFinish() {
        return this.openTableOnFinish;
    }

    public void setOpenTableOnFinish(boolean openTableOnFinish) {
        this.openTableOnFinish = openTableOnFinish;
    }

    public boolean isOpenNewConnections() {
        return this.openNewConnections;
    }

    public void setOpenNewConnections(boolean openNewConnections) {
        this.openNewConnections = openNewConnections;
    }

    public boolean isUseTransactions() {
        return this.useTransactions;
    }

    public void setUseTransactions(boolean useTransactions) {
        this.useTransactions = useTransactions;
    }

    public int getCommitAfterRows() {
        return this.commitAfterRows;
    }

    public void setCommitAfterRows(int commitAfterRows) {
        this.commitAfterRows = commitAfterRows;
    }

    @Nullable
    DBPDataSource getTargetDataSource(DatabaseMappingObject attrMapping) {
        DBSObjectContainer container = this.getContainer();
        if (container != null) {
            return container.getDataSource();
        }
        if (attrMapping.getTarget() != null) {
            return attrMapping.getTarget().getDataSource();
        }
        return null;
    }

    @Override
    public void loadSettings(IRunnableContext runnableContext, DataTransferSettings dataTransferSettings, IDialogSettings dialogSettings) {
        DBSDataManipulator targetObject;
        IDataTransferConsumer consumer;
        List<DataTransferPipe> dataPipes;
        this.containerNodePath = dialogSettings.get("container");
        if (dialogSettings.get("openNewConnections") != null) {
            this.openNewConnections = dialogSettings.getBoolean("openNewConnections");
        }
        if (dialogSettings.get("useTransactions") != null) {
            this.useTransactions = dialogSettings.getBoolean("useTransactions");
        }
        if (dialogSettings.get("commitAfterRows") != null) {
            this.commitAfterRows = dialogSettings.getInt("commitAfterRows");
        }
        if (dialogSettings.get("truncateBeforeLoad") != null) {
            this.truncateBeforeLoad = dialogSettings.getBoolean("truncateBeforeLoad");
        }
        if (dialogSettings.get("openTableOnFinish") != null) {
            this.openTableOnFinish = dialogSettings.getBoolean("openTableOnFinish");
        }
        if (!(dataPipes = dataTransferSettings.getDataPipes()).isEmpty() && (consumer = dataPipes.get(0).getConsumer()) instanceof DatabaseTransferConsumer && (targetObject = ((DatabaseTransferConsumer)consumer).getTargetObject()) != null) {
            this.containerNode = DBeaverCore.getInstance().getNavigatorModel().findNode(targetObject.getParentObject());
        }
        this.checkContainerConnection(runnableContext);
    }

    private void checkContainerConnection(IRunnableContext runnableContext) {
        if (this.containerNode instanceof DBNDataSource && this.containerNode.getDataSource() == null) {
            try {
                runnableContext.run(true, true, monitor -> {
                    boolean bl = this.containerNode.initializeNode((DBRProgressMonitor)new DefaultProgressMonitor(monitor), null);
                });
            }
            catch (InvocationTargetException e) {
                DBUserInterface.getInstance().showError("Init connection", "Error connecting to datasource", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void saveSettings(IDialogSettings dialogSettings) {
        if (this.containerNode != null) {
            dialogSettings.put("container", this.containerNode.getNodeItemPath());
        }
        dialogSettings.put("openNewConnections", this.openNewConnections);
        dialogSettings.put("useTransactions", this.useTransactions);
        dialogSettings.put("commitAfterRows", this.commitAfterRows);
        dialogSettings.put("truncateBeforeLoad", this.truncateBeforeLoad);
        dialogSettings.put("openTableOnFinish", this.openTableOnFinish);
    }

    @NotNull
    public String getContainerFullName() {
        DBSObjectContainer container = this.getContainer();
        return container == null ? "" : (container instanceof DBPDataSource ? DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI) : String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI)) + " [" + container.getDataSource().getContainer().getName() + "]");
    }

    public void loadNode(IRunnableContext runnableContext) {
        if (this.containerNode == null && !CommonUtils.isEmpty((String)this.containerNodePath) && !CommonUtils.isEmpty((String)this.containerNodePath)) {
            try {
                runnableContext.run(true, true, monitor -> {
                    try {
                        DBNNode node = DBeaverCore.getInstance().getNavigatorModel().getNodeByPath((DBRProgressMonitor)new DefaultProgressMonitor(monitor), this.containerNodePath);
                        if (node instanceof DBNDatabaseNode) {
                            this.containerNode = (DBNDatabaseNode)node;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                this.checkContainerConnection(runnableContext);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Error getting container node", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

