/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.project;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.tools.project.ProjectExportData;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class ProjectExportWizardPage
extends WizardPage {
    private static final String PREF_PROJECTS_EXPORT_OUT_DIR = "export.projects.out.dir";
    private Text directoryText;
    private Table projectsTable;
    private Button exportDriverCheck;
    private Text fileNameText;
    private boolean fileNameEdited = false;

    protected ProjectExportWizardPage(String pageName) {
        super(pageName);
        this.setTitle(CoreMessages.dialog_project_export_wizard_start_title);
    }

    public boolean isPageComplete() {
        if (this.directoryText == null || this.directoryText.isDisposed() || this.projectsTable == null || this.projectsTable.isDisposed()) {
            return false;
        }
        if (CommonUtils.isEmpty((String)this.directoryText.getText())) {
            this.setMessage(CoreMessages.dialog_project_export_wizard_start_message_empty_output_directory, 3);
            return false;
        }
        TableItem[] tableItemArray = this.projectsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                this.setMessage(CoreMessages.dialog_project_export_wizard_start_message_configure_settings, 0);
                return true;
            }
            ++n2;
        }
        this.setMessage(CoreMessages.dialog_project_export_wizard_start_message_choose_project, 3);
        return false;
    }

    public void createControl(Composite parent) {
        IProject activeProject;
        String outDir = DBeaverCore.getGlobalPreferenceStore().getString(PREF_PROJECTS_EXPORT_OUT_DIR);
        if (CommonUtils.isEmpty((String)outDir)) {
            outDir = RuntimeUtils.getUserHomeDir().getAbsolutePath();
        }
        LinkedHashSet<IProject> projectList = new LinkedHashSet<IProject>();
        ISelection selection = UIUtils.getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IResource resource = (IResource)RuntimeUtils.getObjectAdapter(element, IResource.class);
                if (resource == null) continue;
                projectList.add(resource.getProject());
            }
        }
        if (projectList.isEmpty() && (activeProject = DBeaverCore.getInstance().getProjectRegistry().getActiveProject()) != null) {
            projectList.add(activeProject);
        }
        Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        placeholder.setLayout((Layout)new GridLayout(1, false));
        this.projectsTable = new Table(placeholder, 2082);
        GridData gd = new GridData(1808);
        this.projectsTable.setLayoutData((Object)gd);
        this.projectsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectExportWizardPage.this.updateState();
            }
        });
        for (IProject project : DBeaverCore.getInstance().getLiveProjects()) {
            TableItem item = new TableItem(this.projectsTable, 0);
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.PROJECT));
            item.setText(project.getName());
            item.setData((Object)project);
            if (!projectList.contains(project)) continue;
            item.setChecked(true);
        }
        Composite fileNameGroup = UIUtils.createPlaceholder((Composite)placeholder, (int)2);
        fileNameGroup.setLayoutData((Object)new GridData(768));
        this.fileNameText = UIUtils.createLabelText((Composite)fileNameGroup, (String)CoreMessages.dialog_project_export_wizard_start_label_output_file, null);
        this.fileNameText.setLayoutData((Object)new GridData(768));
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!CommonUtils.equalObjects((Object)ProjectExportWizardPage.this.fileNameText.getText(), (Object)ProjectExportWizardPage.getArchiveFileName(ProjectExportWizardPage.this.getProjectsToExport()))) {
                    ProjectExportWizardPage.this.fileNameEdited = true;
                }
            }
        });
        Composite generalSettings = UIUtils.createPlaceholder((Composite)placeholder, (int)3);
        generalSettings.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)generalSettings, (String)CoreMessages.dialog_project_export_wizard_start_label_directory);
        this.directoryText = new Text(generalSettings, 2048);
        this.directoryText.setText(outDir);
        this.directoryText.setLayoutData((Object)new GridData(768));
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectExportWizardPage.this.updateState();
            }
        });
        Button openFolder = new Button(generalSettings, 8);
        openFolder.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        openFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ProjectExportWizardPage.this.getShell(), 0);
                dialog.setMessage(CoreMessages.dialog_project_export_wizard_start_dialog_directory_message);
                dialog.setText(CoreMessages.dialog_project_export_wizard_start_dialog_directory_text);
                String directory = ProjectExportWizardPage.this.directoryText.getText();
                if (!CommonUtils.isEmpty((String)directory)) {
                    dialog.setFilterPath(directory);
                }
                if ((directory = dialog.open()) != null) {
                    ProjectExportWizardPage.this.directoryText.setText(directory);
                }
            }
        });
        this.exportDriverCheck = UIUtils.createCheckbox((Composite)placeholder, (String)CoreMessages.dialog_project_export_wizard_start_checkbox_libraries, (boolean)false);
        gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.exportDriverCheck.setLayoutData((Object)gd);
        this.setControl((Control)placeholder);
        this.updateState();
    }

    private void updateState() {
        if (!this.fileNameEdited) {
            String archiveFileName = ProjectExportWizardPage.getArchiveFileName(this.getProjectsToExport());
            this.fileNameText.setText(archiveFileName);
        }
        this.getContainer().updateButtons();
    }

    ProjectExportData getExportData() {
        String outputDir = this.directoryText.getText();
        DBeaverCore.getGlobalPreferenceStore().setValue(PREF_PROJECTS_EXPORT_OUT_DIR, outputDir);
        return new ProjectExportData(this.getProjectsToExport(), new File(outputDir), this.exportDriverCheck.getSelection(), this.fileNameText.getText());
    }

    private List<IProject> getProjectsToExport() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        TableItem[] tableItemArray = this.projectsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                result.add((IProject)item.getData());
            }
            ++n2;
        }
        return result;
    }

    static String getArchiveFileName(List<IProject> projects) {
        String archiveName = CoreMessages.dialog_project_export_wizard_start_archive_name_prefix;
        if (projects.size() == 1) {
            archiveName = projects.get(0).getName();
        }
        archiveName = String.valueOf(archiveName) + "-" + RuntimeUtils.getCurrentDate();
        return archiveName;
    }
}

