/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectEditor;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.prop.DBECommandProperty;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyHandler;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.runtime.properties.IPropertySourceEditable;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceAbstract;
import org.jkiss.utils.CommonUtils;

public class PropertySourceEditable
extends PropertySourceAbstract
implements DBPObject,
IPropertySourceEditable {
    private static final Log log = Log.getLog(PropertySourceEditable.class);
    private DBECommandContext commandContext;
    private PropertyChangeCommand lastCommand = null;
    private final CommandReflector commandReflector = new CommandReflector();

    public PropertySourceEditable(DBECommandContext commandContext, Object sourceObject, Object object) {
        super(sourceObject, object, true);
        this.commandContext = commandContext;
    }

    @Override
    public boolean isEditable(Object object) {
        DBEObjectEditor objectEditor = this.getObjectEditor(DBEObjectEditor.class);
        return objectEditor != null && object instanceof DBPObject && objectEditor.canEditObject((DBPObject)object);
    }

    private <T> T getObjectEditor(Class<T> managerType) {
        Object editableValue = this.getEditableValue();
        if (editableValue == null) {
            return null;
        }
        return EntityEditorsRegistry.getInstance().getObjectManager(editableValue.getClass(), managerType);
    }

    @Override
    public DBECommandContext getCommandContext() {
        return this.commandContext;
    }

    @Override
    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, Object editableValue, ObjectPropertyDescriptor prop, Object newValue) throws IllegalArgumentException {
        DBSObjectCache cache;
        DBEObjectMaker objectManager;
        if (prop.getValueTransformer() != null) {
            newValue = prop.getValueTransformer().transform(editableValue, newValue);
        }
        Object oldValue = this.getPropertyValue(monitor, editableValue, prop);
        if (!this.updatePropertyValue(monitor, editableValue, prop, newValue, false)) {
            return;
        }
        if (this.commandContext != null) {
            if (this.lastCommand == null || this.lastCommand.getObject() != editableValue || this.lastCommand.property != prop) {
                DBEObjectEditor objectEditor = this.getObjectEditor(DBEObjectEditor.class);
                if (objectEditor == null) {
                    log.error((Object)("Can't obtain object editor for " + this.getEditableValue()));
                    return;
                }
                DBEPropertyHandler propertyHandler = objectEditor.makePropertyHandler((DBPObject)editableValue, (DBPPropertyDescriptor)prop);
                PropertyChangeCommand curCommand = new PropertyChangeCommand((DBPObject)editableValue, prop, (DBEPropertyHandler<DBPObject>)propertyHandler, oldValue, newValue);
                this.commandContext.addCommand((DBECommand)curCommand, (DBECommandReflector)this.commandReflector);
                this.lastCommand = curCommand;
            } else {
                this.lastCommand.setNewValue(newValue);
                this.commandContext.updateCommand((DBECommand)this.lastCommand, (DBECommandReflector)this.commandReflector);
            }
        }
        if (prop.isNameProperty() && editableValue instanceof DBSObject && (objectManager = this.getObjectEditor(DBEObjectMaker.class)) != null && (cache = objectManager.getObjectsCache((DBSObject)editableValue)) != null && cache.isFullyCached()) {
            List cachedObjects = CommonUtils.copyList((Collection)cache.getCachedObjects());
            cache.setCache(cachedObjects);
        }
    }

    private boolean updatePropertyValue(@Nullable DBRProgressMonitor monitor, Object editableValue, ObjectPropertyDescriptor prop, Object value, boolean force) throws IllegalArgumentException {
        block10: {
            try {
                Object oldValue;
                Object[] items;
                if (value != null && value.getClass() == String.class && (items = prop.getPossibleValues(editableValue)) != null) {
                    boolean found = false;
                    if (items.length > 0) {
                        int i = 0;
                        int itemsLength = items.length;
                        while (i < itemsLength) {
                            if (items[i] instanceof DBPNamedObject && value.equals(((DBPNamedObject)items[i]).getName()) || items[i] instanceof Enum && value.equals(((Enum)items[i]).name())) {
                                value = items[i];
                                found = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (!found && value.getClass() != prop.getDataType()) {
                        value = null;
                    }
                }
                if (!CommonUtils.equalObjects((Object)(oldValue = this.getPropertyValue(monitor, editableValue, prop)), (Object)value)) break block10;
                return false;
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                log.error((Object)("Can't write property '" + prop.getDisplayName() + "' value"), e);
                return false;
            }
        }
        prop.writeValue(editableValue, value);
        if (editableValue instanceof DBSObject) {
            DBUtils.fireObjectUpdate((DBSObject)((DBSObject)editableValue), (Object)prop);
        }
        return true;
    }

    @Override
    public boolean isPropertyResettable(Object object, ObjectPropertyDescriptor prop) {
        return this.lastCommand != null && this.lastCommand.property == prop && this.lastCommand.getObject() == object;
    }

    @Override
    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, Object object, ObjectPropertyDescriptor prop) {
        if (this.lastCommand != null && this.lastCommand.property == prop) {
            this.setPropertyValue(monitor, object, prop, this.lastCommand.getOldValue());
        }
        log.warn((Object)"Property reset not implemented");
    }

    private class CommandReflector
    implements DBECommandReflector<DBPObject, PropertyChangeCommand> {
        private CommandReflector() {
        }

        public void redoCommand(PropertyChangeCommand command) {
            PropertySourceEditable.this.updatePropertyValue(null, command.getObject(), command.property, command.getNewValue(), false);
        }

        public void undoCommand(PropertyChangeCommand command) {
            PropertySourceEditable.this.updatePropertyValue(null, command.getObject(), command.property, command.getOldValue(), false);
        }
    }

    private class PropertyChangeCommand
    extends DBECommandProperty<DBPObject> {
        ObjectPropertyDescriptor property;

        public PropertyChangeCommand(DBPObject editableValue, ObjectPropertyDescriptor property, DBEPropertyHandler<DBPObject> propertyHandler, Object oldValue, Object newValue) {
            super(editableValue, propertyHandler, oldValue, newValue);
            this.property = property;
        }

        public void updateModel() {
            super.updateModel();
            PropertySourceEditable.this.updatePropertyValue(null, this.getObject(), this.property, this.getNewValue(), true);
        }
    }
}

