/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.access.DBAAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.registry.ProductBundleRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryLocal;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.registry.driver.DriverLibraryRemote;
import org.jkiss.dbeaver.registry.driver.DriverLibraryRepository;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.utils.CommonUtils;

public abstract class DriverLibraryAbstract
implements DBPDriverLibrary {
    private static final Log log = Log.getLog(DriverLibraryAbstract.class);
    protected final DriverDescriptor driver;
    protected final DBPDriverLibrary.FileType type;
    protected final OSDescriptor system;
    protected String path;
    protected boolean custom;
    protected boolean disabled;

    public static DriverLibraryAbstract createFromPath(DriverDescriptor driver, DBPDriverLibrary.FileType type, String path, String preferredVersion) {
        if (path.startsWith("repo:/")) {
            return new DriverLibraryRepository(driver, type, path);
        }
        if (path.startsWith("maven:/")) {
            return new DriverLibraryMavenArtifact(driver, type, path, preferredVersion);
        }
        if (DriverLibraryRemote.supportsURL(path)) {
            return new DriverLibraryRemote(driver, type, path);
        }
        return new DriverLibraryLocal(driver, type, path);
    }

    public static DriverLibraryAbstract createFromConfig(DriverDescriptor driver, IConfigurationElement config) {
        String path = config.getAttribute("path");
        if (CommonUtils.isEmpty((String)path)) {
            log.error((Object)"Bad file path");
            return null;
        }
        String bundle = config.getAttribute("bundle");
        if (!CommonUtils.isEmpty((String)bundle)) {
            boolean hasBundle;
            boolean not = false;
            if (bundle.startsWith("!")) {
                not = true;
                bundle = bundle.substring(1);
            }
            if (!(hasBundle = ProductBundleRegistry.getInstance().hasBundle(bundle)) && !not || hasBundle && not) {
                return null;
            }
        }
        if (path.startsWith("repo:/")) {
            return new DriverLibraryRepository(driver, config);
        }
        if (path.startsWith("maven:/")) {
            return new DriverLibraryMavenArtifact(driver, config);
        }
        if (DriverLibraryRemote.supportsURL(path)) {
            return new DriverLibraryRemote(driver, config);
        }
        return new DriverLibraryLocal(driver, config);
    }

    protected DriverLibraryAbstract(DriverDescriptor driver, DBPDriverLibrary.FileType type, String path) {
        this.driver = driver;
        this.type = type;
        this.system = null;
        this.path = path;
        this.custom = true;
    }

    protected DriverLibraryAbstract(DriverDescriptor driver, IConfigurationElement config) {
        this.driver = driver;
        this.type = DBPDriverLibrary.FileType.valueOf((String)config.getAttribute("type"));
        String osName = config.getAttribute("os");
        this.system = osName == null ? null : new OSDescriptor(osName, config.getAttribute("arch"));
        this.path = config.getAttribute("path");
        this.custom = false;
    }

    public DriverDescriptor getDriver() {
        return this.driver;
    }

    public String getVersion() {
        return null;
    }

    @NotNull
    public Collection<String> getAvailableVersions(DBRProgressMonitor monitor) throws IOException {
        return Collections.emptyList();
    }

    public String getPreferredVersion() {
        return null;
    }

    public void setPreferredVersion(String version) {
    }

    @NotNull
    public DBPDriverLibrary.FileType getType() {
        return this.type;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return null;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean matchesCurrentPlatform() {
        return this.system == null || this.system.matches(DBeaverCore.getInstance().getLocalSystem());
    }

    public void downloadLibraryFile(@NotNull DBRProgressMonitor monitor, boolean forceUpdate, String taskName) throws IOException, InterruptedException {
        int bufferLength;
        String externalURL;
        File localFile = this.getLocalFile();
        if (localFile == null) {
            throw new IOException("No target file for '" + this.getPath() + "'");
        }
        if (!forceUpdate && localFile.exists()) {
            return;
        }
        File localDir = localFile.getParentFile();
        if (!localDir.exists() && !localDir.mkdirs()) {
            log.warn((Object)("Can't create directory for local driver file '" + localDir.getAbsolutePath() + "'"));
        }
        if ((externalURL = this.getExternalURL(monitor)) == null) {
            throw new IOException("Unresolved file reference: " + this.getPath());
        }
        URLConnection connection = WebUtils.openConnection(externalURL, this.getAuthInfo(monitor));
        int contentLength = connection.getContentLength();
        if (contentLength < 0) {
            contentLength = 0;
        }
        if ((bufferLength = contentLength / 10) > 1000000) {
            bufferLength = 1000000;
        }
        if (bufferLength < 50000) {
            bufferLength = 50000;
        }
        monitor.beginTask(String.valueOf(taskName) + " - " + externalURL, contentLength);
        boolean success = false;
        try {
            Throwable throwable = null;
            Object var12_13 = null;
            try (FileOutputStream outputStream = new FileOutputStream(localFile);){
                Throwable throwable2 = null;
                Object var15_18 = null;
                try (InputStream inputStream = connection.getInputStream();){
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    byte[] buffer = new byte[bufferLength];
                    int totalRead = 0;
                    while (true) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        int count = inputStream.read(buffer);
                        if (count <= 0) {
                            success = true;
                            break;
                        }
                        ((OutputStream)outputStream).write(buffer, 0, count);
                        monitor.worked(count);
                        totalRead += count;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            if (!success && !localFile.delete()) {
                log.warn((Object)("Can't delete local driver file '" + localFile.getAbsolutePath() + "'"));
            }
            monitor.done();
        }
    }

    @Nullable
    protected DBAAuthInfo getAuthInfo(DBRProgressMonitor monitor) {
        return null;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

