/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthInfo;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.encode.EncryptionException;
import org.jkiss.dbeaver.registry.encode.SecuredPasswordEncrypter;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.utils.CommonUtils;

public class GlobalProxyAuthenticator
extends Authenticator {
    private SecuredPasswordEncrypter encrypter;

    @Override
    @Nullable
    protected PasswordAuthentication getPasswordAuthentication() {
        DBCExecutionContext activeContext;
        String requestingProtocol;
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        String proxyHost = store.getString("ui.proxy.host");
        if (!CommonUtils.isEmpty((String)proxyHost) && proxyHost.equalsIgnoreCase(this.getRequestingHost()) && store.getInt("ui.proxy.port") == this.getRequestingPort()) {
            DBAAuthInfo authInfo;
            String userName = store.getString("ui.proxy.user");
            String userPassword = this.decryptPassword(store.getString("ui.proxy.password"));
            if ((CommonUtils.isEmpty((String)userName) || CommonUtils.isEmpty((String)userPassword)) && (authInfo = this.readCredentialsInUI("Auth proxy '" + proxyHost + "'", userName, userPassword)) != null) {
                userName = authInfo.getUserName();
                userPassword = authInfo.getUserPassword();
                if (authInfo.isSavePassword()) {
                    store.setValue("ui.proxy.user", userName);
                    store.setValue("ui.proxy.password", this.encryptPassword(userPassword));
                }
            }
            if (!CommonUtils.isEmpty((String)userName) && !CommonUtils.isEmpty((String)userPassword)) {
                return new PasswordAuthentication(userName, userPassword.toCharArray());
            }
        }
        if (("SOCKS5".equals(requestingProtocol = this.getRequestingProtocol()) || "SOCKS4".equals(requestingProtocol)) && (activeContext = DBExecUtils.findConnectionContext((String)this.getRequestingHost(), (int)this.getRequestingPort(), (String)this.getRequestingScheme())) != null) {
            DBPDataSourceContainer container = activeContext.getDataSource().getContainer();
            for (DBWHandlerConfiguration networkHandler : container.getConnectionConfiguration().getDeclaredHandlers()) {
                DBAAuthInfo authInfo;
                if (!networkHandler.isEnabled() || networkHandler.getType() != DBWHandlerType.PROXY) continue;
                String userName = networkHandler.getUserName();
                String userPassword = networkHandler.getPassword();
                if ((CommonUtils.isEmpty((String)userName) || CommonUtils.isEmpty((String)userPassword)) && (authInfo = this.readCredentialsInUI(this.getRequestingPrompt(), userName, userPassword)) != null) {
                    userName = authInfo.getUserName();
                    userPassword = authInfo.getUserPassword();
                    if (authInfo.isSavePassword()) {
                        networkHandler.setUserName(userName);
                        networkHandler.setPassword(userPassword);
                        networkHandler.setSavePassword(true);
                        container.getRegistry().flushConfig();
                    }
                }
                if (CommonUtils.isEmpty((String)userName) || CommonUtils.isEmpty((String)userPassword)) continue;
                return new PasswordAuthentication(userName, userPassword.toCharArray());
            }
        }
        return null;
    }

    private String encryptPassword(String password) {
        try {
            if (this.encrypter == null) {
                this.encrypter = new SecuredPasswordEncrypter();
            }
            return this.encrypter.encrypt(password);
        }
        catch (EncryptionException e) {
            return password;
        }
    }

    private String decryptPassword(String password) {
        if (CommonUtils.isEmpty((String)password)) {
            return password;
        }
        try {
            if (this.encrypter == null) {
                this.encrypter = new SecuredPasswordEncrypter();
            }
            return this.encrypter.decrypt(password);
        }
        catch (EncryptionException e) {
            return password;
        }
    }

    private DBAAuthInfo readCredentialsInUI(String prompt, String userName, String userPassword) {
        return DBUserInterface.getInstance().promptUserCredentials(prompt, userName, userPassword, false);
    }
}

