/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.session;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class OracleServerSession
implements DBAServerSession {
    private String sid;
    private String serial;
    private String user;
    private String schema;
    private String status;
    private String state;
    private String sql;
    private String event;
    private String elapsedTime;
    private Timestamp logonTime;
    private String serviceName;
    private String remoteHost;
    private String remoteUser;
    private String remoteProgram;

    public OracleServerSession(ResultSet dbResult) {
        this.sid = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SID");
        this.serial = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SERIAL#");
        this.user = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"USERNAME");
        this.schema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMANAME");
        this.status = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS");
        this.state = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATE");
        this.sql = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQL_FULLTEXT");
        this.event = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT");
        this.elapsedTime = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LAST_CALL_ET");
        this.logonTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LOGON_TIME");
        this.serviceName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SERVICE_NAME");
        this.remoteHost = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MACHINE");
        this.remoteUser = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OSUSER");
        this.remoteProgram = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROGRAM");
    }

    @Property(category="Session", viewable=true, order=1)
    public String getSid() {
        return this.sid;
    }

    public String getSerial() {
        return this.serial;
    }

    @Property(category="Session", viewable=true, order=2)
    public String getUser() {
        return this.user;
    }

    @Property(category="Session", viewable=true, order=3)
    public String getSchema() {
        return this.schema;
    }

    @Property(category="Session", viewable=true, order=4)
    public String getStatus() {
        return this.status;
    }

    @Property(category="Session", viewable=true, order=5)
    public String getState() {
        return this.state;
    }

    @Property(category="Session", viewable=true, order=6)
    public String getEvent() {
        return this.event;
    }

    @Property(category="Session", viewable=true, order=7)
    public String getElapsedTime() {
        return this.elapsedTime;
    }

    @Property(category="Session", order=8)
    public Timestamp getLogonTime() {
        return this.logonTime;
    }

    @Property(category="Session", order=9)
    public String getServiceName() {
        return this.serviceName;
    }

    @Property(category="SQL", order=50)
    public String getSql() {
        return this.sql;
    }

    @Property(category="Process", viewable=true, order=30)
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Property(category="Process", viewable=true, order=31)
    public String getRemoteUser() {
        return this.remoteUser;
    }

    @Property(category="Process", viewable=true, order=32)
    public String getRemoteProgram() {
        return this.remoteProgram;
    }

    public String getActiveQuery() {
        return this.sql;
    }

    public String toString() {
        return String.valueOf(this.sid) + " - " + this.event;
    }
}

