/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKeyColumn;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.utils.CommonUtils;

public class OracleForeignKeyManager
extends SQLForeignKeyManager<OracleTableForeignKey, OracleTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTableForeignKey> getObjectsCache(OracleTableForeignKey object) {
        return ((OracleTableBase)object.getParentObject()).getSchema().foreignKeyCache;
    }

    protected OracleTableForeignKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final OracleTableBase table, Object from) {
        return (OracleTableForeignKey)((Object)new UITask<OracleTableForeignKey>(){

            protected OracleTableForeignKey runTask() {
                EditForeignKeyPage editPage = new EditForeignKeyPage(OracleMessages.edit_oracle_foreign_key_manager_dialog_title, (DBSTable)table, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT});
                if (!editPage.edit()) {
                    return null;
                }
                OracleTableForeignKey foreignKey = new OracleTableForeignKey(table, null, null, (OracleTableConstraint)editPage.getUniqueConstraint(), editPage.getOnDeleteRule());
                foreignKey.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)foreignKey, (String)(String.valueOf(CommonUtils.escapeIdentifier((String)table.getName())) + "_" + CommonUtils.escapeIdentifier((String)editPage.getUniqueConstraint().getParentObject().getName()) + "_FK")));
                int colIndex = 1;
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editPage.getColumns()) {
                    foreignKey.addColumn(new OracleTableForeignKeyColumn(foreignKey, (OracleTableColumn)tableColumn.getOwnColumn(), colIndex++));
                }
                return foreignKey;
            }
        }.execute());
    }
}

