/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectStatus;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraintColumn;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;

public class OracleConstraintManager
extends SQLConstraintManager<OracleTableConstraint, OracleTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTableConstraint> getObjectsCache(OracleTableConstraint object) {
        return ((OracleTableBase)object.getParentObject()).getSchema().constraintCache;
    }

    protected OracleTableConstraint createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final OracleTableBase parent, Object from) {
        return (OracleTableConstraint)((Object)new UITask<OracleTableConstraint>(){

            protected OracleTableConstraint runTask() {
                EditConstraintPage editPage = new EditConstraintPage(OracleMessages.edit_oracle_constraint_manager_dialog_title, (DBSEntity)parent, new DBSEntityConstraintType[]{DBSEntityConstraintType.PRIMARY_KEY, DBSEntityConstraintType.UNIQUE_KEY}, Boolean.valueOf(true));
                if (!editPage.edit()) {
                    return null;
                }
                OracleTableConstraint constraint = new OracleTableConstraint(parent, editPage.getConstraintName(), editPage.getConstraintType(), null, editPage.isEnableConstraint() ? OracleObjectStatus.ENABLED : OracleObjectStatus.DISABLED);
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    constraint.addColumn(new OracleTableConstraintColumn((AbstractTableConstraint<OracleTableBase>)constraint, (OracleTableColumn)tableColumn, colIndex++));
                }
                return constraint;
            }
        }.execute());
    }

    protected String getDropConstraintPattern(OracleTableConstraint constraint) {
        String clause = "CONSTRAINT";
        return "ALTER TABLE %TABLE% DROP " + clause + " " + "%CONSTRAINT%";
    }

    @NotNull
    protected String getAddConstraintTypeClause(OracleTableConstraint constraint) {
        if (constraint.getConstraintType() == DBSEntityConstraintType.UNIQUE_KEY) {
            return "UNIQUE";
        }
        return super.getAddConstraintTypeClause((JDBCTableConstraint)constraint);
    }

    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        OracleTableConstraint constraint = (OracleTableConstraint)command.getObject();
        OracleTableBase table = (OracleTableBase)constraint.getTable();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_constraint, "ALTER TABLE " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD " + this.getNestedDeclaration(table, (DBECommandAbstract)command, options) + " " + (constraint.getStatus() == OracleObjectStatus.ENABLED ? "ENABLE" : "DISABLE")));
    }
}

