/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.resultset;

import com.dbeaver.ee.runtime.ui.resultset.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.IDocumentRenderer;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.LongKeyMap;

public abstract class TextRenderer
implements IDocumentRenderer {
    public static final String LINE_SEPARATOR = GeneralUtils.getDefaultLineSeparator();
    public static final int MAP_INDENT = 4;
    public static final int STATE_IMAGE_HEIGHT = 10;
    protected final IDocumentFrame documentFrame;
    private int lineHeight;
    private int charWidth;
    private LongKeyMap<Object> objectCoordMap = new LongKeyMap();
    private Map<Object, Boolean> collapsedObjects = new IdentityHashMap<Object, Boolean>();

    protected TextRenderer(IDocumentFrame iDocumentFrame) {
        this.documentFrame = iDocumentFrame;
    }

    @Override
    public Point computeSize(GC gC) {
        Font font = this.documentFrame.getCanvas().getFont();
        Font font2 = gC.getFont();
        gC.setFont(font);
        FontMetrics fontMetrics = gC.getFontMetrics();
        this.lineHeight = fontMetrics.getHeight();
        this.charWidth = fontMetrics.getAverageCharWidth();
        gC.setFont(font2);
        this.objectCoordMap.clear();
        TextMeasurer textMeasurer = new TextMeasurer();
        this.renderNode(textMeasurer, this.documentFrame.getDocument().getRootNode(), 0, 0);
        return new Point(textMeasurer.maxX * this.charWidth, (textMeasurer.maxY + 1) * this.lineHeight);
    }

    @Override
    public int getLineHeight() {
        return this.lineHeight;
    }

    @Override
    public int getCharWidth() {
        return this.charWidth;
    }

    @Override
    public void paintDocument(@NotNull GC gC, @NotNull Canvas canvas, @NotNull Rectangle rectangle) {
        TextPainter textPainter = new TextPainter(gC, rectangle, canvas);
        this.renderNode(textPainter, this.documentFrame.getDocument().getRootNode(), 0, 0);
    }

    @Override
    public void getContents(@NotNull StringBuilder stringBuilder, @NotNull IDocumentFrame iDocumentFrame, @NotNull DBDDisplayFormat dBDDisplayFormat) {
        TextCopier textCopier = new TextCopier(stringBuilder, iDocumentFrame);
        textCopier.measureMode = true;
        this.renderNode(textCopier, this.documentFrame.getDocument().getRootNode(), 0, 0);
        textCopier.measureMode = false;
        this.renderNode(textCopier, this.documentFrame.getDocument().getRootNode(), 0, 0);
    }

    @Override
    public boolean handleMouseDown(MouseEvent mouseEvent, Point point) {
        long l = TextRenderer.getNodeId(point.x, point.y);
        Object object = this.objectCoordMap.get(l);
        if (object != null) {
            if (this.collapsedObjects.remove(object) == null) {
                this.collapsedObjects.put(object, Boolean.TRUE);
            }
            return true;
        }
        return false;
    }

    @Override
    public void createEditor(@NotNull Canvas canvas, @NotNull Rectangle rectangle) {
    }

    @Override
    public void dispose() {
    }

    protected abstract void renderNode(TextProcessor var1, Object var2, int var3, int var4);

    protected boolean isNodeCollapsed(Object object) {
        return this.collapsedObjects.get(object) != null;
    }

    private static long getNodeId(int n, int n2) {
        return (long)n2 * 1000000000L | (long)n;
    }

    public static enum NodeState {
        collapsed((DBPImage)UIIcon.TREE_EXPAND),
        expanded((DBPImage)UIIcon.TREE_COLLAPSE);

        private final DBPImage image;

        private NodeState(DBPImage dBPImage) {
            this.image = dBPImage;
        }

        @NotNull
        public DBPImage getImage() {
            return this.image;
        }
    }

    class TextCopier
    implements TextProcessor {
        @NotNull
        private final IDocumentFrame state;
        @NotNull
        private final StringBuilder content;
        private int prevY = -1;
        private int prevX = -1;
        private int minX = -1;
        private boolean measureMode = false;

        TextCopier(@NotNull StringBuilder stringBuilder, IDocumentFrame iDocumentFrame) {
            this.content = stringBuilder;
            this.state = iDocumentFrame;
        }

        @Override
        public boolean isOutOfRange(int n) {
            return false;
        }

        @Override
        public void drawText(String string, int n, int n2, Color color) {
            Point point = this.state.getSelectionStart();
            Point point2 = this.state.getSelectionEnd();
            if (point != null && point2 != null && !point2.equals((Object)point)) {
                Point point3 = point.y < point2.y || point.y == point2.y && point.x < point2.x ? point : point2;
                Point point4 = point3 == point ? point2 : point;
                int n3 = string.length();
                if ((n2 > point3.y || n2 == point3.y && (point3.x < n || n + n3 > point3.x)) && (n2 < point4.y || n2 == point4.y && n < point4.x)) {
                    int n4 = 0;
                    int n5 = n3;
                    if (n2 == point3.y && n < point3.x && n + n3 > point3.x) {
                        n4 = point3.x - n;
                    }
                    if (n2 == point4.y && n < point4.x & n + n3 > point4.x) {
                        n5 = point4.x - n;
                    }
                    this.printText(string, n4, n5, n, n2);
                }
            } else {
                this.printText(string, 0, string.length(), n, n2);
            }
        }

        private void printText(String string, int n, int n2, int n3, int n4) {
            if (this.measureMode) {
                this.minX = this.minX == -1 ? n3 : Math.min(this.minX, n3);
            } else {
                int n5;
                if (this.prevY != -1 && n4 > this.prevY) {
                    n5 = this.prevY;
                    while (n5 < n4) {
                        this.content.append(LINE_SEPARATOR);
                        ++n5;
                    }
                }
                if (n4 > this.prevY) {
                    n5 = this.minX;
                    while (n5 < n3) {
                        this.content.append(' ');
                        ++n5;
                    }
                }
                this.content.append(string, n, n2);
                this.prevY = n4;
            }
        }

        @Override
        public void drawState(Object object, NodeState nodeState, int n, int n2) {
        }
    }

    class TextMeasurer
    implements TextProcessor {
        private int maxY = 0;
        private int maxX = 0;

        TextMeasurer() {
        }

        @Override
        public boolean isOutOfRange(int n) {
            return false;
        }

        @Override
        public void drawText(String string, int n, int n2, Color color) {
            this.maxX = Math.max(this.maxX, n + string.length());
            this.maxY = Math.max(this.maxY, n2);
        }

        @Override
        public void drawState(Object object, NodeState nodeState, int n, int n2) {
            if (nodeState == NodeState.collapsed) {
                TextRenderer.this.collapsedObjects.put(object, Boolean.TRUE);
            } else {
                TextRenderer.this.collapsedObjects.remove(object);
            }
            TextRenderer.this.objectCoordMap.put(TextRenderer.getNodeId(n, n2), object);
        }
    }

    class TextPainter
    implements TextProcessor {
        private final GC gc;
        private final Rectangle bounds;
        private final int bottomY;
        private Color selectionFG;
        private Color selectionBG;

        TextPainter(GC gC, Rectangle rectangle, Canvas canvas) {
            this.gc = gC;
            this.bounds = rectangle;
            this.bottomY = canvas.getSize().y;
            this.selectionFG = gC.getDevice().getSystemColor(25);
            this.selectionBG = gC.getDevice().getSystemColor(26);
        }

        @Override
        public boolean isOutOfRange(int n) {
            return this.bounds.y + n * TextRenderer.this.lineHeight > this.bottomY;
        }

        @Override
        public void drawText(String string, int n, int n2, Color color) {
            if (this.bounds.y + n2 * TextRenderer.this.lineHeight < -TextRenderer.this.lineHeight) {
                return;
            }
            if (color != null) {
                this.gc.setForeground(color);
            }
            if (TextRenderer.this.documentFrame.isSelected()) {
                Point point = TextRenderer.this.documentFrame.getSelectionStart();
                Point point2 = TextRenderer.this.documentFrame.getSelectionEnd();
                if (point != null && point2 != null && point2 != point) {
                    Point point3 = point.y < point2.y || point.y == point2.y && point.x < point2.x ? point : point2;
                    Point point4 = point3 == point ? point2 : point;
                    int n3 = string.length();
                    if ((n2 > point3.y || n2 == point3.y && (point3.x < n || n + n3 > point3.x)) && (n2 < point4.y || n2 == point4.y && n < point4.x)) {
                        String string2 = null;
                        String string3 = null;
                        if (n2 == point3.y && n < point3.x && n + n3 > point3.x) {
                            string2 = string.substring(0, point3.x - n);
                        }
                        if (n2 == point4.y && n < point4.x & n + n3 > point4.x) {
                            string3 = string.substring(point4.x - n);
                        }
                        if (string2 != null || string3 != null) {
                            int n4 = string2 == null ? 0 : string2.length();
                            int n5 = string3 == null ? n3 : n3 - string3.length();
                            string = string.substring(n4, n5);
                        }
                        if (string2 != null && !string2.isEmpty()) {
                            n = this.drawText(string2, n, n2, true);
                        }
                        if (!string.isEmpty()) {
                            this.gc.setBackground(this.selectionBG);
                            this.gc.setForeground(this.selectionFG);
                            n = this.drawText(string, n, n2, false);
                            this.gc.setForeground(color);
                        }
                        if (string3 != null && !string3.isEmpty()) {
                            this.drawText(string3, n, n2, true);
                        }
                        return;
                    }
                }
            }
            this.drawText(string, n, n2, true);
        }

        private int drawText(String string, int n, int n2, boolean bl) {
            if (this.gc.getDevice().isAutoScalable()) {
                int n3 = 0;
                while (n3 < string.length()) {
                    this.gc.drawText(String.valueOf(string.charAt(n3)), this.bounds.x + n * TextRenderer.this.charWidth, this.bounds.y + n2 * TextRenderer.this.lineHeight, bl);
                    ++n;
                    ++n3;
                }
            } else {
                this.gc.drawText(string, this.bounds.x + n * TextRenderer.this.charWidth, this.bounds.y + n2 * TextRenderer.this.lineHeight, bl);
                n += string.length();
            }
            return n;
        }

        @Override
        public void drawState(Object object, NodeState nodeState, int n, int n2) {
            if (nodeState.getImage() != null && this.bounds.y + n2 * TextRenderer.this.lineHeight >= -TextRenderer.this.lineHeight) {
                this.gc.drawImage(DBeaverIcons.getImage((DBPImage)nodeState.getImage()), this.bounds.x + n * TextRenderer.this.charWidth, this.bounds.y + n2 * TextRenderer.this.lineHeight + (TextRenderer.this.lineHeight - 10) / 2);
            }
        }
    }

    protected static interface TextProcessor {
        public boolean isOutOfRange(int var1);

        public void drawText(String var1, int var2, int var3, Color var4);

        public void drawState(Object var1, NodeState var2, int var3, int var4);
    }
}

