/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui;

import com.dbeaver.ee.runtime.core.DBeaverEnterpriseLM;
import com.dbeaver.ee.runtime.internal.ui.UiMessages;
import com.dbeaver.lm.ui.LicenseImportDialog;
import com.dbeaver.lm.ui.LicenseInfoDialog;
import com.dbeaver.lm.ui.LicenseManagementDialog;
import com.dbeaver.lm.ui.LicenseMissingDialog;
import com.dbeaver.lm.ui.LicenseTrialDialog;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMValidateException;

public class DBeaverEnterpriseUI {
    public static boolean checkLicense(Shell shell) {
        return DBeaverEnterpriseUI.checkLicense(shell, DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkLicense(Shell shell, LMLicenseManager lMLicenseManager, LMProduct lMProduct) {
        boolean bl = false;
        while (true) {
            try {
                if (lMLicenseManager.hasProductLicense(lMProduct)) {
                    break;
                }
            }
            catch (LMValidateException lMValidateException) {}
            LicenseMissingDialog licenseMissingDialog = new LicenseMissingDialog(shell, lMLicenseManager, lMProduct);
            int n = licenseMissingDialog.open();
            try {
                switch (n) {
                    case 1: {
                        return false;
                    }
                    case 1000: {
                        if (!DBeaverEnterpriseUI.importLicense(shell)) break;
                        UIUtils.showMessageBox((Shell)shell, (String)UiMessages.DBeaverEnterpriseUI_license_accepted_title, (String)UiMessages.DBeaverEnterpriseUI_license_accepted_message, (int)2);
                        break;
                    }
                    case 1001: {
                        if (!DBeaverEnterpriseUI.createTrialLicense(shell)) break;
                        UIUtils.showMessageBox((Shell)shell, (String)UiMessages.DBeaverEnterpriseUI_trial_accepted_title, (String)UiMessages.DBeaverEnterpriseUI_trial_accepted_message, (int)2);
                        break;
                    }
                    case 1002: {
                        LicenseManagementDialog licenseManagementDialog = new LicenseManagementDialog(shell, lMLicenseManager, lMProduct);
                        licenseManagementDialog.open();
                    }
                }
            }
            catch (Throwable throwable) {
                DBUserInterface.getInstance().showError(UiMessages.DBeaverEnterpriseUI_e_lm_internal_title, UiMessages.DBeaverEnterpriseUI_e_lm_internal_message, throwable);
            }
            bl = true;
        }
        if (bl) {
            DBeaverEnterpriseUI.showLicenseInfoDialog();
        }
        return true;
    }

    private static boolean createTrialLicense(Shell shell) {
        LicenseTrialDialog licenseTrialDialog = new LicenseTrialDialog(shell, DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
        int n = licenseTrialDialog.open();
        return n == 0;
    }

    private static boolean importLicense(Shell shell) {
        LicenseImportDialog licenseImportDialog = new LicenseImportDialog(shell, DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
        int n = licenseImportDialog.open();
        return n == 0;
    }

    public static void showLicenseInfoDialog() {
        try {
            LicenseInfoDialog licenseInfoDialog = new LicenseInfoDialog(UIUtils.getActiveWorkbenchShell(), DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
            licenseInfoDialog.open();
        }
        catch (Exception exception) {
            DBeaverUI.getInstance().showError(UiMessages.DBeaverEnterpriseUI_license_info_title, UiMessages.DBeaverEnterpriseUI_license_info_message, (Throwable)exception);
        }
    }
}

