/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.snowflake.views;

import com.dbeaver.ee.snowflake.Activator;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class SnowflakeConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage,
IDataSourceConnectionTester {
    private static final Log log = Log.getLog(SnowflakeConnectionPage.class);
    private Text hostText;
    private Text portText;
    private Combo dbText;
    private Combo warehouseText;
    private Combo schemaText;
    private Combo roleText;
    private Text usernameText;
    private Text passwordText;
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/snowflake_logo.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = modifyEvent -> this.site.updateButtons();
        Group group = UIUtils.createControlGroup((Composite)composite2, (String)"Connection", (int)4, (int)0, (int)0);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        UIUtils.createControlLabel((Composite)group, (String)"Host");
        this.hostText = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gridData);
        this.hostText.addModifyListener(modifyListener);
        UIUtils.createControlLabel((Composite)group, (String)"Port");
        this.portText = new Text((Composite)group, 2048);
        gridData = new GridData(2);
        gridData.widthHint = 40;
        this.portText.setLayoutData((Object)gridData);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(modifyListener);
        UIUtils.createControlLabel((Composite)group, (String)"Database");
        this.dbText = new Combo((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gridData);
        this.dbText.addModifyListener(modifyListener);
        UIUtils.createControlLabel((Composite)group, (String)"Warehouse");
        this.warehouseText = new Combo((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.warehouseText.setLayoutData((Object)gridData);
        this.warehouseText.addModifyListener(modifyListener);
        UIUtils.createControlLabel((Composite)group, (String)"Schema");
        this.schemaText = new Combo((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.schemaText.setLayoutData((Object)gridData);
        this.schemaText.addModifyListener(modifyListener);
        group = UIUtils.createPlaceholder((Composite)composite2, (int)2);
        UIUtils.createInfoLabel((Composite)group, (String)"");
        gridData = new Link((Composite)group, 0);
        gridData.setText("Click on <a>Test Connection</a> to load warehouse/schema list from the server");
        GridData gridData2 = new GridData(800);
        gridData2.grabExcessHorizontalSpace = true;
        gridData.setLayoutData((Object)gridData2);
        gridData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SnowflakeConnectionPage.this.site.testConnection();
            }
        });
        group = UIUtils.createControlGroup((Composite)composite2, (String)"Security", (int)4, (int)0, (int)0);
        group.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)group, (String)"User");
        this.usernameText = new Text((Composite)group, 2048);
        gridData = new GridData(800);
        this.usernameText.setLayoutData((Object)gridData);
        this.usernameText.addModifyListener(modifyListener);
        UIUtils.createControlLabel((Composite)group, (String)"Password");
        this.passwordText = new Text((Composite)group, 0x400800);
        gridData = new GridData(800);
        this.passwordText.setLayoutData((Object)gridData);
        this.passwordText.addModifyListener(modifyListener);
        UIUtils.createControlLabel((Composite)group, (String)"Role");
        this.roleText = new Combo((Composite)group, 2052);
        gridData = new GridData(800);
        this.roleText.setLayoutData((Object)gridData);
        this.roleText.addModifyListener(modifyListener);
        this.createDriverPanel(composite2);
        this.setControl((Control)composite2);
    }

    public boolean isComplete() {
        return this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration dBPConnectionConfiguration = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (CommonUtils.isEmpty((String)dBPConnectionConfiguration.getHostName())) {
                this.hostText.setText(".snowflakecomputing.com");
            } else {
                this.hostText.setText(dBPConnectionConfiguration.getHostName());
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)dBPConnectionConfiguration.getHostPort())) {
                this.portText.setText(String.valueOf(dBPConnectionConfiguration.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            String string = dBPConnectionConfiguration.getDatabaseName();
            if (CommonUtils.isEmpty((String)string)) {
                string = "TEST_DB";
            }
            this.dbText.setText(string);
        }
        if (this.warehouseText != null) {
            this.warehouseText.setText(CommonUtils.notEmpty((String)dBPConnectionConfiguration.getServerName()));
        }
        if (this.schemaText != null) {
            this.schemaText.setText(CommonUtils.notEmpty((String)dBPConnectionConfiguration.getProviderProperty("@dbeaver-schema@")));
        }
        if (this.usernameText != null) {
            this.usernameText.setText(CommonUtils.notEmpty((String)dBPConnectionConfiguration.getUserName()));
        }
        if (this.roleText != null) {
            this.roleText.setText(CommonUtils.notEmpty((String)dBPConnectionConfiguration.getProviderProperty("@dbeaver-role@")));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)dBPConnectionConfiguration.getUserPassword()));
        }
    }

    public void saveSettings(DBPDataSourceContainer dBPDataSourceContainer) {
        DBPConnectionConfiguration dBPConnectionConfiguration = dBPDataSourceContainer.getConnectionConfiguration();
        if (this.hostText != null) {
            dBPConnectionConfiguration.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            dBPConnectionConfiguration.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            dBPConnectionConfiguration.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.warehouseText != null) {
            dBPConnectionConfiguration.setServerName(this.warehouseText.getText().trim());
        }
        if (this.schemaText != null) {
            dBPConnectionConfiguration.setProviderProperty("@dbeaver-schema@", this.schemaText.getText().trim());
        }
        if (this.usernameText != null) {
            dBPConnectionConfiguration.setUserName(this.usernameText.getText().trim());
        }
        if (this.roleText != null) {
            dBPConnectionConfiguration.setProviderProperty("@dbeaver-role@", this.roleText.getText().trim());
        }
        if (this.passwordText != null) {
            dBPConnectionConfiguration.setUserPassword(this.passwordText.getText());
        }
        super.saveSettings(dBPDataSourceContainer);
    }

    public void testConnection(DBCSession dBCSession) {
        try {
            SnowflakeConnectionPage.loadDictList(dBCSession, this.dbText, "SHOW DATABASES");
            SnowflakeConnectionPage.loadDictList(dBCSession, this.warehouseText, "SHOW WAREHOUSES");
            SnowflakeConnectionPage.loadDictList(dBCSession, this.schemaText, "SHOW SCHEMAS");
            SnowflakeConnectionPage.loadDictList(dBCSession, this.roleText, "SHOW ROLES");
        }
        catch (Exception exception) {
            log.error((Object)exception);
        }
    }

    private static void loadDictList(DBCSession dBCSession, Combo combo, String string) throws DBCException {
        ArrayList<String> arrayList = new ArrayList<String>();
        dBCSession.getProgressMonitor().subTask("Exec " + string);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DBCStatement dBCStatement = dBCSession.prepareStatement(DBCStatementType.QUERY, string, false, false, false);){
            dBCStatement.executeStatement();
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (DBCResultSet dBCResultSet = dBCStatement.openResultSet();){
                while (dBCResultSet.nextRow()) {
                    arrayList.add(CommonUtils.toString((Object)dBCResultSet.getAttributeValue("name")));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        UIUtils.asyncExec(() -> {
            String string = combo.getText();
            if (!arrayList.contains(string)) {
                arrayList.add(0, string);
            }
            if (!arrayList.contains("")) {
                arrayList.add(0, "");
            }
            combo.setItems(arrayList.toArray(new String[arrayList.size()]));
            combo.setText(string);
        });
    }

    public IDialogPage[] getSubPages() {
        return new IDialogPage[0];
    }
}

