/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public abstract class PostgreTableReal
extends PostgreTableBase {
    private static final Log log = Log.getLog(PostgreTableReal.class);
    public static final String CAT_STATISTICS = "Statistics";
    private long rowCountEstimate;
    private Long rowCount;
    private Long diskSpace;
    final TriggerCache triggerCache = new TriggerCache();

    protected PostgreTableReal(PostgreSchema catalog) {
        super(catalog);
    }

    protected PostgreTableReal(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
        this.rowCountEstimate = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"reltuples");
    }

    public PostgreTableReal(PostgreSchema container, DBSEntity source, boolean persisted) {
        super(container, source, persisted);
        boolean cfr_ignored_0 = source instanceof PostgreTableReal;
    }

    @Property(category="Statistics", viewable=true, order=22)
    public long getRowCountEstimate() {
        return this.rowCountEstimate;
    }

    @Property(category="Statistics", viewable=false, expensive=true, order=23)
    public synchronized Long getRowCount(DBRProgressMonitor monitor) {
        if (this.rowCount != null) {
            return this.rowCount;
        }
        if (!this.isPersisted()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read row count");){
                this.rowCount = this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, session.getExecutionContext(), (Object)this), session, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            log.debug((Object)"Can't fetch row count", (Throwable)e);
        }
        if (this.rowCount == null) {
            this.rowCount = -1L;
        }
        return this.rowCount;
    }

    @Property(category="Statistics", viewable=false, expensive=true, order=24)
    public synchronized Long getDiskSpace(DBRProgressMonitor monitor) {
        if (this.diskSpace != null) {
            return this.diskSpace;
        }
        if (!this.isPersisted() || this instanceof PostgreView) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Calculate relation size on disk");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("select pg_total_relation_size(?)");){
                    dbStat.setLong(1, this.getObjectId());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.diskSpace = dbResult.getLong(1);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Can't fetch disk space", (Throwable)e);
        }
        if (this.diskSpace == null) {
            this.diskSpace = -1L;
        }
        return this.diskSpace;
    }

    @Override
    public Collection<PostgreTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().constraintCache.getTypedObjects(monitor, this.getSchema(), this, PostgreTableConstraint.class);
    }

    @Override
    public PostgreTableConstraintBase getConstraint(@NotNull DBRProgressMonitor monitor, String ukName) throws DBException {
        return (PostgreTableConstraintBase)this.getSchema().constraintCache.getObject(monitor, this.getSchema(), this, ukName);
    }

    @Association
    public Collection<PostgreTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.triggerCache.getAllObjects(monitor, this);
    }

    public PostgreTrigger getTrigger(DBRProgressMonitor monitor, String name) throws DBException {
        return (PostgreTrigger)this.triggerCache.getObject(monitor, this, name);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        throw new DBException("Table DDL is read-only");
    }

    class TriggerCache
    extends JDBCObjectCache<PostgreTableReal, PostgreTrigger> {
        TriggerCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreTableReal owner) throws SQLException {
            return session.prepareStatement("SELECT x.oid,x.*,p.pronamespace as func_schema_id\nFROM pg_catalog.pg_trigger x\nLEFT OUTER JOIN pg_catalog.pg_proc p ON p.oid=x.tgfoid \nWHERE x.tgrelid=" + owner.getObjectId() + (((PostgreDataSource)PostgreTableReal.this.getDataSource()).isServerVersionAtLeast(9, 0) ? " AND NOT x.tgisinternal" : ""));
        }

        protected PostgreTrigger fetchObject(@NotNull JDBCSession session, @NotNull PostgreTableReal owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreTrigger(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }
}

