/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermission;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreObjectPermission
extends PostgrePermission {
    private static final Log log = Log.getLog(PostgreObjectPermission.class);
    private String grantee;

    public PostgreObjectPermission(PostgrePermissionsOwner owner, String grantee, List<PostgrePrivilege> privileges) {
        super(owner, privileges);
        this.grantee = grantee;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.grantee);
    }

    @Override
    public PostgreRole getTargetObject(DBRProgressMonitor monitor) throws DBException {
        return (PostgreRole)this.owner.getDatabase().roleCache.getObject(monitor, this.owner.getDatabase(), this.grantee);
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(@NotNull PostgrePermission o) {
        if (o instanceof PostgreObjectPermission) {
            return this.grantee.compareTo(((PostgreObjectPermission)o).grantee);
        }
        return 0;
    }
}

