/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreDataSourceProvider;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSourceInfo;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreStructureAssistant;
import org.jkiss.dbeaver.ext.postgresql.model.QueryTransformerFetchAll;
import org.jkiss.dbeaver.ext.postgresql.model.jdbc.PostgreJdbcFactory;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanAnalyser;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.AsyncServerOutputReader;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstanceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.net.DefaultCallbackHandler;
import org.jkiss.utils.CommonUtils;

public class PostgreDataSource
extends JDBCDataSource
implements DBSObjectSelector,
DBSInstanceContainer,
DBCQueryPlanner,
IAdaptable {
    private static final Log log = Log.getLog(PostgreDataSource.class);
    private final DatabaseCache databaseCache = new DatabaseCache();
    private String activeDatabaseName;
    private String activeSchemaName;
    private final List<String> searchPath = new ArrayList<String>();
    private final List<String> defaultSearchPath = new ArrayList<String>();
    private String activeUser;
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile("\\n\\s*\\p{L}+: ([0-9]+)");

    public PostgreDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new PostgreDialect());
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(PostgreDataSourceProvider.getConnectionsProps());
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getDeclaredHandler("postgre_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            try {
                this.initSSL(props, sslConfig);
            }
            catch (Exception e) {
                throw new DBCException("Error configuring SSL certificates", (Throwable)e);
            }
        }
        return props;
    }

    private void initSSL(Map<String, String> props, DBWHandlerConfiguration sslConfig) throws Exception {
        String factoryProp;
        String modeProp;
        String keyCertProp;
        String clientCertProp;
        props.put("ssl", "true");
        String rootCertProp = (String)sslConfig.getProperties().get("rootCert");
        if (!CommonUtils.isEmpty((String)rootCertProp)) {
            props.put("sslrootcert", rootCertProp);
        }
        if (!CommonUtils.isEmpty((String)(clientCertProp = (String)sslConfig.getProperties().get("clientCert")))) {
            props.put("sslcert", clientCertProp);
        }
        if (!CommonUtils.isEmpty((String)(keyCertProp = (String)sslConfig.getProperties().get("clientKey")))) {
            props.put("sslkey", keyCertProp);
        }
        if (!CommonUtils.isEmpty((String)(modeProp = (String)sslConfig.getProperties().get("sslMode")))) {
            props.put("sslmode", modeProp);
        }
        if (!CommonUtils.isEmpty((String)(factoryProp = (String)sslConfig.getProperties().get("sslFactory")))) {
            props.put("sslfactory", factoryProp);
        }
        props.put("sslpasswordcallback", DefaultCallbackHandler.class.getName());
    }

    public Object getDataSourceFeature(String featureId) {
        if ("data-transfer.force-transactions".equals(featureId)) {
            return true;
        }
        return super.getDataSourceFeature(featureId);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, boolean setActiveObject) throws DBCException {
        PostgreSchema activeSchema;
        PostgreDatabase activeDatabase;
        if (setActiveObject && (activeDatabase = this.getDefaultObject()) != null && (activeSchema = activeDatabase.getDefaultObject()) != null) {
            String curDefSchema;
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.META, "Get context active schema");){
                    curDefSchema = JDBCUtils.queryString((JDBCSession)session, (String)"SELECT current_schema()", (Object[])new Object[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException(e, (DBPDataSource)this.getDataSource());
            }
            if (curDefSchema == null || !curDefSchema.equals(activeSchema.getName())) {
                activeDatabase.setSearchPath(monitor, activeSchema, context);
            }
        }
    }

    public DatabaseCache getDatabaseCache() {
        return this.databaseCache;
    }

    public Collection<PostgreDatabase> getDatabases() {
        return this.databaseCache.getCachedObjects();
    }

    public PostgreDatabase getDatabase(String name) {
        return (PostgreDatabase)this.databaseCache.getCachedObject(name);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        this.activeDatabaseName = this.getContainer().getConnectionConfiguration().getDatabaseName();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load meta info");){
                this.determineDefaultObjects(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        this.defaultSearchPath.clear();
        this.defaultSearchPath.addAll(this.searchPath);
        this.databaseCache.getAllObjects(monitor, (DBSObject)this);
        this.getDefaultInstance().cacheDataTypes(monitor);
    }

    private void determineDefaultObjects(JDBCSession session) throws DBCException, SQLException {
        String[] stringArray;
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCPreparedStatement stat = session.prepareStatement("SELECT current_database(), current_schema(),session_user");){
            Throwable throwable2 = null;
            stringArray = null;
            try (JDBCResultSet rs = stat.executeQuery();){
                if (rs.nextRow()) {
                    this.activeDatabaseName = JDBCUtils.safeGetString((ResultSet)rs, (int)1);
                    this.activeSchemaName = JDBCUtils.safeGetString((ResultSet)rs, (int)2);
                    this.activeUser = JDBCUtils.safeGetString((ResultSet)rs, (int)3);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        String searchPathStr = JDBCUtils.queryString((JDBCSession)session, (String)"SHOW search_path", (Object[])new Object[0]);
        this.searchPath.clear();
        if (searchPathStr != null) {
            stringArray = searchPathStr.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                str = str.trim();
                this.searchPath.add(DBUtils.getUnQuotedIdentifier((DBPDataSource)this, (String)str));
                ++n2;
            }
        } else {
            this.searchPath.add("public");
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.databaseCache.clearCache();
        this.activeDatabaseName = null;
        this.initialize(monitor);
        return this;
    }

    public Collection<? extends PostgreDatabase> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDatabases();
    }

    public PostgreDatabase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getDatabase(childName);
    }

    public Class<? extends PostgreDatabase> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return PostgreDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.databaseCache.getAllObjects(monitor, (DBSObject)this);
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public PostgreDatabase getDefaultObject() {
        return this.activeDatabaseName == null ? null : this.getDatabase(this.activeDatabaseName);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        PostgreDatabase oldDatabase = this.getDefaultObject();
        if (!(object instanceof PostgreDatabase)) {
            throw new IllegalArgumentException("Invalid object type: " + object);
        }
        PostgreDatabase newDatabase = (PostgreDatabase)object;
        if (oldDatabase == newDatabase) {
            return;
        }
        this.activeDatabaseName = object.getName();
        JDBCExecutionContext[] jDBCExecutionContextArray = this.getAllContexts();
        int n = jDBCExecutionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCExecutionContext context = jDBCExecutionContextArray[n2];
            context.reconnect(monitor);
            ++n2;
        }
        this.getDefaultInstance().cacheDataTypes(monitor);
        DBPConnectionConfiguration conConfig = this.getContainer().getConnectionConfiguration();
        conConfig.setDatabaseName(this.activeDatabaseName);
        conConfig.setUrl(this.getContainer().getDriver().getDataSourceProvider().getConnectionURL(this.getContainer().getDriver(), conConfig));
        this.getContainer().getRegistry().flushConfig();
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try (JDBCSession session = this.getDefaultContext(false).openSession(monitor, DBCExecutionPurpose.UTIL, "Update object state");){
                this.determineDefaultObjects(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)this);
        }
        if (oldDatabase != null) {
            DBUtils.fireObjectSelect((DBSObject)oldDatabase, (boolean)false);
            DBUtils.fireObjectUpdate((DBSObject)oldDatabase, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)newDatabase, (boolean)true);
        DBUtils.fireObjectUpdate((DBSObject)newDatabase, (boolean)true);
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        PostgreDatabase activeDatabase = this.getDefaultObject();
        if (activeDatabase == null) {
            return false;
        }
        try {
            PostgreSchema newSchema;
            String oldDefSchema = this.activeSchemaName;
            this.determineDefaultObjects((JDBCSession)session);
            if (this.activeSchemaName != null && !CommonUtils.equalObjects((Object)oldDefSchema, (Object)this.activeSchemaName) && (newSchema = activeDatabase.getSchema(session.getProgressMonitor(), this.activeSchemaName)) != null) {
                activeDatabase.setDefaultObject(session.getProgressMonitor(), newSchema);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)this);
        }
    }

    public String getActiveUser() {
        return this.activeUser;
    }

    public String getActiveSchemaName() {
        return this.activeSchemaName;
    }

    public void setActiveSchemaName(String activeSchemaName) {
        this.activeSchemaName = activeSchemaName;
    }

    public List<String> getSearchPath() {
        return this.searchPath;
    }

    List<String> getDefaultSearchPath() {
        return this.defaultSearchPath;
    }

    public void setSearchPath(String path) {
        this.searchPath.clear();
        this.searchPath.add(path);
        if (!path.equals(this.activeUser)) {
            this.searchPath.add(this.activeUser);
        }
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBCException {
        Connection pgConnection;
        DBPConnectionConfiguration conConfig = this.getContainer().getActualConnectionConfiguration();
        if (this.activeDatabaseName != null && !CommonUtils.equalObjects((Object)this.activeDatabaseName, (Object)conConfig.getDatabaseName())) {
            DBPConnectionConfiguration originalConfig = new DBPConnectionConfiguration(conConfig);
            try {
                conConfig.setDatabaseName(this.activeDatabaseName);
                conConfig.setUrl(this.getContainer().getDriver().getDataSourceProvider().getConnectionURL(this.getContainer().getDriver(), conConfig));
                pgConnection = super.openConnection(monitor, purpose);
            }
            finally {
                conConfig.setDatabaseName(originalConfig.getDatabaseName());
                conConfig.setUrl(originalConfig.getUrl());
            }
        } else {
            pgConnection = super.openConnection(monitor, purpose);
        }
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            try {
                pgConnection.setClientInfo("ApplicationName", DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (String)purpose));
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return pgConnection;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query) throws DBCException {
        PostgrePlanAnalyser plan = new PostgrePlanAnalyser(this.getPlanStyle() == DBCPlanStyle.QUERY, query);
        if (this.getPlanStyle() == DBCPlanStyle.PLAN) {
            plan.explain(session);
        }
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return this.isServerVersionAtLeast(9, 0) ? DBCPlanStyle.PLAN : DBCPlanStyle.QUERY;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new PostgreStructureAssistant(this));
        }
        if (adapter == DBCServerOutputReader.class) {
            return adapter.cast(new AsyncServerOutputReader());
        }
        return (T)super.getAdapter(adapter);
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return this;
    }

    public Collection<PostgreDataType> getLocalDataTypes() {
        PostgreSchema schema = this.getDefaultInstance().getCatalogSchema();
        if (schema != null) {
            return schema.dataTypeCache.getCachedObjects();
        }
        return null;
    }

    public PostgreDataType getLocalDataType(String typeName) {
        return this.getDefaultInstance().getDataType((DBRProgressMonitor)new VoidProgressMonitor(), typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        return this.getDefaultInstance().getDataType((DBRProgressMonitor)new VoidProgressMonitor(), typeID);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return PostgreUtils.getDefaultDataTypeName(dataKind);
    }

    @NotNull
    public PostgreDatabase getDefaultInstance() {
        PostgreDatabase defDatabase = (PostgreDatabase)this.databaseCache.getCachedObject(this.activeDatabaseName);
        if (defDatabase == null) {
            defDatabase = (PostgreDatabase)this.databaseCache.getCachedObject("postgres");
        }
        if (defDatabase == null) {
            List allDatabases = this.databaseCache.getCachedObjects();
            if (allDatabases.isEmpty()) {
                throw new IllegalStateException("No default database");
            }
            defDatabase = (PostgreDatabase)allDatabases.get(0);
        }
        return defDatabase;
    }

    @NotNull
    public Collection<PostgreDatabase> getAvailableInstances() {
        return this.databaseCache.getCachedObjects();
    }

    /*
     * Exception decompiling
     */
    public List<String> getTemplateDatabases(DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean isGreenplum() {
        return PostgreUtils.isGreenplumDriver(this.getContainer().getDriver());
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        Matcher matcher;
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message) && (matcher = this.ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.position = Integer.parseInt(matcher.group(1)) - 1;
            return new DBPErrorAssistant.ErrorPosition[]{pos};
        }
        return null;
    }

    @NotNull
    protected JDBCFactory createJdbcFactory() {
        return new PostgreJdbcFactory();
    }

    protected DBPDataSourceInfo createDataSourceInfo(@NotNull JDBCDatabaseMetaData metaData) {
        return new PostgreDataSourceInfo(metaData);
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, true);
        }
        if (type == DBCQueryTransformType.FETCH_ALL_TABLE) {
            return new QueryTransformerFetchAll();
        }
        return null;
    }

    class DatabaseCache
    extends JDBCObjectLookupCache<PostgreDataSource, PostgreDatabase> {
        DatabaseCache() {
        }

        protected PostgreDatabase fetchObject(@NotNull JDBCSession session, @NotNull PostgreDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new PostgreDatabase(owner, resultSet);
        }

        public JDBCStatement prepareLookupStatement(JDBCSession session, PostgreDataSource owner, PostgreDatabase object, String objectName) throws SQLException {
            boolean showNDD = CommonUtils.toBoolean((Object)PostgreDataSource.this.getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-show-non-default-db@"));
            StringBuilder catalogQuery = new StringBuilder("SELECT db.oid,db.*\nFROM pg_catalog.pg_database db WHERE NOT datistemplate AND datallowconn");
            if (object != null) {
                catalogQuery.append("\nAND db.oid=?");
            } else if (objectName != null || !showNDD) {
                catalogQuery.append("\nAND db.datname=?");
            }
            DBSObjectFilter catalogFilters = owner.getContainer().getObjectFilter(PostgreDatabase.class, null, false);
            if (showNDD) {
                if (catalogFilters != null) {
                    JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"datname", (boolean)true);
                }
                catalogQuery.append("\nORDER BY db.datname");
            }
            JDBCPreparedStatement dbStat = session.prepareStatement(catalogQuery.toString());
            if (object != null) {
                dbStat.setLong(1, object.getObjectId());
            } else if (objectName != null || !showNDD) {
                dbStat.setString(1, object != null ? object.getName() : (objectName != null ? objectName : PostgreDataSource.this.activeDatabaseName));
            } else if (catalogFilters != null) {
                JDBCUtils.setFilterParameters((JDBCPreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
            }
            return dbStat;
        }
    }
}

