/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManagerBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableInheritance;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class PostgreTableManager
extends PostgreTableManagerBase
implements DBEObjectRenamer<PostgreTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{PostgreTableColumn.class, PostgreTableConstraint.class, PostgreTableForeignKey.class, PostgreIndex.class};

    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreSchema)object.getContainer()).tableCache;
    }

    protected PostgreTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, PostgreSchema parent, Object copyFrom) {
        PostgreTableRegular table = new PostgreTableRegular(parent);
        try {
            this.setTableName(monitor, (DBSObjectContainer)parent, table);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return table;
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if ((command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) && command.getObject() instanceof PostgreTableRegular) {
            try {
                this.generateAlterActions(actionList, command);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private void generateAlterActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        PostgreTableRegular table = (PostgreTableRegular)command.getObject();
        String alterPrefix = "ALTER TABLE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ";
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        if (command.hasProperty((Object)"hasOids")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + (table.isHasOids() ? "SET WITH OIDS" : "SET WITHOUT OIDS")));
        }
        if (command.hasProperty((Object)"tablespace")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + "SET TABLESPACE " + table.getTablespace((DBRProgressMonitor)monitor).getName()));
        }
    }

    protected void appendTableModifiers(PostgreTableBase tableBase, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        if (tableBase instanceof PostgreTableRegular) {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            PostgreTableRegular table = (PostgreTableRegular)tableBase;
            try {
                if (!alter) {
                    List<PostgreTableInheritance> superTables = table.getSuperInheritance((DBRProgressMonitor)monitor);
                    if (!CommonUtils.isEmpty(superTables)) {
                        ddl.append("\nINHERITS (");
                        int i = 0;
                        while (i < superTables.size()) {
                            if (i > 0) {
                                ddl.append(",");
                            }
                            ddl.append(superTables.get(i).getAssociatedEntity().getFullyQualifiedName(DBPEvaluationContext.DDL));
                            ++i;
                        }
                        ddl.append(")");
                    }
                    ddl.append("\nWITH (\n\tOIDS=").append(table.isHasOids() ? "TRUE" : "FALSE");
                    ddl.append("\n)");
                }
                boolean hasOtherSpecs = false;
                PostgreTablespace tablespace = table.getTablespace((DBRProgressMonitor)monitor);
                if (tablespace != null && table.isTablespaceSpecified()) {
                    if (!alter) {
                        ddl.append("\nTABLESPACE ").append(tablespace.getName());
                    }
                    hasOtherSpecs = true;
                }
                if (!alter && hasOtherSpecs) {
                    ddl.append("\n");
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    protected void addObjectRenameActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableBase object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + (command.getObject() instanceof PostgreTableForeign ? "FOREIGN TABLE" : "TABLE") + " " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + (CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }
}

