/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreConstraintManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKeyColumn;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.utils.CommonUtils;

public class PostgreForeignKeyManager
extends SQLForeignKeyManager<PostgreTableForeignKey, PostgreTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreTableForeignKey> getObjectsCache(PostgreTableForeignKey object) {
        PostgreTableBase parent = (PostgreTableBase)object.getParentObject();
        if (parent instanceof PostgreTable) {
            return ((PostgreTable)parent).getForeignKeyCache();
        }
        return null;
    }

    protected PostgreTableForeignKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final PostgreTableBase table, Object from) {
        return (PostgreTableForeignKey)new UITask<PostgreTableForeignKey>(){

            protected PostgreTableForeignKey runTask() {
                EditForeignKeyPage editPage = new EditForeignKeyPage("Edit foreign key", (DBSTable)table, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT});
                if (!editPage.edit()) {
                    return null;
                }
                PostgreTableForeignKey foreignKey = new PostgreTableForeignKey(table, (DBSEntityConstraint)editPage.getUniqueConstraint(), editPage.getOnDeleteRule(), editPage.getOnUpdateRule());
                foreignKey.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)foreignKey, (String)(String.valueOf(CommonUtils.escapeIdentifier((String)table.getName())) + "_" + CommonUtils.escapeIdentifier((String)editPage.getUniqueConstraint().getParentObject().getName()) + "_FK")));
                int colIndex = 1;
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editPage.getColumns()) {
                    foreignKey.addColumn(new PostgreTableForeignKeyColumn(foreignKey, (PostgreTableColumn)tableColumn.getOwnColumn(), colIndex++, (PostgreTableColumn)tableColumn.getRefColumn()));
                }
                return foreignKey;
            }
        }.execute();
    }

    public StringBuilder getNestedDeclaration(PostgreTableBase owner, DBECommandAbstract<PostgreTableForeignKey> command, Map<String, Object> options) {
        PostgreTableForeignKey fk = (PostgreTableForeignKey)command.getObject();
        if (fk.isPersisted()) {
            try {
                String constrDDL = fk.getObjectDefinitionText((DBRProgressMonitor)new VoidProgressMonitor(), Collections.singletonMap("embedded.source", true));
                if (!CommonUtils.isEmpty((String)constrDDL)) {
                    return new StringBuilder(constrDDL);
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't extract FK DDL", (Throwable)e);
            }
        }
        return super.getNestedDeclaration((JDBCTable)owner, command, options);
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperty((Object)"description") != null) {
            PostgreConstraintManager.addConstraintCommentAction(actionList, (PostgreTableConstraintBase)command.getObject());
        }
    }

    protected String getDropForeignKeyPattern(PostgreTableForeignKey foreignKey) {
        return "ALTER TABLE %TABLE% DROP CONSTRAINT %CONSTRAINT%";
    }
}

