/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObjectState;

public class PostgreConstants {
    public static final int DEFAULT_PORT = 5432;
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_DATABASE = "postgres";
    public static final String DEFAULT_DATA_TYPE = "varchar";
    public static final String PROP_SHOW_NON_DEFAULT_DB = "@dbeaver-show-non-default-db@";
    public static final String PROP_SWITCH_DB_ON_EXPAND = "@dbeaver-switch-db-on-expand@";
    public static final String PROP_SSL_CLIENT_CERT = "clientCert";
    public static final String PROP_SSL_CLIENT_KEY = "clientKey";
    public static final String PROP_SSL_ROOT_CERT = "rootCert";
    public static final String PROP_SSL_MODE = "sslMode";
    public static final String PROP_SSL_FACTORY = "sslFactory";
    public static final String PROP_GREENPLUM_DRIVER = "greenplum";
    public static final String OPTION_DDL_SHOW_PERMISSIONS = "pg.ddl.show.permissions";
    public static final String OPTION_DDL_SHOW_COLUMN_COMMENTS = "pg.ddl.show.column.comments";
    public static final DBSObjectState STATE_UNAVAILABLE = new DBSObjectState("Unavailable", (DBPImage)DBIcon.OVER_EXTERNAL);
    public static final DBSEntityConstraintType CONSTRAINT_TRIGGER = new DBSEntityConstraintType("trigger", "TRIGGER", "Trigger constraint", false, false, false);
    public static final DBSEntityConstraintType CONSTRAINT_EXCLUSIVE = new DBSEntityConstraintType("exclusive", "EXCLUSIVE", "Exclusive constraint", false, false, false);
    public static final String INFO_SCHEMA_NAME = "information_schema";
    public static final String CATALOG_SCHEMA_NAME = "pg_catalog";
    public static final String TEMP_SCHEMA_NAME = "pg_temp";
    public static final String TOAST_SCHEMA_PREFIX = "pg_toast";
    public static final String TEMP_SCHEMA_PREFIX = "pg_temp_";
    public static final String PUBLIC_SCHEMA_NAME = "public";
    public static final String PG_OBJECT_CLASS = "org.postgresql.util.PGobject";
    public static final String PG_ARRAY_CLASS = "org.postgresql.jdbc.PgArray";
    public static final DBDPseudoAttribute PSEUDO_ATTR_OID = new DBDPseudoAttribute(DBDPseudoAttributeType.ROWID, "oid", "oid", "oid", "Row identifier", false);
    public static final String TYPE_VARCHAR = "varchar";
    public static final String TYPE_HSTORE = "hstore";
    public static final String TYPE_JSON = "json";
    public static final String TYPE_JSONB = "jsonb";
    public static final String TYPE_BIT = "bit";
    public static final String TYPE_REFCURSOR = "refcursor";
    public static final String TYPE_MONEY = "money";
    public static final String TYPE_GEOMETRY = "geometry";
    public static final String HANDLER_SSL = "postgre_ssl";
    public static final String EC_PERMISSION_DENIED = "42501";
    public static final String EC_QUERY_CANCELED = "57014";
    public static final String PG_INSTALL_REG_KEY = "SOFTWARE\\PostgreSQL\\Installations";
    public static final String PG_INSTALL_PROP_BASE_DIRECTORY = "Base Directory";
    public static final String PG_INSTALL_PROP_VERSION = "Version";
    public static final String PG_INSTALL_PROP_BRANDING = "Branding";
    public static final String PG_INSTALL_PROP_DATA_DIRECTORY = "Data Directory";
    public static final String BIN_FOLDER = "bin";
    public static final Map<String, String> SERIAL_TYPES = new HashMap<String, String>();
    public static final Map<String, String> DATA_TYPE_ALIASES = new HashMap<String, String>();
    public static final Map<String, String> DATA_TYPE_CANONICAL_NAMES = new HashMap<String, String>();
    public static final String TYPE_INT2 = "int2";
    public static final String TYPE_INT4 = "int4";
    public static final String TYPE_INT8 = "int8";
    public static final String TYPE_FLOAT4 = "float4";
    public static final String TYPE_FLOAT8 = "float8";

    static {
        DATA_TYPE_ALIASES.put("integer", TYPE_INT4);
        DATA_TYPE_ALIASES.put("int", TYPE_INT4);
        DATA_TYPE_ALIASES.put("bigint", TYPE_INT8);
        DATA_TYPE_ALIASES.put("smallint", TYPE_INT2);
        DATA_TYPE_ALIASES.put("double precision", TYPE_FLOAT8);
        DATA_TYPE_ALIASES.put("real", TYPE_FLOAT4);
        DATA_TYPE_ALIASES.put("void", "void");
        SERIAL_TYPES.put("serial", TYPE_INT4);
        SERIAL_TYPES.put("serial8", TYPE_INT8);
        SERIAL_TYPES.put("serial2", TYPE_INT2);
        SERIAL_TYPES.put("smallserial", TYPE_INT2);
        SERIAL_TYPES.put("bigserial", TYPE_INT8);
        DATA_TYPE_CANONICAL_NAMES.put(TYPE_INT4, "integer");
        DATA_TYPE_CANONICAL_NAMES.put(TYPE_INT8, "bigint");
        DATA_TYPE_CANONICAL_NAMES.put(TYPE_INT2, "smallint");
        DATA_TYPE_CANONICAL_NAMES.put(TYPE_FLOAT4, "real");
        DATA_TYPE_CANONICAL_NAMES.put("character varying", "varchar");
    }
}

