/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.lm;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import org.jkiss.lm.LMEncryption;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicenseFormat;
import org.jkiss.lm.LMLicenseType;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.CommonUtils;

public class LMLicense {
    private static final Logger log = Logger.getLogger("LMLicense");
    public static final long FLAG_CANCELED = 1L;
    public static final long FLAG_RESELLER = 4L;
    public static final long FLAG_UNLIMITED_USERS = 256L;
    public static final long FLAG_UNLIMITED_TIME = 512L;
    private byte[] encoded;
    private String licenseId;
    private LMLicenseType licenseType;
    private Date licenseIssueTime;
    private Date licenseStartTime;
    private Date licenseEndTime;
    private long flags;
    private String productId;
    private String productVersion;
    private String ownerId;
    private String ownerCompany;
    private String ownerName;
    private String ownerEmail;
    private byte yearsNumber;
    private byte reserved1;
    private short usersNumber;
    private LMLicenseFormat licenseFormat;

    public LMLicense(byte[] encryptedData, Key key) throws LMException {
        this.encoded = encryptedData;
        byte[] data = LMEncryption.decrypt(encryptedData, key);
        int offset = 0;
        this.licenseFormat = LMLicenseFormat.STANDARD;
        try {
            this.licenseFormat = LMLicenseFormat.valueOf(data[offset]);
        }
        catch (Exception e) {
            log.warning("Unsupported license format: " + data[offset]);
        }
        ++offset;
        if (data.length != this.licenseFormat.getEncryptedLength()) {
            throw new LMException("Bad " + (Object)((Object)this.licenseFormat) + " license length (" + data.length + ")");
        }
        this.licenseId = new String(data, offset, 16).trim();
        this.licenseType = LMLicenseType.valueOf(data[offset += 16]);
        this.licenseIssueTime = LMLicense.getDateFromBytes(data, ++offset);
        this.licenseStartTime = LMLicense.getDateFromBytes(data, offset += 8);
        this.licenseEndTime = LMLicense.getDateFromBytes(data, offset += 8);
        this.flags = LMUtils.bytesToLong(data, offset += 8);
        this.productId = new String(data, offset += 8, 16).trim();
        this.productVersion = new String(data, offset += 16, 8).trim();
        this.ownerId = new String(data, offset += 8, 16).trim();
        this.ownerCompany = new String(data, offset += 16, 64).trim();
        offset += 64;
        if (this.licenseFormat == LMLicenseFormat.STANDARD) {
            this.ownerName = new String(data, offset, 64).trim();
            offset += 64;
        } else {
            this.ownerName = new String(data, offset, 32).trim();
            this.ownerEmail = new String(data, offset += 32, 48).trim();
            offset += 48;
            this.yearsNumber = data[offset++];
            if (this.yearsNumber <= 0) {
                this.yearsNumber = 1;
            }
            this.reserved1 = data[offset++];
            this.usersNumber = LMUtils.bytesToShort(data, offset);
            if (this.usersNumber <= 0) {
                this.usersNumber = 1;
            }
            offset += 2;
        }
    }

    public LMLicense(String licenseId, LMLicenseType licenseType, Date licenseIssueTime, Date licenseStartTime, Date licenseEndTime, long flags, String productId, String productVersion, String ownerId, String ownerCompany, String ownerName, String ownerEmail) {
        this.licenseFormat = LMLicenseFormat.EXTENDED;
        this.licenseId = licenseId;
        this.licenseType = licenseType;
        this.licenseIssueTime = licenseIssueTime;
        this.licenseStartTime = licenseStartTime;
        this.licenseEndTime = licenseEndTime;
        this.flags = flags;
        this.productId = productId;
        this.productVersion = productVersion;
        this.ownerId = ownerId;
        this.ownerCompany = ownerCompany;
        this.ownerName = ownerName;
        this.ownerEmail = ownerEmail;
        this.yearsNumber = 1;
        this.reserved1 = 0;
        this.usersNumber = 1;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public LMLicenseFormat getLicenseFormat() {
        return this.licenseFormat;
    }

    public void setLicenseFormat(LMLicenseFormat licenseFormat) {
        this.licenseFormat = licenseFormat;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public LMLicenseType getLicenseType() {
        return this.licenseType;
    }

    public Date getLicenseIssueTime() {
        return this.licenseIssueTime;
    }

    public Date getLicenseStartTime() {
        return this.licenseStartTime;
    }

    public Date getLicenseEndTime() {
        return this.licenseEndTime;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerCompany() {
        return this.ownerCompany;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public byte getYearsNumber() {
        return this.yearsNumber;
    }

    public void setYearsNumber(byte yearsNumber) {
        this.yearsNumber = yearsNumber;
    }

    public byte getReserved1() {
        return this.reserved1;
    }

    public short getUsersNumber() {
        return this.usersNumber;
    }

    public void setUsersNumber(short usersNumber) {
        this.usersNumber = usersNumber;
    }

    public String getOwnerFull() {
        String licensedTo = this.ownerName;
        if (!CommonUtils.isEmpty((String)this.ownerCompany)) {
            licensedTo = String.valueOf(this.ownerCompany) + " / " + licensedTo;
        }
        return licensedTo;
    }

    public byte[] getData() {
        byte[] data = new byte[this.licenseFormat.getEncryptedLength()];
        int offset = 0;
        data[offset] = this.licenseFormat.getId();
        LMLicense.copyStringBytes(data, ++offset, this.licenseId, 16);
        offset += 16;
        data[offset++] = this.licenseType.getId();
        LMLicense.copyDateBytes(data, offset, this.licenseIssueTime);
        LMLicense.copyDateBytes(data, offset += 8, this.licenseStartTime);
        LMLicense.copyDateBytes(data, offset += 8, this.licenseEndTime);
        System.arraycopy(LMUtils.longToBytes(this.flags), 0, data, offset += 8, 8);
        LMLicense.copyStringBytes(data, offset += 8, this.productId, 16);
        LMLicense.copyStringBytes(data, offset += 16, this.productVersion, 8);
        LMLicense.copyStringBytes(data, offset += 8, this.ownerId, 16);
        LMLicense.copyStringBytes(data, offset += 16, this.ownerCompany, 64);
        offset += 64;
        switch (this.licenseFormat) {
            case STANDARD: {
                LMLicense.copyStringBytes(data, offset, this.ownerName, 64);
                offset += 64;
                break;
            }
            case EXTENDED: {
                LMLicense.copyStringBytes(data, offset, this.ownerName, 32);
                LMLicense.copyStringBytes(data, offset += 32, this.ownerEmail, 48);
                offset += 48;
                data[offset++] = this.yearsNumber;
                data[offset++] = this.reserved1;
                System.arraycopy(LMUtils.shortToBytes(this.usersNumber), 0, data, offset, 2);
                offset += 2;
                break;
            }
        }
        return data;
    }

    public String toString() {
        return "licenseId=" + this.licenseId + "\nlicenseType=" + (Object)((Object)this.licenseType) + "\nlicenseIssueTime=" + this.licenseIssueTime + "\nlicenseStartTime=" + this.licenseStartTime + "\nlicenseEndTime=" + this.licenseEndTime + "\nflags=" + this.flags + "\nproductId=" + this.productId + "\nproductVersion=" + this.productVersion + "\nownerId=" + this.ownerId + "\nownerCompany=" + this.ownerCompany + "\nownerName=" + this.ownerName + "\nownerEmail=" + this.ownerEmail + "\nyearsNumber=" + this.yearsNumber + "\nusersNumber=" + this.usersNumber;
    }

    private static void copyStringBytes(byte[] data, int offset, String string, int length) {
        try {
            byte[] strData = string == null ? new byte[]{} : string.getBytes("utf-8");
            System.arraycopy(strData, 0, data, offset, strData.length);
            int i = strData.length;
            while (i < length) {
                data[offset + i] = 32;
                ++i;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static void copyDateBytes(byte[] data, int offset, Date date) {
        byte[] dateBytes = date == null ? new byte[8] : LMUtils.longToBytes(date.getTime());
        System.arraycopy(dateBytes, 0, data, offset, dateBytes.length);
    }

    private static Date getDateFromBytes(byte[] data, int offset) {
        long time = LMUtils.bytesToLong(data, offset);
        return time == 0L ? null : new Date(time);
    }

    public boolean isValidFor(LMProduct product, boolean checkExpired) {
        Date licenseEndTime;
        if (!this.productId.equals(product.getId())) {
            return false;
        }
        if (checkExpired) {
            long dayMS = 86400000L;
            Date curDate = new Date();
            licenseEndTime = this.getLicenseEndTime();
            switch (this.getLicenseType()) {
                case TRIAL: 
                case ACADEMIC: {
                    if (licenseEndTime != null) break;
                    licenseEndTime = new Date(this.licenseStartTime.getTime() + dayMS * 365L);
                }
            }
            if (licenseEndTime != null && licenseEndTime.compareTo(curDate) < 0) {
                return false;
            }
        }
        Date releaseDate = product.getReleaseDate();
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.getLicenseIssueTime());
        byte yearsNumber = this.getYearsNumber();
        if (yearsNumber <= 0) {
            yearsNumber = 1;
        }
        cl.add(1, yearsNumber);
        licenseEndTime = cl.getTime();
        return licenseEndTime.compareTo(releaseDate) >= 0;
    }
}

