/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.NettySSLOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TupleType;
import com.dbeaver.ee.cassandra.CasUtils;
import com.dbeaver.ee.cassandra.model.CasCQLDialect;
import com.dbeaver.ee.cassandra.model.CasDataSourceInfo;
import com.dbeaver.ee.cassandra.model.CasDataType;
import com.dbeaver.ee.cassandra.model.CasExecutionContext;
import com.dbeaver.ee.cassandra.model.CasHost;
import com.dbeaver.ee.cassandra.model.CasKeyspace;
import com.dbeaver.ee.cassandra.model.CasStructureAssistant;
import com.dbeaver.ee.cassandra.model.CasTupleType;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class CasDataSource
implements DBPDataSource,
SQLDataSource,
DBSObject,
DBSObjectSelector,
DBSObjectContainer,
DBPRefreshableObject,
DBPTermProvider,
DBPDataTypeProvider,
DBPErrorAssistant,
IAdaptable {
    private static final Log log = Log.getLog(CasDataSource.class);
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile("line\\s+([0-9]+):([0-9]+)");
    @NotNull
    private DBPDataSourceContainer container;
    @NotNull
    private CasExecutionContext executionContext;
    List<CasExecutionContext> allContexts = new ArrayList<CasExecutionContext>();
    @NotNull
    private final Cluster cluster;
    private String selectedKeyspace;
    private List<CasKeyspace> keyspaces = new ArrayList<CasKeyspace>();
    private List<CasHost> hosts;
    private CasDataSourceInfo info;
    @NotNull
    private final Map<String, CasDataType> typeMap = new LinkedHashMap<String, CasDataType>();
    private final Map<TupleType, CasTupleType> tupleTypeCache = new LinkedHashMap<TupleType, CasTupleType>();

    public CasDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        boolean tcpNoDelay;
        String soLinger;
        String sendBufferSize;
        String recvBufferSize;
        boolean reuseAddress;
        boolean keepAlive;
        String readTimeout;
        this.container = container;
        DataType.Name[] nameArray = DataType.Name.values();
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType.Name typeName = nameArray[n2];
            this.typeMap.put(typeName.toString(), new CasDataType(this, typeName));
            ++n2;
        }
        DBPConnectionConfiguration connectionInfo = this.getContainer().getActualConnectionConfiguration();
        String hostName = connectionInfo.getHostName();
        String hostPort = connectionInfo.getHostPort();
        Cluster.Builder builder = Cluster.builder();
        if (!CommonUtils.isEmpty((String)hostName)) {
            builder.addContactPoint(hostName);
        }
        if (!CommonUtils.isEmpty((String)hostPort)) {
            builder.withPort(Integer.parseInt(hostPort));
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            builder.withCredentials(connectionInfo.getUserName(), connectionInfo.getUserPassword());
        }
        if (CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-ssl@"))) {
            this.configureSSL(builder);
        }
        if (connectionInfo.getKeepAliveInterval() > 0) {
            builder.withPoolingOptions(new PoolingOptions().setHeartbeatIntervalSeconds(connectionInfo.getKeepAliveInterval()));
        }
        SocketOptions socketOptions = new SocketOptions();
        String connTimeout = connectionInfo.getProviderProperty("@dbeaver-cas.timeout.connect@");
        if (!CommonUtils.isEmpty((String)connTimeout)) {
            socketOptions.setConnectTimeoutMillis(CommonUtils.toInt((Object)connTimeout));
        }
        if (!CommonUtils.isEmpty((String)(readTimeout = connectionInfo.getProviderProperty("@dbeaver-cas.timeout.read@")))) {
            socketOptions.setReadTimeoutMillis(CommonUtils.toInt((Object)readTimeout));
        }
        if (keepAlive = CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-cas.net.keepAlive@"), (boolean)false)) {
            socketOptions.setKeepAlive(true);
        }
        if (reuseAddress = CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-cas.net.reuseAddr@"), (boolean)false)) {
            socketOptions.setReuseAddress(true);
        }
        if (!CommonUtils.isEmpty((String)(recvBufferSize = connectionInfo.getProviderProperty("@dbeaver-cas.net.receiveBufferSize@")))) {
            socketOptions.setReceiveBufferSize(CommonUtils.toInt((Object)recvBufferSize));
        }
        if (!CommonUtils.isEmpty((String)(sendBufferSize = connectionInfo.getProviderProperty("@dbeaver-cas.net.sendBufferSize@")))) {
            socketOptions.setSendBufferSize(CommonUtils.toInt((Object)sendBufferSize));
        }
        if (!CommonUtils.isEmpty((String)(soLinger = connectionInfo.getProviderProperty("@dbeaver-cas.net.soLinger@")))) {
            socketOptions.setSoLinger(CommonUtils.toInt((Object)soLinger));
        }
        if (tcpNoDelay = CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-cas.net.tcpNoDelay@"), (boolean)false)) {
            socketOptions.setTcpNoDelay(true);
        }
        builder.withSocketOptions(socketOptions);
        this.cluster = builder.build();
        this.selectedKeyspace = connectionInfo.getDatabaseName();
        this.executionContext = new CasExecutionContext(this, "Main CQL Connection");
        this.executionContext.connect(monitor);
    }

    private void configureSSL(Cluster.Builder builder) throws DBException {
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getDeclaredHandler("cassandra_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            String trustStorePath = (String)sslConfig.getProperties().get("ssl.trustStore");
            String trustStorePassword = (String)sslConfig.getProperties().get("ssl.trustStorePassword");
            String clientCert = (String)sslConfig.getProperties().get("ssl.client.cert");
            String clientKey = (String)sslConfig.getProperties().get("ssl.client.key");
            try {
                SslContextBuilder sslBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.JDK);
                if (!CommonUtils.isEmpty((String)trustStorePath)) {
                    KeyStore ks = KeyStore.getInstance("JKS");
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (FileInputStream trustStore = new FileInputStream(trustStorePath);){
                        ks.load(trustStore, CommonUtils.isEmpty((String)trustStorePassword) ? null : trustStorePassword.toCharArray());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    sslBuilder.trustManager(tmf);
                } else if (!CommonUtils.isEmpty((String)clientCert) && !CommonUtils.isEmpty((String)clientKey)) {
                    sslBuilder.keyManager(new File(clientCert), new File(clientKey));
                } else {
                    builder.withSSL();
                    return;
                }
                NettySSLOptions sslOptions = new NettySSLOptions(sslBuilder.build());
                builder.withSSL((SSLOptions)sslOptions);
            }
            catch (Throwable e) {
                throw new DBException("Error configuring SSL client using trust store", e);
            }
        }
        builder.withSSL();
    }

    @NotNull
    public Cluster getCluster() {
        return this.cluster;
    }

    @Association
    public Collection<CasKeyspace> getKeyspaces() {
        return this.keyspaces;
    }

    public CasKeyspace getKeyspace(String name) {
        return (CasKeyspace)DBUtils.findObject(this.keyspaces, (String)name);
    }

    @Association
    public Collection<CasHost> getHosts(@NotNull DBRProgressMonitor monitor) {
        if (this.hosts == null) {
            monitor.beginTask("Load cluster hosts", 1);
            try {
                this.hosts = new ArrayList<CasHost>();
                Set allHosts = this.cluster.getMetadata().getAllHosts();
                for (Host host : allHosts) {
                    this.hosts.add(new CasHost(this, host));
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
        return this.hosts;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public CasDataSource getDataSource() {
        return this;
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    @NotNull
    public CasExecutionContext getDefaultContext(boolean meta) {
        return this.executionContext;
    }

    @NotNull
    public CasExecutionContext[] getAllContexts() {
        return this.allContexts.toArray(new CasExecutionContext[this.allContexts.size()]);
    }

    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBException {
        CasExecutionContext context = new CasExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        Metadata metadata = this.cluster.getMetadata();
        List ksList = metadata.getKeyspaces();
        if (ksList != null) {
            for (KeyspaceMetadata ks : ksList) {
                CasKeyspace keyspace = new CasKeyspace(this, ks);
                this.keyspaces.add(keyspace);
            }
            Collections.sort(this.keyspaces, DBUtils.nameComparator());
        }
        this.info = new CasDataSourceInfo(metadata);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.keyspaces.clear();
        this.initialize(monitor);
        return this;
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public String getSelectedKeyspaceName() {
        return this.selectedKeyspace;
    }

    public CasKeyspace getDefaultObject() {
        return this.getKeyspace(this.selectedKeyspace);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        if (!(object instanceof CasKeyspace)) {
            throw new DBException("Bad active object: " + object);
        }
        CasKeyspace newKeyspace = (CasKeyspace)object;
        CasKeyspace oldSelectedEntity = this.getDefaultObject();
        this.setActiveEntityName(newKeyspace);
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)newKeyspace, (boolean)true);
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        return false;
    }

    void setActiveEntityName(CasKeyspace entity) throws DBException {
        this.selectedKeyspace = entity.getName();
        for (CasExecutionContext context : this.allContexts) {
            context.reconnect();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new CasStructureAssistant(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        String term = null;
        if ("cluster".equals(objectType)) {
            term = "Cluster";
        } else if ("keypace".equals(objectType)) {
            term = "Keyspace";
        }
        if (term != null && multiple) {
            term = String.valueOf(term) + "s";
        }
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor monitor) {
        CasDataSource casDataSource = this;
        synchronized (casDataSource) {
            this.cluster.close();
            this.executionContext.close();
        }
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    public boolean isPersisted() {
        return true;
    }

    public SQLDialect getSQLDialect() {
        return CasCQLDialect.INSTANCE;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getKeyspaces();
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getKeyspace(childName);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return CasKeyspace.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        DataType.Name type = DataType.Name.valueOf((String)typeName);
        return CasUtils.getDataKind(type);
    }

    public CasDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return this.typeMap.get(typeFullName);
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return new ArrayList<CasDataType>(this.typeMap.values());
    }

    public CasDataType getLocalDataType(String typeName) {
        return this.typeMap.get(typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        for (CasDataType dt : this.typeMap.values()) {
            if (dt.getTypeID() != typeID) continue;
            return dt;
        }
        return null;
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return DataType.Name.BOOLEAN.toString();
            }
            case NUMERIC: {
                return DataType.Name.INT.toString();
            }
            case DATETIME: {
                return DataType.Name.TIMESTAMP.toString();
            }
            case BINARY: {
                return DataType.Name.BLOB.toString();
            }
            case CONTENT: {
                return DataType.Name.BLOB.toString();
            }
            case STRUCT: {
                return DataType.Name.MAP.toString();
            }
            case ARRAY: {
                return DataType.Name.LIST.toString();
            }
            case OBJECT: {
                return DataType.Name.UDT.toString();
            }
        }
        return DataType.Name.ASCII.toString();
    }

    public synchronized CasTupleType getCachedTupleType(TupleType type) {
        CasTupleType res = this.tupleTypeCache.get(type);
        if (res == null) {
            res = new CasTupleType(this, type);
            this.tupleTypeCache.put(type, res);
        }
        return res;
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(Throwable error) {
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(DBRProgressMonitor monitor, DBCExecutionContext context, String query, Throwable error) {
        Matcher matcher;
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message) && (matcher = this.ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.line = Integer.parseInt(matcher.group(1)) - 1;
            pos.position = Integer.parseInt(matcher.group(2)) - 1;
            return new DBPErrorAssistant.ErrorPosition[]{pos};
        }
        return null;
    }
}

