/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.exec;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.dbeaver.ee.cassandra.exec.CasBaseStatement;
import com.dbeaver.ee.cassandra.exec.CasSession;
import java.util.concurrent.TimeUnit;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;

public class CasPreparedStatement
extends CasBaseStatement {
    private final PreparedStatement statement;
    private final BoundStatement boundStatement;

    public CasPreparedStatement(CasSession session, PreparedStatement statement) {
        super(session, statement.getQueryString());
        this.statement = statement;
        this.boundStatement = statement.bind();
        this.boundStatement.enableTracing();
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public BoundStatement getBoundStatement() {
        return this.boundStatement;
    }

    public boolean executeStatement() throws DBCException {
        QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        this.startBlock("Execute prepared statement");
        try {
            Session sessionImpl = this.session.getImpl();
            long timeoutMs = this.statementTimeout * 1000;
            if (timeoutMs > 0L) {
                this.boundStatement.setReadTimeoutMillis((int)timeoutMs);
            }
            this.resultSetFuture = sessionImpl.executeAsync((Statement)this.boundStatement);
            try {
                this.result = timeoutMs > 0L ? (ResultSet)this.resultSetFuture.get(timeoutMs, TimeUnit.SECONDS) : (ResultSet)this.resultSetFuture.get();
            }
            finally {
                this.resultSetFuture = null;
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.endBlock();
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
        }
    }

    @Override
    public Statement getStatementImpl() {
        return this.boundStatement;
    }
}

