/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.ForeignKeysCache;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSourceInfo;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericStructureAssistant;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTableType;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.IndexCache;
import org.jkiss.dbeaver.ext.generic.model.PrimaryKeysCache;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.time.ExtendedDateFormat;

public class GenericDataSource
extends JDBCDataSource
implements DBSObjectSelector,
DBPTermProvider,
IAdaptable,
GenericStructContainer {
    private static final Log log = Log.getLog(GenericDataSource.class);
    static boolean populateClientAppName = false;
    private final TableTypeCache tableTypeCache;
    private final JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> dataTypeCache;
    private List<GenericCatalog> catalogs;
    private List<GenericSchema> schemas;
    private final GenericMetaModel metaModel;
    private GenericObjectContainer structureContainer;
    private String queryGetActiveDB;
    private String querySetActiveDB;
    private String selectedEntityType;
    private String selectedEntityName;
    private boolean selectedEntityFromAPI;
    private String allObjectsPattern;
    private boolean supportsStructCache;
    private DBCQueryPlanner queryPlanner;
    private Format nativeFormatTimestamp;
    private Format nativeFormatTime;
    private Format nativeFormatDate;

    public GenericDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel, @NotNull SQLDialect dialect) throws DBException {
        super(monitor, container, dialect, false);
        this.metaModel = metaModel;
        DBPDriver driver = container.getDriver();
        this.dataTypeCache = metaModel.createDataTypeCache(this);
        this.tableTypeCache = new TableTypeCache();
        this.queryGetActiveDB = CommonUtils.toString((Object)driver.getDriverParameter("query-get-active-db"));
        this.querySetActiveDB = CommonUtils.toString((Object)driver.getDriverParameter("query-set-active-db"));
        this.selectedEntityType = CommonUtils.toString((Object)driver.getDriverParameter("active-entity-type"));
        if (CommonUtils.isEmpty((String)this.selectedEntityType)) {
            this.selectedEntityType = null;
        }
        this.allObjectsPattern = CommonUtils.toString((Object)driver.getDriverParameter("all-objects-pattern"));
        if (CommonUtils.isEmpty((String)this.allObjectsPattern)) {
            this.allObjectsPattern = "%";
        } else if ("null".equalsIgnoreCase(this.allObjectsPattern)) {
            this.allObjectsPattern = null;
        }
        this.nativeFormatTimestamp = this.makeNativeFormat("native-format-timestamp");
        this.nativeFormatTime = this.makeNativeFormat("native-format-time");
        this.nativeFormatDate = this.makeNativeFormat("native-format-date");
        this.initializeMainContext(monitor);
    }

    protected String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        String connectionURL = this.getContainer().getDriver().getDataSourceProvider().getConnectionURL(this.getContainer().getDriver(), connectionInfo);
        if (connectionInfo.getUrl() != null && !CommonUtils.equalObjects((Object)connectionURL, (Object)connectionInfo.getUrl())) {
            log.warn((Object)("Actual connection URL (" + connectionURL + ") differs from previously saved (" + connectionInfo.getUrl() + "). " + "Probably driver properties were changed. Please go to the connection '" + this.getContainer().getName() + "' editor."));
            connectionInfo.setUrl(connectionURL);
        }
        return connectionURL;
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBCException {
        Connection jdbcConnection;
        block8: {
            jdbcConnection = super.openConnection(monitor, purpose);
            if (populateClientAppName && !this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
                try {
                    ResultSet ciList = jdbcConnection.getMetaData().getClientInfoProperties();
                    if (ciList == null) break block8;
                    try {
                        while (ciList.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)ciList, (String)"NAME");
                            int maxLength = JDBCUtils.safeGetInt((ResultSet)ciList, (String)"MAX_LEN");
                            if (!"ApplicationName".equals(name)) continue;
                            String appName = DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (String)purpose);
                            if (maxLength > 0) {
                                appName = CommonUtils.truncateString((String)appName, (int)(maxLength <= 0 ? 48 : maxLength));
                            }
                            jdbcConnection.setClientInfo("ApplicationName", appName);
                            break;
                        }
                    }
                    finally {
                        ciList.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return jdbcConnection;
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, boolean setActiveObject) throws DBCException {
        if (setActiveObject) {
            this.setActiveEntityName(monitor, context, this.getDefaultObject());
        }
    }

    public String getAllObjectsPattern() {
        return this.allObjectsPattern;
    }

    @NotNull
    public GenericMetaModel getMetaModel() {
        return this.metaModel;
    }

    @Nullable
    public GenericMetaObject getMetaObject(String id) {
        return this.metaModel.getMetaObject(id);
    }

    protected DBPDataSourceInfo createDataSourceInfo(@NotNull JDBCDatabaseMetaData metaData) {
        Object supportsStructCacheParam;
        Object supportsSubqueries;
        Object supportsStoredCode;
        Object supportsIndexes;
        GenericDataSourceInfo info = new GenericDataSourceInfo(this.getContainer().getDriver(), metaData);
        JDBCSQLDialect dialect = (JDBCSQLDialect)this.getSQLDialect();
        Object supportsReferences = this.getContainer().getDriver().getDriverParameter("supports-references");
        if (supportsReferences != null) {
            info.setSupportsReferences(Boolean.valueOf(supportsReferences.toString()));
        }
        if ((supportsIndexes = this.getContainer().getDriver().getDriverParameter("supports-indexes")) != null) {
            info.setSupportsIndexes(Boolean.valueOf(supportsIndexes.toString()));
        }
        if ((supportsStoredCode = this.getContainer().getDriver().getDriverParameter("supports-stored-code")) != null) {
            info.setSupportsStoredCode(Boolean.valueOf(supportsStoredCode.toString()));
        }
        if ((supportsSubqueries = this.getContainer().getDriver().getDriverParameter("supports-subqueries")) != null) {
            dialect.setSupportsSubqueries(Boolean.valueOf(supportsSubqueries.toString()).booleanValue());
        }
        if ((supportsStructCacheParam = this.getContainer().getDriver().getDriverParameter("supports-struct-cache")) != null) {
            this.supportsStructCache = CommonUtils.toBoolean((Object)supportsStructCacheParam);
        }
        return info;
    }

    public void shutdown(DBRProgressMonitor monitor) {
        super.shutdown(monitor);
        String paramShutdown = CommonUtils.toString((Object)this.getContainer().getDriver().getDriverParameter("shutdown-url-param"));
        if (!CommonUtils.isEmpty((String)paramShutdown)) {
            monitor.subTask("Shutdown embedded database");
            try {
                Driver driver;
                Properties shutdownProps = new Properties();
                DBPConnectionConfiguration connectionInfo = this.getContainer().getActualConnectionConfiguration();
                if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
                    shutdownProps.put("user", this.getConnectionUserName(connectionInfo));
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
                    shutdownProps.put("password", this.getConnectionUserPassword(connectionInfo));
                }
                if ((driver = this.getDriverInstance((DBRProgressMonitor)new VoidProgressMonitor())) != null) {
                    driver.connect(String.valueOf(this.getContainer().getActualConnectionConfiguration().getUrl()) + paramShutdown, shutdownProps.isEmpty() ? null : shutdownProps);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Shutdown finished: :" + e.getMessage()));
            }
            monitor.worked(1);
        }
    }

    boolean supportsStructCache() {
        return this.supportsStructCache;
    }

    @Association
    public Collection<GenericTableType> getTableTypes(DBRProgressMonitor monitor) throws DBException {
        return this.tableTypeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<GenericCatalog> getCatalogs() {
        return this.catalogs;
    }

    public GenericCatalog getCatalog(String name) {
        return (GenericCatalog)DBUtils.findObject(this.getCatalogs(), (String)name);
    }

    @Association
    public Collection<GenericSchema> getSchemas() {
        return this.schemas;
    }

    public GenericSchema getSchema(String name) {
        return (GenericSchema)DBUtils.findObject(this.getSchemas(), (String)name);
    }

    @Override
    @NotNull
    public GenericDataSource getDataSource() {
        return this;
    }

    @Override
    public DBSObject getObject() {
        return this.getContainer();
    }

    @Override
    public GenericCatalog getCatalog() {
        return null;
    }

    @Override
    public GenericSchema getSchema() {
        return null;
    }

    @Override
    public TableCache getTableCache() {
        return this.structureContainer.getTableCache();
    }

    @Override
    public IndexCache getIndexCache() {
        return this.structureContainer.getIndexCache();
    }

    @Override
    public PrimaryKeysCache getPrimaryKeysCache() {
        return this.structureContainer.getPrimaryKeysCache();
    }

    @Override
    public ForeignKeysCache getForeignKeysCache() {
        return this.structureContainer.getForeignKeysCache();
    }

    public Collection<GenericTable> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getViews(monitor);
    }

    public Collection<GenericTable> getPhysicalTables(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getPhysicalTables(monitor);
    }

    public Collection<GenericTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getTables(monitor);
    }

    @Override
    public GenericTable getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getTable(monitor, name);
    }

    public Collection<GenericPackage> getPackages(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getPackages(monitor);
    }

    public Collection<GenericTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getIndexes(monitor);
    }

    public Collection<GenericProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getProcedures(monitor);
    }

    @Override
    public GenericProcedure getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getProcedure(monitor, uniqueName);
    }

    public Collection<GenericProcedure> getProcedures(DBRProgressMonitor monitor, String name) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getProcedures(monitor, name);
    }

    public Collection<GenericSequence> getSequences(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getSequences(monitor);
    }

    @Override
    public Collection<? extends GenericTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getTriggers(monitor);
    }

    @Override
    public Collection<? extends GenericTrigger> getTableTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getTableTriggers(monitor);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        Object omitCatalog = this.getContainer().getDriver().getDriverParameter("omit-catalog");
        Object omitTypeCache = this.getContainer().getDriver().getDriverParameter("omit-type-cache");
        if (omitTypeCache == null || !CommonUtils.toBoolean((Object)omitTypeCache)) {
            try {
                this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
            }
            catch (Exception e) {
                log.warn((Object)"Can't fetch database data types", (Throwable)e);
            }
        } else {
            this.dataTypeCache.fillStandardTypes((DBSObject)this);
        }
        try {
            Throwable e = null;
            Object var5_8 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read generic metadata");){
                JDBCDatabaseMetaData metaData = session.getMetaData();
                boolean catalogsFiltered = false;
                if (omitCatalog == null || !CommonUtils.toBoolean((Object)omitCatalog)) {
                    monitor.subTask("Extract catalogs");
                    monitor.worked(1);
                    GenericMetaObject catalogObject = this.getMetaObject("catalog");
                    DBSObjectFilter catalogFilters = this.getContainer().getObjectFilter(GenericCatalog.class, null, false);
                    ArrayList<String> catalogNames = new ArrayList<String>();
                    try {
                        Throwable throwable = null;
                        Iterator iterator = null;
                        try (JDBCResultSet dbResult = metaData.getCatalogs();){
                            int totalCatalogs = 0;
                            while (dbResult.next()) {
                                String catalogName = GenericUtils.safeGetString(catalogObject, (ResultSet)dbResult, "TABLE_CAT");
                                if (CommonUtils.isEmpty((String)catalogName) && CommonUtils.isEmpty((String)(catalogName = GenericUtils.safeGetStringTrimmed(catalogObject, (ResultSet)dbResult, "TABLE_QUALIFIER")))) continue;
                                ++totalCatalogs;
                                if (catalogFilters == null || catalogFilters.matches(catalogName)) {
                                    catalogNames.add(catalogName);
                                    monitor.subTask("Extract catalogs - " + catalogName);
                                } else {
                                    catalogsFiltered = true;
                                }
                                if (monitor.isCanceled()) break;
                            }
                            if (totalCatalogs == 1) {
                                catalogNames.clear();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (UnsupportedOperationException | SQLFeatureNotSupportedException e2) {
                        log.debug((Object)e2);
                    }
                    catch (SQLException e3) {
                        log.warn((Object)"Can't read catalog list", (Throwable)e3);
                    }
                    if (!catalogNames.isEmpty() || catalogsFiltered) {
                        this.catalogs = new ArrayList<GenericCatalog>();
                        for (String catalogName : catalogNames) {
                            GenericCatalog catalog = this.metaModel.createCatalogImpl(this, catalogName);
                            this.catalogs.add(catalog);
                        }
                    }
                }
                if (CommonUtils.isEmpty(this.catalogs) && !catalogsFiltered) {
                    monitor.subTask("Extract schemas");
                    monitor.worked(1);
                    List<GenericSchema> tmpSchemas = this.metaModel.loadSchemas(session, this, null);
                    if (tmpSchemas != null) {
                        this.schemas = tmpSchemas;
                    }
                    if (CommonUtils.isEmpty(this.schemas)) {
                        this.structureContainer = new DataSourceObjectContainer();
                    }
                }
                this.determineSelectedEntity(session);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (SQLException ex) {
            throw new DBException("Error reading metadata", (Throwable)ex, (DBPDataSource)this);
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.selectedEntityName = null;
        this.structureContainer = null;
        this.tableTypeCache.clearCache();
        this.catalogs = null;
        this.schemas = null;
        this.initialize(monitor);
        return this;
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        DBCQueryTransformer transformer;
        if (this.metaModel instanceof DBCQueryTransformProvider && (transformer = ((DBCQueryTransformProvider)this.metaModel).createQueryTransformer(type)) != null) {
            return transformer;
        }
        return super.createQueryTransformer(type);
    }

    GenericTable findTable(@NotNull DBRProgressMonitor monitor, String catalogName, String schemaName, String tableName) throws DBException {
        GenericObjectContainer container = null;
        if (!CommonUtils.isEmpty((String)catalogName) && !CommonUtils.isEmpty(this.catalogs) && (container = this.getCatalog(catalogName)) == null) {
            log.error((Object)("Catalog " + catalogName + " not found"));
            return null;
        }
        if (!CommonUtils.isEmpty((String)schemaName) && (container = container != null ? ((GenericCatalog)container).getSchema(monitor, schemaName) : (!CommonUtils.isEmpty(this.schemas) ? this.getSchema(schemaName) : this.structureContainer)) == null) {
            log.debug((Object)("Schema '" + schemaName + "' not found"));
            return null;
        }
        if (container == null) {
            container = this.structureContainer;
        }
        return container.getTable(monitor, tableName);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!CommonUtils.isEmpty(this.getCatalogs())) {
            return this.getCatalogs();
        }
        if (!CommonUtils.isEmpty(this.getSchemas())) {
            return this.getSchemas();
        }
        if (this.structureContainer != null) {
            return this.structureContainer.getTables(monitor);
        }
        return null;
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        if (!CommonUtils.isEmpty(this.getCatalogs())) {
            return this.getCatalog(childName);
        }
        if (!CommonUtils.isEmpty(this.getSchemas())) {
            return this.getSchema(childName);
        }
        if (this.structureContainer != null) {
            return this.structureContainer.getChild(monitor, childName);
        }
        return null;
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!CommonUtils.isEmpty(this.catalogs)) {
            return GenericCatalog.class;
        }
        if (!CommonUtils.isEmpty(this.schemas)) {
            return GenericSchema.class;
        }
        return GenericTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        if (!CommonUtils.isEmpty(this.catalogs)) {
            for (GenericCatalog catalog : this.catalogs) {
                catalog.cacheStructure(monitor, scope);
            }
        } else if (!CommonUtils.isEmpty(this.schemas)) {
            for (GenericSchema schema : this.schemas) {
                schema.cacheStructure(monitor, scope);
            }
        } else if (this.structureContainer != null) {
            this.structureContainer.cacheStructure(monitor, scope);
        }
    }

    private boolean isChild(DBSObject object) throws DBException {
        if (object instanceof GenericCatalog) {
            return !CommonUtils.isEmpty(this.catalogs) && this.catalogs.contains(GenericCatalog.class.cast(object));
        }
        if (object instanceof GenericSchema) {
            return !CommonUtils.isEmpty(this.schemas) && this.schemas.contains(GenericSchema.class.cast(object));
        }
        return false;
    }

    public boolean supportsDefaultChange() {
        if (this.selectedEntityFromAPI) {
            return true;
        }
        if (!CommonUtils.isEmpty((String)this.querySetActiveDB)) {
            if (CommonUtils.isEmpty((String)this.selectedEntityType)) {
                return !CommonUtils.isEmpty(this.getCatalogs()) || !CommonUtils.isEmpty(this.getSchemas());
            }
            if (!CommonUtils.isEmpty(this.getCatalogs())) {
                return "catalog".equals(this.selectedEntityType);
            }
            if (!CommonUtils.isEmpty(this.getSchemas())) {
                return "schema".equals(this.selectedEntityType);
            }
        }
        return false;
    }

    public DBSObject getDefaultObject() {
        if (!CommonUtils.isEmpty((String)this.selectedEntityName)) {
            if (!CommonUtils.isEmpty(this.catalogs)) {
                if (this.selectedEntityType == null || this.selectedEntityType.equals("catalog")) {
                    return this.getCatalog(this.selectedEntityName);
                }
            } else if (!CommonUtils.isEmpty(this.schemas) && (this.selectedEntityType == null || this.selectedEntityType.equals("schema"))) {
                return this.getSchema(this.selectedEntityName);
            }
        }
        return null;
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        DBSObject oldSelectedEntity = this.getDefaultObject();
        if (!this.isChild(object)) {
            throw new DBException("Bad child object specified as active: " + object);
        }
        JDBCExecutionContext[] jDBCExecutionContextArray = this.getAllContexts();
        int n = jDBCExecutionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCExecutionContext context = jDBCExecutionContextArray[n2];
            this.setActiveEntityName(monitor, context, object);
            ++n2;
        }
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        DBSObject newDefaultObject;
        String oldEntityName = this.selectedEntityName;
        DBSObject oldDefaultObject = this.getDefaultObject();
        this.determineSelectedEntity((JDBCSession)session);
        if (!CommonUtils.equalObjects((Object)oldEntityName, (Object)this.selectedEntityName) && (newDefaultObject = this.getDefaultObject()) != null) {
            if (oldDefaultObject != null) {
                DBUtils.fireObjectSelect((DBSObject)oldDefaultObject, (boolean)false);
            }
            DBUtils.fireObjectSelect((DBSObject)newDefaultObject, (boolean)true);
            return true;
        }
        return false;
    }

    String getSelectedEntityType() {
        return this.selectedEntityType;
    }

    String getSelectedEntityName() {
        return this.selectedEntityName;
    }

    private void determineSelectedEntity(JDBCSession session) {
        this.selectedEntityName = null;
        if (CommonUtils.isEmpty((String)this.queryGetActiveDB)) {
            try {
                this.selectedEntityName = session.getCatalog();
                if (this.selectedEntityType == null && !CommonUtils.isEmpty((String)this.selectedEntityName)) {
                    this.selectedEntityType = "catalog";
                    this.selectedEntityFromAPI = true;
                }
            }
            catch (SQLException e) {
                log.debug((Object)e);
            }
            if (CommonUtils.isEmpty((String)this.selectedEntityName)) {
                try {
                    this.selectedEntityName = session.getSchema();
                    if (this.selectedEntityType == null && !CommonUtils.isEmpty((String)this.selectedEntityName)) {
                        this.selectedEntityType = "schema";
                        this.selectedEntityFromAPI = true;
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
            }
            if (CommonUtils.isEmpty((String)this.selectedEntityName)) {
                if (!CommonUtils.isEmpty(this.catalogs) && this.catalogs.size() == 1) {
                    this.selectedEntityType = "catalog";
                    this.selectedEntityName = this.catalogs.get(0).getName();
                } else if (!CommonUtils.isEmpty(this.schemas) && this.schemas.size() == 1) {
                    this.selectedEntityType = "schema";
                    this.selectedEntityName = this.schemas.get(0).getName();
                }
            }
        } else {
            try {
                Throwable e = null;
                Object var3_7 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(this.queryGetActiveDB);){
                    Throwable throwable = null;
                    Object var6_12 = null;
                    try (JDBCResultSet resultSet = dbStat.executeQuery();){
                        int divPos;
                        resultSet.next();
                        this.selectedEntityName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (int)1);
                        if (!CommonUtils.isEmpty((String)this.selectedEntityName) && (divPos = this.selectedEntityName.lastIndexOf(44)) != -1) {
                            this.selectedEntityName = this.selectedEntityName.substring(divPos + 1);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (SQLException e) {
                log.debug((Object)e);
                this.selectedEntityName = null;
            }
        }
    }

    void setActiveEntityName(DBRProgressMonitor monitor, JDBCExecutionContext context, DBSObject entity) throws DBCException {
        block32: {
            if (entity == null) {
                log.debug((Object)"Null current entity");
                return;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");){
                    block33: {
                        if (!this.selectedEntityFromAPI) break block33;
                        switch (this.selectedEntityType) {
                            case "catalog": {
                                session.setCatalog(entity.getName());
                                break block32;
                            }
                            case "schema": {
                                session.setSchema(entity.getName());
                                break block32;
                            }
                            default: {
                                throw new DBCException("No API to change active entity if type '" + this.selectedEntityType + "'");
                            }
                        }
                    }
                    if (CommonUtils.isEmpty((String)this.querySetActiveDB) || !(entity instanceof GenericObjectContainer)) {
                        throw new DBCException("Active database can't be changed for this kind of datasource!");
                    }
                    String changeQuery = this.querySetActiveDB.replaceFirst("\\?", Matcher.quoteReplacement(entity.getName()));
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                        dbStat.execute();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException(e, context.getDataSource());
            }
        }
        this.selectedEntityName = entity.getName();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new GenericStructureAssistant(this));
        }
        if (adapter == DBCQueryPlanner.class) {
            if (this.queryPlanner == null) {
                this.queryPlanner = this.metaModel.getQueryPlanner(this);
            }
            return adapter.cast(this.queryPlanner);
        }
        if (adapter == DBDValueHandlerProvider.class && this.metaModel instanceof DBDValueHandlerProvider) {
            return adapter.cast(this.metaModel);
        }
        return (T)super.getAdapter(adapter);
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        String term = null;
        if ("catalog".equals(objectType)) {
            term = this.getInfo().getCatalogTerm();
        } else if ("schema".equals(objectType)) {
            term = this.getInfo().getSchemaTerm();
        } else if ("procedure".equals(objectType)) {
            term = this.getInfo().getProcedureTerm();
        }
        if (term != null && multiple) {
            term = String.valueOf(term) + "s";
        }
        return term;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        DBPErrorAssistant.ErrorPosition[] errorPositionArray;
        DBPErrorAssistant.ErrorPosition position = this.metaModel.getErrorPosition(error);
        if (position == null) {
            errorPositionArray = null;
        } else {
            DBPErrorAssistant.ErrorPosition[] errorPositionArray2 = new DBPErrorAssistant.ErrorPosition[1];
            errorPositionArray = errorPositionArray2;
            errorPositionArray2[0] = position;
        }
        return errorPositionArray;
    }

    protected JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> getDataTypeCache() {
        return this.dataTypeCache;
    }

    @Override
    public Collection<? extends DBSDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    public DBSDataType getLocalDataType(String typeName) {
        return (DBSDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        return this.dataTypeCache.getCachedObject(typeID);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        DBSDataType dataType = this.getLocalDataType(typeName);
        if (dataType != null) {
            return super.resolveDataKind(dataType.getTypeName(), dataType.getTypeID());
        }
        return super.resolveDataKind(typeName, valueType);
    }

    public Format getNativeFormatTimestamp() {
        return this.nativeFormatTimestamp;
    }

    public Format getNativeFormatTime() {
        return this.nativeFormatTime;
    }

    public Format getNativeFormatDate() {
        return this.nativeFormatDate;
    }

    private Format makeNativeFormat(String paramName) {
        Object param = this.getContainer().getDriver().getDriverParameter(paramName);
        if (param == null) {
            return null;
        }
        try {
            return new ExtendedDateFormat(CommonUtils.toString((Object)param));
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    private class DataSourceObjectContainer
    extends GenericObjectContainer {
        private DataSourceObjectContainer() {
            super(GenericDataSource.this);
        }

        @Override
        public GenericCatalog getCatalog() {
            return null;
        }

        @Override
        public GenericSchema getSchema() {
            return null;
        }

        @Override
        public DBSObject getObject() {
            return GenericDataSource.this.getContainer();
        }

        public Class<? extends DBSEntity> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
            return GenericTable.class;
        }

        @NotNull
        public String getName() {
            return GenericDataSource.this.getName();
        }

        @Nullable
        public String getDescription() {
            return GenericDataSource.this.getDescription();
        }

        public DBSObject getParentObject() {
            return GenericDataSource.this.getParentObject();
        }
    }

    private class TableTypeCache
    extends JDBCObjectCache<GenericDataSource, GenericTableType> {
        private TableTypeCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericDataSource owner) throws SQLException {
            return session.getMetaData().getTableTypes().getSourceStatement();
        }

        protected GenericTableType fetchObject(@NotNull JDBCSession session, @NotNull GenericDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new GenericTableType(GenericDataSource.this, GenericUtils.safeGetString(GenericDataSource.this.getMetaObject("table-type"), (ResultSet)resultSet, "TABLE_TYPE"));
        }
    }
}

