/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.part;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.ext.erd.ERDMessages;
import org.jkiss.dbeaver.ext.erd.command.NoteSetTextCommand;
import org.jkiss.dbeaver.ext.erd.figures.NoteFigure;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.NodePart;
import org.jkiss.dbeaver.ext.erd.policy.NoteEditPolicy;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;

public class NotePart
extends NodePart {
    public ERDNote getNote() {
        return (ERDNote)this.getModel();
    }

    protected void createEditPolicies() {
        boolean editEnabled = this.isEditEnabled();
        if (editEnabled) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NoteEditPolicy());
        }
    }

    public void performRequest(Request request) {
        String newText;
        if (request.getType() == "open" && (newText = EditTextDialog.editText((Shell)this.getViewer().getControl().getShell(), (String)ERDMessages.part_note_title, (String)((String)this.getNote().getObject()))) != null) {
            NoteSetTextCommand command = new NoteSetTextCommand(this.getNote(), (NoteFigure)this.getFigure(), newText);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)command);
        }
    }

    public String toString() {
        return (String)this.getNote().getObject();
    }

    public void handleNameChange(String value) {
        NoteFigure noteFigure = (NoteFigure)this.getFigure();
        noteFigure.setVisible(false);
        this.refreshVisuals();
    }

    public void revertNameChange() {
        NoteFigure noteFigure = (NoteFigure)this.getFigure();
        noteFigure.setText((String)this.getNote().getObject());
        noteFigure.setVisible(true);
        this.refreshVisuals();
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        NoteFigure noteFigure = (NoteFigure)this.getFigure();
        noteFigure.setText((String)this.getNote().getObject());
        noteFigure.setVisible(true);
        this.refreshVisuals();
    }

    protected IFigure createFigure() {
        NoteFigure noteFigure = new NoteFigure(this.getNote());
        EntityDiagram.NodeVisualInfo visualInfo = ((DiagramPart)this.getParent()).getDiagram().getVisualInfo(this.getNote(), true);
        Rectangle bounds = visualInfo.initBounds;
        if (bounds != null) {
            noteFigure.setBounds(bounds);
            noteFigure.setPreferredSize(bounds.getSize());
        } else if (noteFigure.getSize().isEmpty()) {
            noteFigure.setPreferredSize(new Dimension(100, 50));
        }
        this.customBackground = visualInfo.bgColor;
        if (this.customBackground != null) {
            noteFigure.setBackgroundColor(this.customBackground);
        }
        return noteFigure;
    }

    protected void refreshVisuals() {
        NoteFigure notefigure = (NoteFigure)this.getFigure();
        Point location = notefigure.getLocation();
        DiagramPart parent = (DiagramPart)this.getParent();
        Rectangle constraint = new Rectangle(location.x, location.y, -1, -1);
        parent.setLayoutConstraint((EditPart)this, (IFigure)notefigure, constraint);
    }

    public void setSelected(int value) {
        super.setSelected(value);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public Object getAdapter(Class key) {
        if (key == DBPNamedObject.class) {
            return this.getNote();
        }
        return super.getAdapter(key);
    }
}

