/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.part;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.jkiss.dbeaver.ext.erd.ERDMessages;
import org.jkiss.dbeaver.ext.erd.directedit.ColumnNameTypeCellEditorValidator;
import org.jkiss.dbeaver.ext.erd.directedit.ExtendedDirectEditManager;
import org.jkiss.dbeaver.ext.erd.directedit.LabelCellEditorLocator;
import org.jkiss.dbeaver.ext.erd.directedit.ValidationMessageHandler;
import org.jkiss.dbeaver.ext.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ext.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ext.erd.figures.AttributeItemFigure;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.PropertyAwarePart;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;

public class AttributePart
extends PropertyAwarePart {
    protected DirectEditManager manager;

    public boolean isSelectable() {
        return true;
    }

    protected AttributeItemFigure createFigure() {
        ERDEntityAttribute column = (ERDEntityAttribute)this.getModel();
        AttributeItemFigure attributeFigure = new AttributeItemFigure(column);
        DiagramPart diagramPart = (DiagramPart)this.getParent().getParent();
        boolean showNullability = diagramPart.getDiagram().hasAttributeStyle(ERDViewStyle.NULLABILITY);
        Font columnFont = diagramPart.getNormalFont();
        Color columnColor = diagramPart.getContentPane().getForegroundColor();
        if (column.isInPrimaryKey()) {
            columnFont = diagramPart.getBoldFont();
            if (showNullability && !((DBSEntityAttribute)column.getObject()).isRequired()) {
                columnFont = diagramPart.getBoldItalicFont();
            }
        } else if (showNullability && !((DBSEntityAttribute)column.getObject()).isRequired()) {
            columnFont = diagramPart.getItalicFont();
        }
        column.isInForeignKey();
        attributeFigure.setFont(columnFont);
        attributeFigure.setForegroundColor(columnColor);
        return attributeFigure;
    }

    public AttributeItemFigure getFigure() {
        return (AttributeItemFigure)super.getFigure();
    }

    protected void createEditPolicies() {
    }

    public void performRequest(Request request) {
        if (request.getType() != "direct edit" && request.getType() == "open") {
            this.getAttribute().openEditor();
        }
    }

    private boolean directEditHitTest(Point requestLoc) {
        AttributeItemFigure figure = this.getFigure();
        figure.translateToRelative((Translatable)requestLoc);
        return figure.containsPoint(requestLoc);
    }

    protected void performDirectEdit() {
        if (this.manager == null) {
            ERDGraphicalViewer viewer = (ERDGraphicalViewer)this.getViewer();
            ValidationMessageHandler handler = viewer.getValidationHandler();
            AttributeItemFigure l = this.getFigure();
            ColumnNameTypeCellEditorValidator columnNameTypeCellEditorValidator = new ColumnNameTypeCellEditorValidator(handler);
            this.manager = new ExtendedDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator(l), l, columnNameTypeCellEditorValidator);
        }
        this.manager.show();
    }

    public void setSelected(int value) {
        super.setSelected(value);
        AttributeItemFigure columnLabel = this.getFigure();
        if (value != 0) {
            columnLabel.setSelected(true);
        } else {
            columnLabel.setSelected(false);
        }
        columnLabel.repaint();
    }

    public void handleNameChange(String textValue) {
        AttributeItemFigure label = this.getFigure();
        label.setVisible(false);
        this.setSelected(0);
        label.revalidate();
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        AttributeItemFigure label = this.getFigure();
        label.setText(this.getAttribute().getLabelText());
        this.setSelected(2);
        label.revalidate();
    }

    public void revertNameChange(String oldValue) {
        AttributeItemFigure label = this.getFigure();
        label.setVisible(true);
        this.setSelected(2);
        label.revalidate();
    }

    protected void refreshVisuals() {
        ERDEntityAttribute column = (ERDEntityAttribute)this.getModel();
        this.getFigure().setText(column.getLabelText());
    }

    public ERDEntityAttribute getAttribute() {
        return (ERDEntityAttribute)this.getModel();
    }

    public String toString() {
        return String.valueOf(ERDMessages.column_) + this.getAttribute().getLabelText();
    }
}

