/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class ERDEntity
extends ERDObject<DBSEntity> {
    private static final Log log = Log.getLog(ERDEntity.class);
    private List<ERDEntityAttribute> columns;
    private List<ERDAssociation> primaryKeyRelationships;
    private List<ERDAssociation> foreignKeyRelationships;
    private List<DBSEntityAssociation> unresolvedKeys;
    private boolean primary = false;

    public ERDEntity(DBSEntity dbsTable) {
        super(dbsTable);
    }

    public void addColumn(ERDEntityAttribute column, boolean reflect) {
        if (this.columns == null) {
            this.columns = new ArrayList<ERDEntityAttribute>();
        }
        if (this.columns.contains(column)) {
            throw new IllegalArgumentException("Column already present");
        }
        this.columns.add(column);
        if (reflect) {
            this.firePropertyChange("CHILD", null, column);
        }
    }

    public void removeColumn(ERDEntityAttribute column, boolean reflect) {
        this.columns.remove(column);
        if (reflect) {
            this.firePropertyChange("CHILD", column, null);
        }
    }

    public void switchColumn(ERDEntityAttribute column, int index, boolean reflect) {
        this.columns.remove(column);
        this.columns.add(index, column);
        if (reflect) {
            this.firePropertyChange("REORDER", this, column);
        }
    }

    public void addForeignKeyRelationship(ERDAssociation rel, boolean reflect) {
        if (this.foreignKeyRelationships == null) {
            this.foreignKeyRelationships = new ArrayList<ERDAssociation>();
        }
        this.foreignKeyRelationships.add(rel);
        if (reflect) {
            this.firePropertyChange("OUTPUT", null, rel);
        }
    }

    public void addPrimaryKeyRelationship(ERDAssociation table, boolean reflect) {
        if (this.primaryKeyRelationships == null) {
            this.primaryKeyRelationships = new ArrayList<ERDAssociation>();
        }
        this.primaryKeyRelationships.add(table);
        if (reflect) {
            this.firePropertyChange("INPUT", null, table);
        }
    }

    public void removeForeignKeyRelationship(ERDAssociation table, boolean reflect) {
        this.foreignKeyRelationships.remove(table);
        if (reflect) {
            this.firePropertyChange("OUTPUT", table, null);
        }
    }

    public void removePrimaryKeyRelationship(ERDAssociation table, boolean reflect) {
        this.primaryKeyRelationships.remove(table);
        if (reflect) {
            this.firePropertyChange("INPUT", table, null);
        }
    }

    public List<ERDEntityAttribute> getColumns() {
        return CommonUtils.safeList(this.columns);
    }

    public List<ERDAssociation> getForeignKeyRelationships() {
        return CommonUtils.safeList(this.foreignKeyRelationships);
    }

    public List<ERDAssociation> getPrimaryKeyRelationships() {
        return CommonUtils.safeList(this.primaryKeyRelationships);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean hasSelfLinks() {
        if (this.foreignKeyRelationships != null) {
            for (ERDAssociation association : this.foreignKeyRelationships) {
                if (association.getPrimaryKeyEntity() != this) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return ((DBSEntity)this.object).getName();
    }

    public int hashCode() {
        return ((DBSEntity)this.object).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ERDEntity)) {
            return false;
        }
        return ((DBSEntity)this.object).equals(((ERDEntity)o).object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ERDEntity fromObject(DBRProgressMonitor monitor, EntityDiagram diagram, DBSEntity entity) {
        ERDEntity erdEntity = new ERDEntity(entity);
        ERDAttributeVisibility attributeVisibility = diagram.getAttributeVisibility();
        if (attributeVisibility == ERDAttributeVisibility.NONE) return erdEntity;
        HashSet<? extends DBSEntityAttribute> keyColumns = null;
        if (attributeVisibility == ERDAttributeVisibility.KEYS) {
            keyColumns = new HashSet<DBSEntityAttribute>();
            try {
                for (DBSEntityAssociation assoc : CommonUtils.safeCollection((Collection)entity.getAssociations(monitor))) {
                    if (!(assoc instanceof DBSEntityReferrer)) continue;
                    keyColumns.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)assoc)));
                }
                for (DBSEntityConstraint constraint : CommonUtils.safeCollection((Collection)entity.getConstraints(monitor))) {
                    if (!(constraint instanceof DBSEntityReferrer)) continue;
                    keyColumns.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)constraint)));
                }
            }
            catch (DBException e) {
                log.warn((Object)e);
            }
        }
        Collection<? extends DBSEntityAttribute> idColumns = null;
        try {
            idColumns = ERDEntity.getBestTableIdentifier(monitor, entity);
            if (keyColumns != null) {
                keyColumns.addAll(idColumns);
            }
        }
        catch (DBException e) {
            log.error((Object)"Error reading table identifier", (Throwable)e);
        }
        try {
            DBSObjectFilter columnFilter = entity.getDataSource().getContainer().getObjectFilter(DBSEntityAttribute.class, (DBSObject)entity, false);
            Collection attributes = entity.getAttributes(monitor);
            if (CommonUtils.isEmpty((Collection)attributes)) return erdEntity;
            block12: for (DBSEntityAttribute attribute : attributes) {
                if (attribute instanceof DBSEntityAssociation || DBUtils.isHiddenObject((Object)attribute) || columnFilter != null && !columnFilter.matches(attribute.getName())) continue;
                switch (attributeVisibility) {
                    case PRIMARY: {
                        if (idColumns != null && idColumns.contains(attribute)) break;
                        continue block12;
                    }
                    case KEYS: {
                        if (!keyColumns.contains(attribute)) continue block12;
                    }
                }
                ERDEntityAttribute c1 = new ERDEntityAttribute(diagram, attribute, idColumns != null && idColumns.contains(attribute));
                erdEntity.addColumn(c1, false);
            }
            return erdEntity;
        }
        catch (DBException e) {
            log.debug((Object)("Can't load table '" + entity.getName() + "'columns"), (Throwable)e);
        }
        return erdEntity;
    }

    @NotNull
    public static Collection<? extends DBSEntityAttribute> getBestTableIdentifier(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        if (entity instanceof DBSTable && ((DBSTable)entity).isView()) {
            return Collections.emptyList();
        }
        if (CommonUtils.isEmpty((Collection)entity.getAttributes(monitor))) {
            return Collections.emptyList();
        }
        DBSEntityConstraint uniqueId = null;
        for (DBSEntityConstraint id : CommonUtils.safeCollection((Collection)entity.getConstraints(monitor))) {
            if (id instanceof DBSEntityReferrer && id.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                return DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)id));
            }
            if (id.getConstraintType().isUnique()) {
                uniqueId = id;
                continue;
            }
            if (!(id instanceof DBSTableIndex) || !((DBSTableIndex)id).isUnique()) continue;
            uniqueId = id;
        }
        if (uniqueId instanceof DBSEntityReferrer) {
            return DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)uniqueId));
        }
        if (entity instanceof DBSTable) {
            try {
                Collection indexes = ((DBSTable)entity).getIndexes(monitor);
                if (!CommonUtils.isEmpty((Collection)indexes)) {
                    for (DBSTableIndex index : indexes) {
                        if (!DBUtils.isIdentifierIndex((DBRProgressMonitor)monitor, (DBSTableIndex)index)) continue;
                        return DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)index);
                    }
                }
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
        return Collections.emptyList();
    }

    public void addRelations(DBRProgressMonitor monitor, Map<DBSEntity, ERDEntity> tableMap, boolean reflect) {
        try {
            HashSet fkColumns = new HashSet();
            Collection fks = ((DBSEntity)this.getObject()).getAssociations(monitor);
            if (fks != null) {
                for (DBSEntityAssociation fk : fks) {
                    ERDEntity entity2;
                    if (fk instanceof DBSEntityReferrer) {
                        fkColumns.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)fk)));
                    }
                    if ((entity2 = tableMap.get(fk.getAssociatedEntity())) == null) {
                        if (this.unresolvedKeys == null) {
                            this.unresolvedKeys = new ArrayList<DBSEntityAssociation>();
                        }
                        this.unresolvedKeys.add(fk);
                        continue;
                    }
                    new ERDAssociation(fk, entity2, this, reflect);
                }
            }
            for (ERDEntityAttribute column : this.getColumns()) {
                if (!fkColumns.contains(column.getObject())) continue;
                column.setInForeignKey(true);
            }
        }
        catch (DBException e) {
            log.warn((Object)("Can't load table '" + ((DBSEntity)this.getObject()).getName() + "' foreign keys"), (Throwable)e);
        }
    }

    public void resolveRelations(Map<DBSEntity, ERDEntity> tableMap, boolean reflect) {
        if (CommonUtils.isEmpty(this.unresolvedKeys)) {
            return;
        }
        Iterator<DBSEntityAssociation> iter = this.unresolvedKeys.iterator();
        while (iter.hasNext()) {
            ERDEntity refEntity;
            DBSEntityAssociation fk = iter.next();
            if (fk.getReferencedConstraint() == null || (refEntity = tableMap.get(fk.getReferencedConstraint().getParentObject())) == null) continue;
            new ERDAssociation(fk, refEntity, this, reflect);
            iter.remove();
        }
    }

    @NotNull
    public String getName() {
        return ((DBSEntity)this.getObject()).getName();
    }
}

