/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Image;
import org.jkiss.dbeaver.ext.erd.figures.AttributeItemFigure;
import org.jkiss.dbeaver.ext.erd.figures.AttributeListFigure;
import org.jkiss.dbeaver.ext.erd.figures.EditableLabel;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class EntityFigure
extends Figure {
    private final ERDEntity entity;
    private AttributeListFigure keyFigure;
    private AttributeListFigure attributeFigure;
    private EditableLabel nameLabel;

    public EntityFigure(ERDEntity entity, boolean useFQN) {
        this.entity = entity;
        Image tableImage = DBeaverIcons.getImage((DBPImage)((DBSEntity)entity.getObject()).getEntityType().getIcon());
        this.keyFigure = new AttributeListFigure(entity, true);
        this.attributeFigure = new AttributeListFigure(entity, false);
        this.nameLabel = new EditableLabel(useFQN ? DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entity.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DDL) : ((DBSEntity)entity.getObject()).getName());
        if (tableImage != null) {
            this.nameLabel.setIcon(tableImage);
        }
        ToolbarLayout layout = new ToolbarLayout();
        layout.setHorizontal(false);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new LineBorder(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.entity.name.foreground"), 1));
        this.setOpaque(true);
        this.add((IFigure)this.nameLabel);
        this.add((IFigure)this.keyFigure);
        this.add((IFigure)this.attributeFigure);
        Label toolTip = new Label(DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entity.getObject()), (DBPEvaluationContext)DBPEvaluationContext.UI));
        toolTip.setIcon(tableImage);
        this.setToolTip((IFigure)toolTip);
        this.setColors();
    }

    private void setColors() {
        ColorRegistry colorRegistry = UIUtils.getColorRegistry();
        if (this.entity.isPrimary()) {
            this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.primary.background"));
        } else if (((DBSEntity)this.entity.getObject()).getEntityType() == DBSEntityType.ASSOCIATION) {
            this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.association.background"));
        } else {
            this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.regular.background"));
        }
        this.setForegroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.name.foreground"));
        this.nameLabel.setForegroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.name.foreground"));
    }

    public void setSelected(boolean isSelected) {
        LineBorder lineBorder = (LineBorder)this.getBorder();
        if (isSelected) {
            lineBorder.setWidth(2);
        } else {
            lineBorder.setWidth(1);
        }
    }

    public EditableLabel getNameLabel() {
        return this.nameLabel;
    }

    public AttributeListFigure getKeyFigure() {
        return this.keyFigure;
    }

    public AttributeListFigure getColumnsFigure() {
        return this.attributeFigure;
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure instanceof AttributeItemFigure) {
            ColorRegistry colorRegistry = UIUtils.getColorRegistry();
            figure.setForegroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.attributes.foreground"));
            figure.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.attributes.background"));
            if (((AttributeItemFigure)figure).getAttribute().isInPrimaryKey()) {
                this.keyFigure.add(figure, constraint, -1);
            } else {
                this.attributeFigure.add(figure, constraint, -1);
            }
        } else {
            super.add(figure, constraint, index);
        }
    }
}

