/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.vertica.model.VerticaNode;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSQLDialect;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class VerticaDataSource
extends GenericDataSource {
    private NodeCache nodeCache = new NodeCache();

    public VerticaDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new VerticaSQLDialect());
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        int divPos = typeName.indexOf(40);
        if (divPos != -1) {
            typeName = typeName.substring(0, divPos);
        }
        switch (typeName = typeName.trim().toLowerCase(Locale.ENGLISH)) {
            case "binary": 
            case "varbinary": 
            case "raw": 
            case "bytea": 
            case "long varbinary": {
                return DBPDataKind.BINARY;
            }
            case "boolean": {
                return DBPDataKind.BOOLEAN;
            }
            case "char": 
            case "varchar": 
            case "long varchar": {
                return DBPDataKind.STRING;
            }
            case "interval day": 
            case "time with timezone": 
            case "timetz": 
            case "smalldatetime": 
            case "timestamp with timezone": 
            case "date": 
            case "time": 
            case "timestamp": 
            case "interval": 
            case "timestamptz": 
            case "datetime": {
                return DBPDataKind.DATETIME;
            }
            case "numeric": 
            case "bigint": 
            case "tinyint": 
            case "float8": 
            case "number": 
            case "double precision": 
            case "smallint": 
            case "int": 
            case "int8": 
            case "real": 
            case "float": 
            case "money": 
            case "decimal": 
            case "integer": {
                return DBPDataKind.NUMERIC;
            }
        }
        return DBPDataKind.OBJECT;
    }

    @Association
    public Collection<VerticaNode> getClusterNodes(DBRProgressMonitor monitor) throws DBException {
        return this.nodeCache.getAllObjects(monitor, (DBSObject)this);
    }

    class NodeCache
    extends JDBCObjectCache<VerticaDataSource, VerticaNode> {
        NodeCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull VerticaDataSource mySQLTable) throws SQLException {
            return session.prepareStatement("SELECT * FROM v_catalog.nodes ORDER BY nodE_name");
        }

        protected VerticaNode fetchObject(@NotNull JDBCSession session, @NotNull VerticaDataSource dataSource, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new VerticaNode(dataSource, dbResult);
        }
    }
}

