/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.RelopExpression;

class BetweenExpression
extends LogicalExpression {
    Expression obj;
    Expression left;
    Expression right;

    public BetweenExpression(Expression obj, Expression left, Expression right) {
        this.obj = obj;
        this.left = left;
        this.right = right;
    }

    @Override
    public Boolean isTrue(Map<String, Object> env) throws SQLException {
        Comparable leftValue = (Comparable)this.left.eval(env);
        Comparable rightValue = (Comparable)this.right.eval(env);
        Comparable objValue = (Comparable)this.obj.eval(env);
        Integer comparedLeft = RelopExpression.compare(leftValue, objValue, env);
        if (comparedLeft == null) {
            return null;
        }
        if (comparedLeft <= 0) {
            Integer comparedRight = RelopExpression.compare(rightValue, objValue, env);
            if (comparedRight == null) {
                return null;
            }
            if (comparedRight >= 0) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public String toString() {
        return "B " + this.obj + " " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.obj.usedColumns(availableColumns));
        result.addAll(this.left.usedColumns(availableColumns));
        result.addAll(this.right.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.obj.aggregateFunctions());
        result.addAll(this.left.aggregateFunctions());
        result.addAll(this.right.aggregateFunctions());
        return result;
    }
}

