/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mockdata.MockDataExecuteWizard;
import org.jkiss.dbeaver.ext.mockdata.MockDataMessages;
import org.jkiss.dbeaver.ext.mockdata.MockDataSettings;
import org.jkiss.dbeaver.ext.mockdata.MockDataWizardPageSettings;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.IExternalTool;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.tools.ToolWizardDialog;

public class MockDataGenerateTool
implements IExternalTool {
    private MockDataSettings mockDataSettings = new MockDataSettings();

    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        ArrayList<DBSDataManipulator> dbObjects = new ArrayList<DBSDataManipulator>();
        for (DBSObject obj : objects) {
            dbObjects.add((DBSDataManipulator)obj);
        }
        MockDataExecuteWizard wizard = new MockDataExecuteWizard(this.mockDataSettings, dbObjects, MockDataMessages.tools_mockdata_wizard_page_name);
        ToolWizardDialog dialog = new ToolWizardDialog(window, (IWizard)wizard){

            protected void finishPressed() {
                if (this.validateProperties(this.getCurrentPage())) {
                    return;
                }
                if (MockDataGenerateTool.this.mockDataSettings.isRemoveOldData() && !UIUtils.confirmAction((Shell)this.getShell(), (String)MockDataMessages.tools_mockdata_wizard_title, (String)MockDataMessages.tools_mockdata_wizard_page_settings_confirm_delete_old_data_message)) {
                    return;
                }
                super.finishPressed();
            }

            protected void nextPressed() {
                IWizardPage currentPage = this.getCurrentPage();
                if (currentPage instanceof MockDataWizardPageSettings && this.validateProperties(currentPage)) {
                    return;
                }
                super.nextPressed();
            }

            private boolean validateProperties(IWizardPage currentPage) {
                if (currentPage instanceof MockDataWizardPageSettings && !((MockDataWizardPageSettings)currentPage).validateProperties()) {
                    this.setErrorMessage(MockDataMessages.tools_mockdata_wizard_negative_numeric_error);
                    return true;
                }
                return false;
            }

            protected Point getInitialSize() {
                return new Point(850, 550);
            }
        };
        dialog.open();
    }
}

