/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.editors.data.AbstractDataEditor;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.search.AbstractSearchResultsPage;
import org.jkiss.dbeaver.ui.search.data.SearchDataObject;

public class SearchDataResultsPage
extends AbstractSearchResultsPage<SearchDataObject> {
    private List<SearchDataObject> foundObjects = new ArrayList<SearchDataObject>();

    @Override
    protected AbstractSearchResultsPage.SearchResultsControl createResultControl(Composite parent) {
        return new DataSearchResultsControl(parent);
    }

    @Override
    protected DBNNode getNodeFromObject(SearchDataObject object) {
        return object.getNode();
    }

    @Override
    public void populateObjects(DBRProgressMonitor monitor, Collection<SearchDataObject> objects) {
        this.foundObjects.addAll(objects);
        super.populateObjects(monitor, objects);
    }

    private class DataSearchResultsControl
    extends AbstractSearchResultsPage.SearchResultsControl {
        public DataSearchResultsControl(Composite resultsGroup) {
            super(resultsGroup);
            this.setDoubleClickHandler(event -> {
                DBNNode node = NavigatorUtils.getSelectedNode((ISelectionProvider)this.getItemsViewer());
                if (!(node instanceof DBNDatabaseNode) || !node.allowsOpen()) {
                    return;
                }
                Object objectValue = this.getObjectValue(node);
                if (!(objectValue instanceof SearchDataObject)) {
                    return;
                }
                SearchDataObject object = (SearchDataObject)objectValue;
                AbstractDataEditor.openNewDataEditor((DBNDatabaseNode)node, object.getFilter());
            });
        }

        @Override
        protected Class<?>[] getListBaseTypes(Collection<DBNNode> items) {
            return new Class[]{DBPNamedObject.class, SearchDataObject.class};
        }

        @Override
        protected Object getObjectValue(DBNNode item) {
            for (SearchDataObject obj : SearchDataResultsPage.this.foundObjects) {
                if (obj.getNode() != item) continue;
                return obj;
            }
            return item;
        }
    }
}

