/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLEditor
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sqleditor";
    private static final String TEXT_EDITOR_PAGE_ID = "org.eclipse.ui.preferencePages.GeneralTextEditor";
    private Button editorSeparateConnectionCheck;
    private Button connectOnActivationCheck;
    private Button connectOnExecuteCheck;
    private Button saveOnQueryExecution;
    private Button autoSaveOnClose;
    private Combo deleteEmptyCombo;
    private Button autoFoldersCheck;
    private Button connectionFoldersCheck;
    private Text scriptTitlePattern;
    private Button closeTabOnErrorCheck;
    private Combo resultsOrientationCombo;

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("database.editor.separate.connection") || store.contains("database.editor.connect.on.activate") || store.contains("database.editor.connect.on.execute") || store.contains("SQLEditor.autoSaveOnClose") || store.contains("SQLEditor.autoSaveOnExecute") || store.contains("script.delete.empty") || store.contains("script.auto.folders") || store.contains("SQLEditor.resultSet.closeOnError") || store.contains("SQLEditor.resultSet.orientation");
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group connectionsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_sql_editor_group_connections, (int)1, (int)770, (int)0);
        this.editorSeparateConnectionCheck = UIUtils.createCheckbox((Composite)connectionsGroup, (String)CoreMessages.pref_page_sql_editor_label_separate_connection_each_editor, (boolean)false);
        this.connectOnActivationCheck = UIUtils.createCheckbox((Composite)connectionsGroup, (String)CoreMessages.pref_page_sql_editor_label_connect_on_editor_activation, (boolean)false);
        this.connectOnExecuteCheck = UIUtils.createCheckbox((Composite)connectionsGroup, (String)CoreMessages.pref_page_sql_editor_label_connect_on_query_execute, (boolean)false);
        connectionsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_sql_editor_group_auto_save, (int)1, (int)768, (int)0);
        this.autoSaveOnClose = UIUtils.createCheckbox((Composite)connectionsGroup, (String)CoreMessages.pref_page_sql_editor_label_auto_save_on_close, (boolean)false);
        this.saveOnQueryExecution = UIUtils.createCheckbox((Composite)connectionsGroup, (String)CoreMessages.pref_page_sql_editor_label_save_on_query_execute, (boolean)false);
        Group scriptsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_sql_editor_group_resources, (int)2, (int)768, (int)0);
        ((GridData)scriptsGroup.getLayoutData()).horizontalSpan = 2;
        this.deleteEmptyCombo = UIUtils.createLabelCombo((Composite)scriptsGroup, (String)CoreMessages.pref_page_sql_editor_checkbox_delete_empty_scripts, (int)12);
        Enum[] enumArray = SQLPreferenceConstants.EmptyScriptCloseBehavior.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLPreferenceConstants.EmptyScriptCloseBehavior escb = enumArray[n2];
            this.deleteEmptyCombo.add(escb.getTitle());
            ++n2;
        }
        this.deleteEmptyCombo.setLayoutData((Object)new GridData(32));
        this.deleteEmptyCombo.select(0);
        this.autoFoldersCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)CoreMessages.pref_page_sql_editor_checkbox_put_new_scripts, null, (boolean)false, (int)2);
        this.connectionFoldersCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)CoreMessages.pref_page_sql_editor_checkbox_create_script_folders, null, (boolean)false, (int)2);
        this.scriptTitlePattern = UIUtils.createLabelText((Composite)scriptsGroup, (String)CoreMessages.pref_page_sql_editor_title_pattern, (String)"");
        UIUtils.installContentProposal((Control)this.scriptTitlePattern, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"connectionName"), GeneralUtils.variablePattern((String)"driverName"), GeneralUtils.variablePattern((String)"fileName"), GeneralUtils.variablePattern((String)"fileExt")}));
        UIUtils.setContentProposalToolTip((Control)this.scriptTitlePattern, (String)"Output file name patterns", (String[])new String[]{"connectionName", "driverName", "fileName", "fileExt"});
        Group layoutGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_sql_editor_group_result_view, (int)2, (int)768, (int)0);
        ((GridData)layoutGroup.getLayoutData()).horizontalSpan = 2;
        this.closeTabOnErrorCheck = UIUtils.createCheckbox((Composite)layoutGroup, (String)CoreMessages.pref_page_sql_editor_label_close_results_tab_on_error, null, (boolean)false, (int)2);
        this.resultsOrientationCombo = UIUtils.createLabelCombo((Composite)layoutGroup, (String)CoreMessages.pref_page_sql_editor_label_results_orientation, (String)CoreMessages.pref_page_sql_editor_label_results_orientation_tip, (int)12);
        ((GridData)this.resultsOrientationCombo.getLayoutData()).grabExcessHorizontalSpace = false;
        enumArray = SQLEditor.ResultSetOrientation.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum orientation = enumArray[n2];
            if (((SQLEditor.ResultSetOrientation)orientation).isSupported()) {
                this.resultsOrientationCombo.add(((SQLEditor.ResultSetOrientation)orientation).getLabel());
            }
            ++n2;
        }
        new PreferenceLinkArea(composite, 0, TEXT_EDITOR_PAGE_ID, "<a>''{0}''</a>" + CoreMessages.pref_page_sql_editor_link_text_editor, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        return composite;
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.editorSeparateConnectionCheck.setSelection(store.getBoolean("database.editor.separate.connection"));
            this.connectOnActivationCheck.setSelection(store.getBoolean("database.editor.connect.on.activate"));
            this.connectOnExecuteCheck.setSelection(store.getBoolean("database.editor.connect.on.execute"));
            this.autoSaveOnClose.setSelection(store.getBoolean("SQLEditor.autoSaveOnClose"));
            this.saveOnQueryExecution.setSelection(store.getBoolean("SQLEditor.autoSaveOnExecute"));
            this.deleteEmptyCombo.setText(SQLPreferenceConstants.EmptyScriptCloseBehavior.getByName(store.getString("script.delete.empty")).getTitle());
            this.autoFoldersCheck.setSelection(store.getBoolean("script.auto.folders"));
            this.connectionFoldersCheck.setSelection(store.getBoolean("script.auto.connection.folders"));
            this.scriptTitlePattern.setText(store.getString("script.title.pattern"));
            this.closeTabOnErrorCheck.setSelection(store.getBoolean("SQLEditor.resultSet.closeOnError"));
            SQLEditor.ResultSetOrientation orientation = SQLEditor.ResultSetOrientation.valueOf(store.getString("SQLEditor.resultSet.orientation"));
            this.resultsOrientationCombo.setText(orientation.getLabel());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("database.editor.separate.connection", this.editorSeparateConnectionCheck.getSelection());
            store.setValue("database.editor.connect.on.activate", this.connectOnActivationCheck.getSelection());
            store.setValue("database.editor.connect.on.execute", this.connectOnExecuteCheck.getSelection());
            store.setValue("SQLEditor.autoSaveOnClose", this.autoSaveOnClose.getSelection());
            store.setValue("SQLEditor.autoSaveOnExecute", this.saveOnQueryExecution.getSelection());
            store.setValue("script.delete.empty", SQLPreferenceConstants.EmptyScriptCloseBehavior.getByTitle(this.deleteEmptyCombo.getText()).name());
            store.setValue("script.auto.folders", this.autoFoldersCheck.getSelection());
            store.setValue("script.auto.connection.folders", this.connectionFoldersCheck.getSelection());
            store.setValue("script.title.pattern", this.scriptTitlePattern.getText());
            store.setValue("SQLEditor.resultSet.closeOnError", this.closeTabOnErrorCheck.getSelection());
            String orientationLabel = this.resultsOrientationCombo.getText();
            SQLEditor.ResultSetOrientation[] resultSetOrientationArray = SQLEditor.ResultSetOrientation.values();
            int n = resultSetOrientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                SQLEditor.ResultSetOrientation orientation = resultSetOrientationArray[n2];
                if (orientationLabel.equals(orientation.getLabel())) {
                    store.setValue("SQLEditor.resultSet.orientation", orientation.name());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("database.editor.separate.connection");
        store.setToDefault("database.editor.connect.on.activate");
        store.setToDefault("database.editor.connect.on.execute");
        store.setToDefault("SQLEditor.autoSaveOnClose");
        store.setToDefault("SQLEditor.autoSaveOnExecute");
        store.setToDefault("script.delete.empty");
        store.setToDefault("script.auto.folders");
        store.setToDefault("script.auto.connection.folders");
        store.setToDefault("script.title.pattern");
        store.setToDefault("SQLEditor.resultSet.closeOnError");
        store.setToDefault("SQLEditor.resultSet.orientation");
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

