/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProviderEx;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerRefresh;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dnd.DatabaseObjectTransfer;
import org.jkiss.dbeaver.ui.dnd.TreeNodeTransfer;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorUtils {
    private static final Log log = Log.getLog(NavigatorUtils.class);

    public static DBNNode getSelectedNode(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return null;
        }
        return NavigatorUtils.getSelectedNode(selectionProvider.getSelection());
    }

    public static DBNNode getSelectedNode(ISelection selection) {
        Object selectedObject;
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof DBNNode) {
            return (DBNNode)selectedObject;
        }
        return null;
    }

    public static DBNNode getSelectedNode(UIElement element) {
        ISelectionProvider selectionProvider = UIUtils.getSelectionProvider((IServiceLocator)element.getServiceLocator());
        if (selectionProvider != null) {
            return NavigatorUtils.getSelectedNode(selectionProvider);
        }
        return null;
    }

    public static DBSObject getSelectedObject(ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        return DBUtils.getFromObject((Object)((IStructuredSelection)selection).getFirstElement());
    }

    public static List<DBSObject> getSelectedObjects(ISelection selection) {
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DBSObject> result = new ArrayList<DBSObject>();
        if (selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                DBSObject selectedObject = DBUtils.getFromObject(iter.next());
                if (selectedObject == null) continue;
                result.add(selectedObject);
            }
        }
        return result;
    }

    public static void addContextMenu(IWorkbenchSite workbenchSite, Viewer viewer) {
        NavigatorUtils.addContextMenu(workbenchSite, viewer, null);
    }

    public static void addContextMenu(IWorkbenchSite workbenchSite, Viewer viewer, IMenuListener menuListener) {
        MenuManager menuMgr = NavigatorUtils.createContextMenu(workbenchSite, viewer, menuListener);
        if (workbenchSite instanceof IWorkbenchPartSite) {
            ((IWorkbenchPartSite)workbenchSite).registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        } else if (workbenchSite instanceof IPageSite) {
            ((IPageSite)workbenchSite).registerContextMenu("navigatorMenu", menuMgr, (ISelectionProvider)viewer);
        }
    }

    public static MenuManager createContextMenu(final IWorkbenchSite workbenchSite, final Viewer viewer, final IMenuListener menuListener) {
        final Control control = viewer.getControl();
        final MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(control);
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                DBNNode node = NavigatorUtils.getSelectedNode(viewer.getSelection());
                if (node != null && !node.isLocked() && node.allowsOpen()) {
                    String commandID = NavigatorUtils.getNodeActionCommand(DBXTreeNodeHandler.Action.open, node, "org.jkiss.dbeaver.core.object.open");
                    MenuItem[] menuItemArray = m.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String contribId;
                        MenuItem item = menuItemArray[n2];
                        Object itemData = item.getData();
                        if (itemData instanceof IContributionItem && (contribId = ((IContributionItem)itemData).getId()) != null && contribId.equals(commandID)) {
                            m.setDefaultItem(item);
                        }
                        ++n2;
                    }
                }
            }
        });
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ViewerColumnController columnController = ViewerColumnController.getFromControl(control);
                if (columnController != null && columnController.isClickOnHeader()) {
                    columnController.fillConfigMenu(manager);
                    manager.add((IContributionItem)new Separator());
                    return;
                }
                manager.add((IContributionItem)new GroupMarker("navigator_additions"));
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                DBNNode selectedNode = NavigatorUtils.getSelectedNode((ISelectionProvider)viewer);
                if (selectedNode != null && !selectedNode.isLocked() && workbenchSite != null) {
                    DBNDatabaseNode databaseNode;
                    DBSObject activeChild;
                    DBSObjectSelector activeContainer;
                    if (selectedNode.isPersisted() && selectedNode instanceof DBNDatabaseNode && !(selectedNode instanceof DBNDatabaseFolder) && ((DBNDatabaseNode)selectedNode).getObject() != null && (activeContainer = (DBSObjectSelector)DBUtils.getParentAdapter(DBSObjectSelector.class, (DBSObject)((DBNDatabaseNode)selectedNode).getObject())) != null && activeContainer.supportsDefaultChange() && (activeChild = activeContainer.getDefaultObject()) != ((DBNDatabaseNode)selectedNode).getObject() && (databaseNode = (DBNDatabaseNode)selectedNode).getObject() != null && (activeChild == null || activeChild.getClass() == databaseNode.getObject().getClass())) {
                        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.navigator.set.active"));
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IContributionItem)new GroupMarker("additions"));
                    manager.add((IContributionItem)new GroupMarker("additions_end"));
                    if (PreferencesUtil.hasPropertiesContributors((Object)selection.getFirstElement())) {
                        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.properties"));
                    }
                    if (selectedNode.isPersisted()) {
                        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.refresh"));
                    }
                }
                manager.add((IContributionItem)new GroupMarker("tools"));
                manager.add((IContributionItem)new GroupMarker("tools_end"));
                if (menuListener != null) {
                    menuListener.menuAboutToShow(manager);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menuMgr.dispose();
            }
        });
        return menuMgr;
    }

    public static void executeNodeAction(DBXTreeNodeHandler.Action action, Object node, IServiceLocator serviceLocator) {
        String actionCommand;
        String defCommandId = null;
        if (action == DBXTreeNodeHandler.Action.open) {
            defCommandId = "org.jkiss.dbeaver.core.object.open";
        }
        if ((actionCommand = NavigatorUtils.getNodeActionCommand(action, node, defCommandId)) != null) {
            ActionUtils.runCommand((String)actionCommand, (ISelection)new StructuredSelection(node), (IServiceLocator)serviceLocator);
        }
    }

    public static String getNodeActionCommand(DBXTreeNodeHandler.Action action, Object node, String defCommand) {
        DBXTreeNodeHandler handler;
        if (node instanceof DBNDatabaseNode && (handler = ((DBNDatabaseNode)node).getMeta().getHandler(action)) != null && handler.getPerform() == DBXTreeNodeHandler.Perform.command && !CommonUtils.isEmpty((String)handler.getCommand())) {
            return handler.getCommand();
        }
        return defCommand;
    }

    public static void addDragAndDropSupport(final Viewer viewer) {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance(), TreeNodeTransfer.getInstance(), DatabaseObjectTransfer.getInstance()};
        int operations = 7;
        DragSource source = new DragSource(viewer.getControl(), operations);
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){
            private IStructuredSelection selection;

            public void dragStart(DragSourceEvent event) {
                this.selection = (IStructuredSelection)viewer.getSelection();
            }

            public void dragSetData(DragSourceEvent event) {
                if (!this.selection.isEmpty()) {
                    ArrayList<DBNNode> nodes = new ArrayList<DBNNode>();
                    ArrayList<DBSObject> objects = new ArrayList<DBSObject>();
                    String lineSeparator = CommonUtils.getLineSeparator();
                    StringBuilder buf = new StringBuilder();
                    for (Object nextSelected : this.selection) {
                        String nodeName;
                        if (!(nextSelected instanceof DBNNode)) continue;
                        nodes.add((DBNNode)nextSelected);
                        if (nextSelected instanceof DBNDatabaseNode && !(nextSelected instanceof DBNDataSource)) {
                            DBSObject object = ((DBNDatabaseNode)nextSelected).getObject();
                            if (object == null) continue;
                            nodeName = DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI);
                            objects.add(object);
                        } else {
                            nodeName = ((DBNNode)nextSelected).getNodeTargetName();
                        }
                        if (buf.length() > 0) {
                            buf.append(lineSeparator);
                        }
                        buf.append(nodeName);
                    }
                    if (TreeNodeTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = nodes;
                    } else if (DatabaseObjectTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = objects;
                    } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = buf.toString();
                    }
                } else if (TreeNodeTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = Collections.emptyList();
                } else if (DatabaseObjectTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = Collections.emptyList();
                } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = "";
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget dropTarget = new DropTarget(viewer.getControl(), 2);
        dropTarget.setTransfer(new Transfer[]{TreeNodeTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2) {
                    this.moveNodes(event);
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                event.detail = this.isDropSupported(event) ? 2 : 0;
                event.feedback = 1;
            }

            private boolean isDropSupported(DropTargetEvent event) {
                TreeItem treeItem;
                Object curObject;
                if (TreeNodeTransfer.getInstance().isSupportedType(event.currentDataType) && event.item instanceof TreeItem && (curObject = (treeItem = (TreeItem)event.item).getData()) instanceof DBNNode) {
                    Collection nodesToDrop = (Collection)event.data;
                    if (!CommonUtils.isEmpty((Collection)nodesToDrop)) {
                        for (DBNNode node : nodesToDrop) {
                            if (((DBNNode)curObject).supportsDrop(node)) continue;
                            return false;
                        }
                        return true;
                    }
                    return ((DBNNode)curObject).supportsDrop(null);
                }
                return false;
            }

            private void moveNodes(DropTargetEvent event) {
                TreeItem treeItem;
                Object curObject;
                if (TreeNodeTransfer.getInstance().isSupportedType(event.currentDataType) && event.item instanceof TreeItem && (curObject = (treeItem = (TreeItem)event.item).getData()) instanceof DBNNode) {
                    Collection nodesToDrop = (Collection)TreeNodeTransfer.getInstance().getObject();
                    try {
                        ((DBNNode)curObject).dropNodes(nodesToDrop);
                    }
                    catch (DBException e) {
                        DBUserInterface.getInstance().showError("Drop error", "Can't drop node", (Throwable)e);
                    }
                }
            }
        });
    }

    public static boolean isDefaultElement(Object element) {
        if (element instanceof DBSWrapper) {
            DBSObject object = ((DBSWrapper)element).getObject();
            DBSObjectSelector activeContainer = (DBSObjectSelector)DBUtils.getParentAdapter(DBSObjectSelector.class, (DBSObject)object);
            if (activeContainer != null) {
                return activeContainer.getDefaultObject() == object;
            }
        } else if (element instanceof DBNProject && ((DBNProject)element).getProject() == DBeaverCore.getInstance().getProjectRegistry().getActiveProject()) {
            return true;
        }
        return false;
    }

    public static NavigatorViewBase getActiveNavigatorView(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof NavigatorViewBase) {
            return (NavigatorViewBase)activePart;
        }
        IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        activePart = activePage.findView("org.jkiss.dbeaver.core.databaseNavigator");
        if (activePart instanceof NavigatorViewBase && activePage.isPartVisible(activePart)) {
            return (NavigatorViewBase)activePart;
        }
        activePart = activePage.findView("org.jkiss.dbeaver.core.projectNavigator");
        if (activePart instanceof NavigatorViewBase && activePage.isPartVisible(activePart)) {
            return (NavigatorViewBase)activePart;
        }
        return null;
    }

    public static void filterSelection(ISelection selection, boolean exclude) {
        if (selection instanceof IStructuredSelection) {
            HashMap<DBNDatabaseFolder, DBSObjectFilter> folders = new HashMap<DBNDatabaseFolder, DBSObjectFilter>();
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof DBNNode) {
                    DBNNode node = (DBNNode)item;
                    DBNDatabaseFolder folder = (DBNDatabaseFolder)node.getParentNode();
                    DBSObjectFilter nodeFilter = (DBSObjectFilter)folders.get(folder);
                    if (nodeFilter == null) {
                        nodeFilter = folder.getNodeFilter(folder.getItemsMeta(), true);
                        if (nodeFilter == null) {
                            nodeFilter = new DBSObjectFilter();
                        }
                        folders.put(folder, nodeFilter);
                    }
                    if (exclude) {
                        nodeFilter.addExclude(node.getNodeName());
                    } else {
                        nodeFilter.addInclude(node.getNodeName());
                    }
                    nodeFilter.setEnabled(true);
                }
                ++n2;
            }
            for (Map.Entry entry : folders.entrySet()) {
                ((DBNDatabaseFolder)entry.getKey()).setNodeFilter(((DBNDatabaseFolder)entry.getKey()).getItemsMeta(), (DBSObjectFilter)entry.getValue());
            }
            NavigatorHandlerRefresh.refreshNavigator(folders.keySet());
        }
    }

    public static boolean syncEditorWithNavigator(INavigatorModelView navigatorView, IEditorPart activeEditor) {
        DBSObjectSelector selector;
        DBSObject curDefaultObject;
        DBPObject parentObject;
        DBSObject dbObject;
        if (!(activeEditor instanceof IDataSourceContainerProviderEx)) {
            return false;
        }
        IDataSourceContainerProviderEx dsProvider = (IDataSourceContainerProviderEx)activeEditor;
        Viewer navigatorViewer = navigatorView.getNavigatorViewer();
        if (navigatorViewer == null) {
            return false;
        }
        DBNNode selectedNode = NavigatorUtils.getSelectedNode(navigatorViewer.getSelection());
        if (!(selectedNode instanceof DBNDatabaseNode)) {
            return false;
        }
        DBPDataSourceContainer ds = ((DBNDatabaseNode)selectedNode).getDataSourceContainer();
        if (ds == null) {
            return false;
        }
        if (dsProvider.getDataSourceContainer() != ds) {
            dsProvider.setDataSourceContainer(ds);
        }
        if ((dbObject = ((DBNDatabaseNode)selectedNode).getObject()) != null && dbObject.getParentObject() != null && (parentObject = DBUtils.getPublicObject((DBPObject)dbObject.getParentObject())) instanceof DBSObjectSelector && (curDefaultObject = (selector = (DBSObjectSelector)parentObject).getDefaultObject()) != dbObject) {
            if (curDefaultObject != null && curDefaultObject.getClass() != dbObject.getClass()) {
                return true;
            }
            try {
                selector.setDefaultObject((DBRProgressMonitor)new VoidProgressMonitor(), dbObject);
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return true;
    }

    public static DBNDatabaseNode getNodeByObject(DBSObject object) {
        return DBeaverCore.getInstance().getNavigatorModel().getNodeByObject(object);
    }

    public static DBNDatabaseNode getNodeByObject(DBRProgressMonitor monitor, DBSObject object, boolean addFiltered) {
        return DBeaverCore.getInstance().getNavigatorModel().getNodeByObject(monitor, object, addFiltered);
    }

    public static DBNDatabaseNode getChildFolder(DBRProgressMonitor monitor, DBNDatabaseNode node, Class<?> folderType) {
        try {
            DBNDatabaseNode[] dBNDatabaseNodeArray = node.getChildren(monitor);
            int n = dBNDatabaseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode childNode = dBNDatabaseNodeArray[n2];
                if (childNode instanceof DBNDatabaseFolder && folderType.getName().equals(((DBNDatabaseFolder)childNode).getMeta().getType())) {
                    return childNode;
                }
                ++n2;
            }
        }
        catch (DBException e) {
            log.error((Object)"Error reading child folder", (Throwable)e);
        }
        return null;
    }

    public static DBNDataSource getDataSourceNode(DBNNode node) {
        DBNNode pn = node;
        while (pn != null) {
            if (pn instanceof DBNDataSource) {
                return (DBNDataSource)pn;
            }
            pn = pn.getParentNode();
        }
        return null;
    }

    public static DBNNode[] getNodeChildrenFiltered(DBRProgressMonitor monitor, DBNNode node, boolean forTree) throws DBException {
        DBNNode[] children = node.getChildren(monitor);
        if (children != null && children.length > 0) {
            children = NavigatorUtils.filterNavigableChildren(children, forTree);
        }
        return children;
    }

    public static DBNNode[] filterNavigableChildren(DBNNode[] children, boolean forTree) {
        if (ArrayUtils.isEmpty((Object[])children)) {
            return children;
        }
        ArrayList<DBNNode> filtered = null;
        if (forTree) {
            int i = 0;
            while (i < children.length) {
                DBNNode node = children[i];
                if (node instanceof DBNDatabaseNode && !((DBNDatabaseNode)node).getMeta().isNavigable()) {
                    if (filtered == null) {
                        filtered = new ArrayList<DBNNode>(children.length);
                        int k = 0;
                        while (k < i) {
                            filtered.add(children[k]);
                            ++k;
                        }
                    }
                } else if (filtered != null) {
                    filtered.add(node);
                }
                ++i;
            }
        }
        DBNNode[] result = filtered == null ? children : filtered.toArray(new DBNNode[filtered.size()]);
        NavigatorUtils.sortNodes(result);
        return result;
    }

    private static void sortNodes(DBNNode[] children) {
        DBPPreferenceStore prefStore = DBeaverCore.getGlobalPreferenceStore();
        if (children.length > 0 && prefStore.getBoolean("navigator.sort.case.insensitive") && !(children[0] instanceof DBNContainer)) {
            Arrays.sort(children, NodeNameComparator.INSTANCE);
        }
        if (children.length > 0 && prefStore.getBoolean("navigator.sort.forlers.first")) {
            Arrays.sort(children, NodeFolderComparator.INSTANCE);
        }
    }

    public static void openNavigatorNode(Object node, IWorkbenchWindow window) {
        if (node instanceof DBNResource) {
            NavigatorHandlerObjectOpen.openResource(((DBNResource)node).getResource(), window);
        } else if (node instanceof DBNNode && ((DBNNode)node).allowsOpen()) {
            NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)node, null, window);
        }
    }

    public static void refreshNavigatorResource(@NotNull IResource resource, Object source) {
        DBNResource fileNode;
        DBNProject projectNode = DBeaverCore.getInstance().getNavigatorModel().getRoot().getProject(resource.getProject());
        if (projectNode != null && (fileNode = projectNode.findResource(resource)) != null) {
            fileNode.refreshResourceState(source);
        }
    }

    private static class NodeFolderComparator
    implements Comparator<DBNNode> {
        static NodeFolderComparator INSTANCE = new NodeFolderComparator();

        private NodeFolderComparator() {
        }

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            int first = node1 instanceof DBNLocalFolder || node1 instanceof DBSFolder ? -1 : 1;
            int second = node2 instanceof DBNLocalFolder || node2 instanceof DBSFolder ? -1 : 1;
            return first - second;
        }
    }

    private static class NodeNameComparator
    implements Comparator<DBNNode> {
        static NodeNameComparator INSTANCE = new NodeNameComparator();

        private NodeNameComparator() {
        }

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            return node1.getNodeName().compareToIgnoreCase(node2.getNodeName());
        }
    }
}

