/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProcessor;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLWordPartDetector;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

class SQLCompletionAnalyzer {
    private static final Log log = Log.getLog(SQLCompletionAnalyzer.class);
    private static final String MATCH_ANY_PATTERN = "%";
    private final DBRProgressMonitor monitor;
    private final CompletionRequest request;

    SQLCompletionAnalyzer(DBRProgressMonitor monitor, CompletionRequest request) {
        this.monitor = monitor;
        this.request = request;
    }

    void runAnalyzer() {
        boolean emptyWord;
        DBPDataSource dataSource = this.request.editor.getDataSource();
        if (dataSource == null) {
            return;
        }
        boolean bl = emptyWord = this.request.wordPart.length() == 0;
        if (this.request.queryType != null) {
            DBSObject selectedObject;
            DBSObjectContainer sc;
            DBSObject rootObject;
            if (emptyWord) {
                DBSObject leftTable;
                rootObject = null;
                if (this.request.queryType == SQLCompletionProcessor.QueryType.COLUMN && dataSource instanceof DBSObjectContainer) {
                    rootObject = this.getTableFromAlias((DBSObjectContainer)dataSource, null);
                    if (rootObject instanceof DBSEntity && "ON".equals(this.request.wordDetector.getPrevKeyWord()) && this.makeJoinColumnProposals((DBSObjectContainer)dataSource, (DBSEntity)rootObject)) {
                        return;
                    }
                } else if (dataSource instanceof DBSObjectContainer) {
                    DBSObject selectedObject2 = DBUtils.getActiveInstanceObject((DBSInstance)dataSource);
                    if (selectedObject2 != null) {
                        this.makeProposalsFromChildren((DBPObject)selectedObject2, null);
                        rootObject = DBUtils.getPublicObject((DBPObject)selectedObject2.getParentObject());
                    } else {
                        rootObject = dataSource;
                    }
                }
                if (rootObject != null) {
                    this.makeProposalsFromChildren((DBPObject)rootObject, null);
                }
                if (this.request.queryType == SQLCompletionProcessor.QueryType.JOIN && !this.request.proposals.isEmpty() && dataSource instanceof DBSObjectContainer && (leftTable = this.getTableFromAlias((DBSObjectContainer)dataSource, null)) instanceof DBSEntity) {
                    this.filterNonJoinableProposals((DBSEntity)leftTable);
                }
            } else {
                rootObject = null;
                if (this.request.queryType == SQLCompletionProcessor.QueryType.COLUMN && dataSource instanceof DBSObjectContainer) {
                    int divPos;
                    sc = (DBSObjectContainer)dataSource;
                    selectedObject = DBUtils.getActiveInstanceObject((DBSInstance)dataSource);
                    if (selectedObject instanceof DBSObjectContainer) {
                        sc = (DBSObjectContainer)selectedObject;
                    }
                    String tableAlias = (divPos = this.request.wordPart.indexOf(this.request.editor.getSyntaxManager().getStructSeparator())) == -1 ? null : this.request.wordPart.substring(0, divPos);
                    rootObject = this.getTableFromAlias(sc, tableAlias);
                }
                if (rootObject != null) {
                    this.makeProposalsFromChildren((DBPObject)rootObject, this.request.wordPart);
                } else {
                    this.makeDataSourceProposals();
                }
            }
            if (dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.show.column.procedures") && !this.request.simpleMode && this.request.queryType == SQLCompletionProcessor.QueryType.COLUMN && dataSource instanceof DBSObjectContainer) {
                DBSStructureAssistant structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)dataSource);
                sc = (DBSObjectContainer)dataSource;
                selectedObject = DBUtils.getActiveInstanceObject((DBSInstance)dataSource);
                if (selectedObject instanceof DBSObjectContainer) {
                    sc = (DBSObjectContainer)selectedObject;
                }
                if (structureAssistant != null) {
                    this.makeProposalsFromAssistant(dataSource, structureAssistant, sc, new DBSObjectType[]{RelationalObjectType.TYPE_PROCEDURE}, this.request.wordPart);
                }
            }
        } else {
            this.makeDataSourceProposals();
        }
    }

    private boolean makeJoinColumnProposals(DBSObjectContainer sc, DBSEntity leftTable) {
        SQLWordPartDetector joinTableDetector = new SQLWordPartDetector((IDocument)this.request.editor.getDocument(), this.request.editor.getSyntaxManager(), this.request.wordDetector.getStartOffset(), 2);
        List<String> prevWords = joinTableDetector.getPrevWords();
        if (!CommonUtils.isEmpty(prevWords)) {
            DBPDataSource dataSource = this.request.editor.getDataSource();
            SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
            String rightTableName = prevWords.get(0);
            String[] allNames = SQLUtils.splitFullIdentifier((String)rightTableName, (String)sqlDialect.getCatalogSeparator(), (String[][])sqlDialect.getIdentifierQuoteStrings(), (boolean)false);
            DBSObject rightTable = this.findObjectByFQN(sc, dataSource, Arrays.asList(allNames));
            if (rightTable instanceof DBSEntity) {
                try {
                    String joinCriteria = SQLUtils.generateTableJoin((DBRProgressMonitor)this.monitor, (DBSEntity)leftTable, (String)leftTable.getName(), (DBSEntity)((DBSEntity)rightTable), (String)rightTable.getName());
                    this.request.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, joinCriteria, joinCriteria, DBPKeywordType.OTHER, "Join condition"));
                    return true;
                }
                catch (DBException e) {
                    log.error((Object)"Error generating joinb condition", (Throwable)e);
                }
            }
        }
        return false;
    }

    private void filterNonJoinableProposals(DBSEntity leftTable) {
        List<SQLCompletionProposal> proposals = this.request.proposals;
        ArrayList<SQLCompletionProposal> joinableProposals = new ArrayList<SQLCompletionProposal>();
        for (SQLCompletionProposal proposal : proposals) {
            DBSEntity rightTable;
            if (!(proposal.getObject() instanceof DBSEntity) || !this.tableHaveJoins(rightTable = (DBSEntity)proposal.getObject(), leftTable) && !this.tableHaveJoins(leftTable, rightTable)) continue;
            proposal.setReplacementAfter(" ON");
            joinableProposals.add(proposal);
        }
        if (!joinableProposals.isEmpty()) {
            this.request.proposals.clear();
            this.request.proposals.addAll(joinableProposals);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tableHaveJoins(DBSEntity table1, DBSEntity table2) {
        try {
            Collection associations = table1.getAssociations(this.monitor);
            if (!CommonUtils.isEmpty((Collection)associations)) {
                for (DBSEntityAssociation fk : associations) {
                    if (fk.getAssociatedEntity() != table2) continue;
                    return true;
                }
            }
            return false;
        }
        catch (DBException e) {
            log.error((Object)e);
            return false;
        }
    }

    private void makeDataSourceProposals() {
        Object sc;
        DBPDataSource dataSource = this.request.editor.getDataSource();
        DBSObjectContainer rootContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
        if (rootContainer == null) {
            return;
        }
        DBSObjectContainer childObject = sc = rootContainer;
        String[] tokens = this.request.wordDetector.splitWordPart();
        DBSObject[] selectedObjects = DBUtils.getSelectedObjects((DBSObject)dataSource);
        DBSObjectContainer[] selectedContainers = new DBSObjectContainer[selectedObjects.length];
        int i = 0;
        while (i < selectedObjects.length) {
            selectedContainers[i] = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)selectedObjects[i]);
            ++i;
        }
        String lastToken = null;
        i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            if (i == tokens.length - 1 && !this.request.wordDetector.getWordPart().endsWith(".")) {
                lastToken = token;
                break;
            }
            if (sc == null) break;
            try {
                String objectName = this.request.wordDetector.isQuoted(token) ? this.request.wordDetector.removeQuotes(token) : DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)token);
                DBSObject dBSObject = childObject = objectName == null ? null : sc.getChild(this.monitor, objectName);
                if (childObject == null && i == 0 && objectName != null) {
                    int k = 0;
                    while (k < selectedContainers.length) {
                        if (selectedContainers[k] != null && (childObject = selectedContainers[k].getChild(this.monitor, objectName)) != null) {
                            sc = selectedContainers[k];
                            break;
                        }
                        ++k;
                    }
                }
                if (childObject == null) {
                    if (i == 0) {
                        List references;
                        DBSStructureAssistant structureAssistant;
                        childObject = this.getTableFromAlias((DBSObjectContainer)sc, token);
                        if (childObject == null && !this.request.simpleMode && (structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)sc)) != null && !(references = structureAssistant.findObjectsByMask(this.monitor, null, structureAssistant.getAutoCompleteObjectTypes(), this.request.wordDetector.removeQuotes(token), this.request.wordDetector.isQuoted(token), false, 2)).isEmpty()) {
                            childObject = ((DBSObjectReference)references.iterator().next()).resolveObject(this.monitor);
                        }
                    } else {
                        return;
                    }
                }
                sc = childObject instanceof DBSObjectContainer ? childObject : null;
            }
            catch (DBException e) {
                log.error((Object)e);
                return;
            }
            ++i;
        }
        if (childObject == null) {
            return;
        }
        if (lastToken == null) {
            this.makeProposalsFromChildren((DBPObject)childObject, null);
        } else {
            this.makeProposalsFromChildren((DBPObject)childObject, lastToken);
            int cfr_ignored_0 = tokens.length;
            if (this.request.proposals.isEmpty() || tokens.length == 1) {
                int k = 0;
                while (k < selectedContainers.length) {
                    if (selectedContainers[k] != null && selectedContainers[k] != childObject) {
                        this.makeProposalsFromChildren((DBPObject)selectedContainers[k], lastToken);
                    }
                    ++k;
                }
                if (!this.request.simpleMode) {
                    DBSStructureAssistant structureAssistant = null;
                    DBSObjectContainer object = childObject;
                    while (object != null) {
                        structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)object);
                        if (structureAssistant != null) break;
                        object = object.getParentObject();
                    }
                    if (structureAssistant != null) {
                        this.makeProposalsFromAssistant(dataSource, structureAssistant, (DBSObjectContainer)sc, null, lastToken);
                    }
                }
            }
        }
    }

    @Nullable
    private DBSObject getTableFromAlias(DBSObjectContainer sc, @Nullable String token) {
        Pattern aliasPattern;
        SQLScriptElement queryAtPos;
        DBPDataSource dataSource = this.request.editor.getDataSource();
        if (!(dataSource instanceof SQLDataSource)) {
            return null;
        }
        if (this.request.activeQuery == null && (queryAtPos = this.request.editor.extractQueryAtPos(this.request.documentOffset)) != null) {
            this.request.activeQuery = String.valueOf(queryAtPos.getText()) + " ";
        }
        if (this.request.activeQuery == null) {
            return null;
        }
        if (token == null) {
            token = "";
        }
        ArrayList<String> nameList = new ArrayList<String>();
        SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
        String catalogSeparator = sqlDialect.getCatalogSeparator();
        while (token.endsWith(catalogSeparator)) {
            token = token.substring(0, token.length() - 1);
        }
        String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
        StringBuilder quotes = new StringBuilder();
        if (quoteStrings != null) {
            String[][] stringArray = quoteStrings;
            int n = quoteStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] quotePair = stringArray[n2];
                if (quotes.indexOf(quotePair[0]) == -1) {
                    quotes.append('\\').append(quotePair[0]);
                }
                if (quotes.indexOf(quotePair[1]) == -1) {
                    quotes.append('\\').append(quotePair[1]);
                }
                ++n2;
            }
        }
        String tableNamePattern = "([\\p{L}0-9_$\\.\\-" + quotes.toString() + "]+)";
        String structNamePattern = CommonUtils.isEmpty((String)token) ? "(?:from|update|join|into)\\s*" + tableNamePattern : String.valueOf(tableNamePattern) + "\\s+(?:as\\s)?" + token + "[\\s,]+";
        try {
            aliasPattern = Pattern.compile(structNamePattern, 2);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        String testQuery = SQLUtils.stripComments((SQLDialect)this.request.editor.getSyntaxManager().getDialect(), (String)this.request.activeQuery);
        Matcher matcher = aliasPattern.matcher(testQuery);
        if (matcher.find()) {
            int groupCount = matcher.groupCount();
            int i = 1;
            while (i <= groupCount) {
                String group = matcher.group(i);
                if (!CommonUtils.isEmpty((String)group)) {
                    String[] allNames = SQLUtils.splitFullIdentifier((String)group, (String)catalogSeparator, (String[][])quoteStrings, (boolean)false);
                    Collections.addAll(nameList, allNames);
                }
                ++i;
            }
        }
        return this.findObjectByFQN(sc, dataSource, nameList);
    }

    @Nullable
    private DBSObject findObjectByFQN(DBSObjectContainer sc, DBPDataSource dataSource, List<String> nameList) {
        if (nameList.isEmpty()) {
            return null;
        }
        ArrayList<String> unquotedNames = new ArrayList<String>(nameList.size());
        for (String name : nameList) {
            unquotedNames.add(DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)name));
        }
        DBSObject result = this.findObjectByPath(sc, unquotedNames);
        if (result != null) {
            return result;
        }
        int i = 0;
        while (i < nameList.size()) {
            String name;
            name = nameList.get(i);
            String unquotedName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)name);
            name = !unquotedName.equals(name) ? unquotedName : DBObjectNameCaseTransformer.transformName((DBPDataSource)sc.getDataSource(), (String)name);
            nameList.set(i, name);
            ++i;
        }
        return this.findObjectByPath(sc, nameList);
    }

    private DBSObject findObjectByPath(DBSObjectContainer sc, List<String> nameList) {
        DBSObject childObject;
        block6: {
            try {
                DBSStructureAssistant structureAssistant;
                childObject = null;
                while (childObject == null) {
                    childObject = DBUtils.findNestedObject((DBRProgressMonitor)this.monitor, (DBSObjectContainer)sc, nameList);
                    if (childObject != null) continue;
                    DBSObjectContainer parentSc = (DBSObjectContainer)DBUtils.getParentAdapter(DBSObjectContainer.class, (DBSObject)sc);
                    if (parentSc == null) break;
                    sc = parentSc;
                }
                if (childObject != null || nameList.size() > 1) break block6;
                if (!this.request.simpleMode && (structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)sc)) != null) {
                    String objectNameMask = nameList.get(0);
                    List tables = structureAssistant.findObjectsByMask(this.monitor, (DBSObject)sc, structureAssistant.getAutoCompleteObjectTypes(), this.request.wordDetector.removeQuotes(objectNameMask), this.request.wordDetector.isQuoted(objectNameMask), false, 2);
                    if (!tables.isEmpty()) {
                        return ((DBSObjectReference)tables.iterator().next()).resolveObject(this.monitor);
                    }
                }
                return null;
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
        }
        return childObject;
    }

    private void makeProposalsFromChildren(DBPObject parent, @Nullable String startPart) {
        int divPos;
        if (startPart != null && (divPos = (startPart = this.request.wordDetector.removeQuotes(startPart).toUpperCase(Locale.ENGLISH)).lastIndexOf(this.request.editor.getSyntaxManager().getStructSeparator())) != -1) {
            startPart = startPart.substring(divPos + 1);
        }
        try {
            DBPDataSource dataSource = this.request.editor.getDataSource();
            boolean matchContains = dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.matching.contains");
            Collection children = null;
            if (parent instanceof DBSObjectContainer) {
                children = ((DBSObjectContainer)parent).getChildren(this.monitor);
            } else if (parent instanceof DBSEntity) {
                children = ((DBSEntity)parent).getAttributes(this.monitor);
            }
            if (children != null && !children.isEmpty()) {
                String prevWord;
                ArrayList<DBSObject> matchedObjects = new ArrayList<DBSObject>();
                HashMap<String, Integer> scoredMatches = new HashMap<String, Integer>();
                boolean simpleMode = this.request.simpleMode;
                boolean allObjects = !simpleMode && "*".equals(startPart);
                String objPrefix = null;
                if (allObjects && !CommonUtils.isEmpty(this.request.wordDetector.getPrevWords()) && (prevWord = this.request.wordDetector.getPrevWords().get(0)).length() > 0 && prevWord.charAt(prevWord.length() - 1) == this.request.editor.getSyntaxManager().getStructSeparator()) {
                    objPrefix = prevWord;
                }
                StringBuilder combinedMatch = new StringBuilder();
                for (DBSObject child : children) {
                    int score;
                    if (DBUtils.isHiddenObject((Object)child)) continue;
                    if (allObjects) {
                        if (combinedMatch.length() > 0) {
                            combinedMatch.append(", ");
                            if (objPrefix != null) {
                                combinedMatch.append(objPrefix);
                            }
                        }
                        combinedMatch.append(DBUtils.getQuotedIdentifier((DBSObject)child));
                        continue;
                    }
                    if (simpleMode) {
                        if (startPart != null && !this.objectNameMatches(startPart, child, matchContains)) continue;
                        matchedObjects.add(child);
                        continue;
                    }
                    int n = score = CommonUtils.isEmpty((String)startPart) ? 1 : TextUtils.fuzzyScore(child.getName(), startPart);
                    if (score <= 0) continue;
                    matchedObjects.add(child);
                    scoredMatches.put(child.getName(), score);
                }
                if (combinedMatch.length() > 0) {
                    String replaceString = combinedMatch.toString();
                    this.request.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, replaceString, replaceString, DBPKeywordType.OTHER, "All objects"));
                } else if (!matchedObjects.isEmpty()) {
                    if (startPart != null) {
                        if (simpleMode) {
                            matchedObjects.sort(Comparator.comparing(DBPNamedObject::getName));
                        } else {
                            matchedObjects.sort((o1, o2) -> {
                                int score2;
                                int score1 = (Integer)scoredMatches.get(o1.getName());
                                if (score1 == (score2 = ((Integer)scoredMatches.get(o2.getName())).intValue())) {
                                    if (o1 instanceof DBSAttributeBase) {
                                        return ((DBSAttributeBase)o1).getOrdinalPosition() - ((DBSAttributeBase)o2).getOrdinalPosition();
                                    }
                                    return o1.getName().compareTo(o2.getName());
                                }
                                return score2 - score1;
                            });
                        }
                    }
                    for (DBSObject child : matchedObjects) {
                        this.request.proposals.add(this.makeProposalsFromObject(child));
                    }
                }
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
    }

    private boolean objectNameMatches(@Nullable String startPart, DBSObject child, boolean matchContains) {
        String nameCI = child.getName().toUpperCase(Locale.ENGLISH);
        return matchContains ? nameCI.contains(startPart) : nameCI.startsWith(startPart);
    }

    private void makeProposalsFromAssistant(DBPDataSource dataSource, DBSStructureAssistant assistant, @Nullable DBSObjectContainer rootSC, DBSObjectType[] objectTypes, String objectName) {
        try {
            List references = assistant.findObjectsByMask(this.monitor, (DBSObject)rootSC, objectTypes == null ? assistant.getAutoCompleteObjectTypes() : objectTypes, this.makeObjectNameMask(dataSource, this.request.wordDetector.removeQuotes(objectName)), this.request.wordDetector.isQuoted(objectName), dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.use.global.search"), 100);
            for (DBSObjectReference reference : references) {
                this.request.proposals.add(this.makeProposalsFromObject((DBPNamedObject)reference, reference.getObjectType().getImage()));
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
    }

    private String makeObjectNameMask(DBPDataSource dataSource, String objectName) {
        if (dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.matching.contains")) {
            return MATCH_ANY_PATTERN + objectName + MATCH_ANY_PATTERN;
        }
        return String.valueOf(objectName) + MATCH_ANY_PATTERN;
    }

    private SQLCompletionProposal makeProposalsFromObject(DBSObject object) {
        DBNDatabaseNode node = NavigatorUtils.getNodeByObject(this.monitor, object, false);
        return this.makeProposalsFromObject((DBPNamedObject)object, node == null ? null : node.getNodeIconDefault());
    }

    private SQLCompletionProposal makeProposalsFromObject(DBPNamedObject object, @Nullable DBPImage objectIcon) {
        String objectName = DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DML);
        boolean isSingleObject = true;
        String replaceString = null;
        DBPDataSource dataSource = this.request.editor.getDataSource();
        if (dataSource != null) {
            DBSObject selectedObject;
            DBSObjectReference structObject;
            DBPPreferenceStore prefs = this.request.editor.getActivePreferenceStore();
            if (!prefs.getBoolean("SQLEditor.ContentAssistant.proposals.short.name") && object instanceof DBSObjectReference && this.request.wordDetector.getFullWord().indexOf(this.request.editor.getSyntaxManager().getStructSeparator()) == -1 && (structObject = (DBSObjectReference)object).getContainer() != null && (selectedObject = DBUtils.getActiveInstanceObject((DBSInstance)dataSource)) != structObject.getContainer()) {
                replaceString = DBUtils.getFullQualifiedName((DBPDataSource)dataSource, (DBPNamedObject[])new DBPNamedObject[]{structObject.getContainer() instanceof DBPDataSource ? null : structObject.getContainer(), object});
                isSingleObject = false;
            }
            if (replaceString == null) {
                replaceString = prefs.getBoolean("SQLEditor.ContentAssistant.proposals.long.name") && object instanceof DBPQualifiedObject ? ((DBPQualifiedObject)object).getFullyQualifiedName(DBPEvaluationContext.DML) : DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)object.getName());
            }
        } else {
            replaceString = DBUtils.getObjectShortName((Object)object);
        }
        return SQLCompletionAnalyzer.createCompletionProposal(this.request, replaceString, objectName, DBPKeywordType.OTHER, objectIcon, isSingleObject, object);
    }

    static SQLCompletionProposal createCompletionProposal(CompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, @Nullable DBPImage image, boolean isObject, @Nullable DBPNamedObject object) {
        boolean quotedString;
        SQLEditorBase editor = request.editor;
        DBPPreferenceStore store = editor.getActivePreferenceStore();
        DBPDataSource dataSource = editor.getDataSource();
        if (dataSource != null) {
            // empty if block
        }
        if (!(quotedString = request.wordDetector.isQuoted(replaceString))) {
            int proposalCase = store.getInt("SQLEditor.ContentAssistant.insert.case");
            switch (proposalCase) {
                case 1: {
                    replaceString = replaceString.toUpperCase();
                    break;
                }
                case 2: {
                    replaceString = replaceString.toLowerCase();
                    break;
                }
                default: {
                    if (isObject) break;
                    SQLDialect dialect = editor.getSyntaxManager().getDialect();
                    DBPKeywordType keywordType = dialect.getKeywordType(replaceString);
                    replaceString = keywordType == DBPKeywordType.KEYWORD ? editor.getSyntaxManager().getKeywordCase().transform(replaceString) : dialect.storesUnquotedCase().transform(replaceString);
                }
            }
        }
        Image img = image == null ? null : DBeaverIcons.getImage((DBPImage)image);
        return new SQLCompletionProposal(request, displayString, replaceString, replaceString.length(), img, null, proposalType, null, object);
    }

    protected static SQLCompletionProposal createCompletionProposal(CompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, String description) {
        return new SQLCompletionProposal(request, displayString, replaceString, replaceString.length(), null, null, proposalType, description, null);
    }

    static class CompletionRequest {
        final SQLEditorBase editor;
        final boolean simpleMode;
        int documentOffset;
        String activeQuery = null;
        SQLWordPartDetector wordDetector;
        String wordPart;
        SQLCompletionProcessor.QueryType queryType;
        final List<SQLCompletionProposal> proposals = new ArrayList<SQLCompletionProposal>();

        CompletionRequest(SQLEditorBase editor, int documentOffset, boolean simpleMode) {
            this.editor = editor;
            this.documentOffset = documentOffset;
            this.simpleMode = simpleMode;
        }
    }
}

