/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.format.tokenized;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.format.BaseFormatterConfigurationPage;

public class SQLTokenizedConfigurationPage
extends BaseFormatterConfigurationPage {
    private Spinner indentSizeSpinner;
    private Button useSpacesCheck;
    private Button compactFormatCheck;
    private Combo keywordCaseCombo;

    @Override
    protected Composite createFormatSettings(Composite parent, SQLFormatterConfiguration configuration) {
        Group settings = UIUtils.createControlGroup((Composite)parent, (String)"Settings", (int)2, (int)768, (int)0);
        this.keywordCaseCombo = UIUtils.createLabelCombo((Composite)settings, (String)CoreMessages.pref_page_sql_format_label_keyword_case, (int)12);
        this.keywordCaseCombo.setLayoutData((Object)new GridData(32));
        this.keywordCaseCombo.add("Default");
        DBPIdentifierCase[] dBPIdentifierCaseArray = DBPIdentifierCase.values();
        int n = dBPIdentifierCaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPIdentifierCase c = dBPIdentifierCaseArray[n2];
            this.keywordCaseCombo.add(DBPIdentifierCase.capitalizeCaseName((String)c.name()));
            ++n2;
        }
        DBPIdentifierCase keywordCase = configuration.getKeywordCase();
        if (keywordCase == null) {
            this.keywordCaseCombo.select(0);
        } else {
            UIUtils.setComboSelection((Combo)this.keywordCaseCombo, (String)DBPIdentifierCase.capitalizeCaseName((String)keywordCase.name()));
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean useSpaces = preferenceStore.getBoolean("spacesForTabs");
        int tabWidth = preferenceStore.getInt("tabWidth");
        this.indentSizeSpinner = UIUtils.createLabelSpinner((Composite)settings, (String)"Indent size", (String)"Insert spaces for tabs", (int)tabWidth, (int)0, (int)100);
        this.useSpacesCheck = UIUtils.createCheckbox((Composite)settings, (String)"Insert spaces for tabs", (String)"Insert spaces for tabs", (boolean)useSpaces, (int)2);
        this.compactFormatCheck = UIUtils.createCheckbox((Composite)settings, (String)"Compact formatting", (String)"Compact formatting. Less line feeds and indentation", (boolean)false, (int)2);
        return parent;
    }

    @Override
    protected void saveFormatSettings(SQLFormatterConfiguration configuration) {
    }

    private IPreferenceStore getPreferenceStore() {
        return EditorsPlugin.getDefault().getPreferenceStore();
    }
}

