/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreFeatures;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceHandler;
import org.jkiss.dbeaver.model.DBPDataSourceUser;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.IDataSourceContainerProviderEx;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.DefaultServerOutputReader;
import org.jkiss.dbeaver.model.impl.sql.SQLQueryTransformerCount;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLQueryTransformer;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.runtime.sql.SQLQueryJob;
import org.jkiss.dbeaver.runtime.sql.SQLQueryListener;
import org.jkiss.dbeaver.runtime.sql.SQLResultsConsumer;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.CompositeSelectionProvider;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DynamicFindReplaceTarget;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardDialog;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorOutputViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPropertyTester;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.log.SQLLogPanel;
import org.jkiss.dbeaver.ui.views.SQLResultsView;
import org.jkiss.dbeaver.ui.views.plan.ExplainPlanViewer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SQLEditor
extends SQLEditorBase
implements IDataSourceContainerProviderEx,
DBPContextProvider,
DBPEventListener,
ISaveablePart2,
DBPDataSourceUser,
DBPDataSourceHandler,
DBPPreferenceListener {
    private static final long SCRIPT_UI_UPDATE_PERIOD = 100L;
    private static final int MAX_PARALLEL_QUERIES_NO_WARN = 10;
    private static Image IMG_DATA_GRID = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_DATA_GRID);
    private static Image IMG_DATA_GRID_LOCKED = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_DATA_GRID_LOCKED);
    private static Image IMG_EXPLAIN_PLAN = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_EXPLAIN_PLAN);
    private static Image IMG_LOG = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_LOG);
    private static Image IMG_OUTPUT = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_OUTPUT);
    private static Image IMG_OUTPUT_ALERT = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_OUTPUT_ALERT);
    public static final String VAR_CONNECTION_NAME = "connectionName";
    public static final String VAR_FILE_NAME = "fileName";
    public static final String VAR_FILE_EXT = "fileExt";
    public static final String VAR_DRIVER_NAME = "driverName";
    public static final String DEFAULT_TITLE_PATTERN = "<${connectionName}> ${fileName}";
    private ResultSetOrientation resultSetOrientation = ResultSetOrientation.HORIZONTAL;
    private SashForm sashForm;
    private Control editorControl;
    private CTabFolder resultTabs;
    private ToolItem toolOutputItem;
    private SQLLogPanel logViewer;
    private SQLEditorOutputViewer outputViewer;
    private volatile QueryProcessor curQueryProcessor;
    private final List<QueryProcessor> queryProcessors = new ArrayList<QueryProcessor>();
    private DBPDataSourceContainer dataSourceContainer;
    private DBPDataSource curDataSource;
    private volatile DBCExecutionContext executionContext;
    private volatile DBCExecutionContext lastExecutionContext;
    private SQLScriptContext globalScriptContext;
    private volatile boolean syntaxLoaded = false;
    private volatile boolean ownContext = false;
    private final FindReplaceTarget findReplaceTarget = new FindReplaceTarget();
    private final List<SQLQuery> runningQueries = new ArrayList<SQLQuery>();
    private QueryResultsContainer curResultsContainer;
    private Image editorImage;
    private ToolItem toolLogItem;
    private final List<ServerOutputInfo> serverOutputs = new ArrayList<ServerOutputInfo>();

    @Override
    protected String[] getKeyBindingContexts() {
        return new String[]{"org.eclipse.ui.textEditorScope", "org.jkiss.dbeaver.ui.editors.sql", "org.jkiss.dbeaver.ui.editors.sql.script"};
    }

    @Override
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Nullable
    public IProject getProject() {
        IFile file = EditorUtils.getFileFromInput(this.getEditorInput());
        return file == null ? null : file.getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public int[] getCurrentLines() {
        List<SQLQuery> list = this.runningQueries;
        synchronized (list) {
            ArrayList<Integer> lines;
            block11: {
                Document document;
                block10: {
                    document = this.getDocument();
                    if (document != null && !this.runningQueries.isEmpty()) break block10;
                    return null;
                }
                lines = new ArrayList<Integer>(this.runningQueries.size() * 2);
                for (SQLQuery statementInfo : this.runningQueries) {
                    try {
                        int firstLine = document.getLineOfOffset(statementInfo.getOffset());
                        int lastLine = document.getLineOfOffset(statementInfo.getOffset() + statementInfo.getLength());
                        int k = firstLine;
                        while (k <= lastLine) {
                            lines.add(k);
                            ++k;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (!lines.isEmpty()) break block11;
                return null;
            }
            int[] results = new int[lines.size()];
            int i = 0;
            while (i < lines.size()) {
                results[i] = (Integer)lines.get(i);
                ++i;
            }
            return results;
        }
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public boolean setDataSourceContainer(@Nullable DBPDataSourceContainer container) {
        IEditorInput input;
        if (container == this.dataSourceContainer) {
            this.fireDataSourceChange();
            return true;
        }
        this.releaseContainer();
        this.closeAllJobs();
        this.dataSourceContainer = container;
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
            this.dataSourceContainer.getRegistry().addDataSourceListener((DBPEventListener)this);
        }
        if ((input = this.getEditorInput()) != null) {
            EditorUtils.setInputDataSource(input, container, true);
        }
        this.checkConnected(false, status -> UIUtils.asyncExec(() -> {
            if (!status.isOK()) {
                DBUserInterface.getInstance().showError("Can't connect to database", "Error connecting to datasource", status);
            }
            this.setFocus();
        }));
        this.setPartName(this.getEditorName());
        this.fireDataSourceChange();
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.acquire((DBPDataSourceUser)this);
        }
        return true;
    }

    private void updateExecutionContext(final Runnable onSuccess) {
        if (this.dataSourceContainer == null) {
            this.releaseExecutionContext();
        } else {
            DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
            if (dataSource == null) {
                this.releaseExecutionContext();
            } else if (this.curDataSource != dataSource) {
                this.releaseExecutionContext();
                this.curDataSource = dataSource;
                if (this.curDataSource.getContainer().getPreferenceStore().getBoolean("database.editor.separate.connection")) {
                    final OpenContextJob job = new OpenContextJob(dataSource);
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            if (job.error != null) {
                                SQLEditor.this.releaseExecutionContext();
                                DBUserInterface.getInstance().showError("Open context", "Can't open editor connection", job.error);
                            } else {
                                if (onSuccess != null) {
                                    onSuccess.run();
                                }
                                SQLEditor.this.fireDataSourceChange();
                            }
                        }
                    });
                    job.schedule();
                } else {
                    this.executionContext = dataSource.getDefaultContext(false);
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }
            }
        }
        if (this.executionContext != null) {
            SQLScriptContext oldGlobalContext = this.globalScriptContext;
            this.globalScriptContext = new SQLScriptContext(null, this.executionContext, EditorUtils.getLocalFileFromInput(this.getEditorInput()), (Writer)new OutputLogWriter());
            if (oldGlobalContext != null) {
                this.globalScriptContext.copyFrom(oldGlobalContext);
            }
        } else {
            this.globalScriptContext = null;
        }
    }

    private void releaseExecutionContext() {
        if (this.ownContext && this.executionContext != null && this.executionContext.isConnected()) {
            new CloseContextJob(this.executionContext).schedule();
        }
        this.executionContext = null;
        this.ownContext = false;
        this.curDataSource = null;
    }

    private void releaseContainer() {
        this.releaseExecutionContext();
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
            this.dataSourceContainer.getRegistry().removeDataSourceListener((DBPEventListener)this);
            this.dataSourceContainer.release((DBPDataSourceUser)this);
            this.dataSourceContainer = null;
        }
    }

    public boolean isDirty() {
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            if (!queryProcessor.isDirty()) continue;
            return true;
        }
        if (this.ownContext && QMUtils.isTransactionActive((DBCExecutionContext)this.executionContext)) {
            return true;
        }
        if (this.isNonPersistentEditor()) {
            return false;
        }
        return super.isDirty();
    }

    @Override
    @Nullable
    public <T> T getAdapter(Class<T> required) {
        if (required == IFindReplaceTarget.class) {
            return required.cast((Object)this.findReplaceTarget);
        }
        ResultSetViewer resultsView = this.getActiveResultSetViewer();
        if (resultsView != null) {
            if (required == ResultSetViewer.class) {
                return required.cast(resultsView);
            }
            T adapter = resultsView.getAdapter(required);
            if (adapter != null) {
                return adapter;
            }
        }
        return super.getAdapter(required);
    }

    private boolean checkConnected(boolean forceConnect, DBRProgressListener onFinish) {
        boolean doConnect;
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        boolean bl = doConnect = dataSourceContainer != null && (forceConnect || dataSourceContainer.getPreferenceStore().getBoolean("database.editor.connect.on.activate"));
        if (doConnect && !dataSourceContainer.isConnected()) {
            DataSourceHandler.connectToDataSource(null, dataSourceContainer, onFinish);
        }
        return dataSourceContainer != null && dataSourceContainer.isConnected();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.sashForm = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)(this.resultSetOrientation.getSashOrientation() | 0x10000));
        this.sashForm.setSashWidth(5);
        UIUtils.setHelp((Control)this.sashForm, (String)"sql-editor");
        super.createPartControl((Composite)this.sashForm);
        this.editorControl = this.sashForm.getChildren()[0];
        this.getSite().setSelectionProvider((ISelectionProvider)new DynamicSelectionProvider());
        this.createResultTabs();
        this.setAction("ShowInformation", null);
        CoreFeatures.SQL_EDITOR_OPEN.use();
        new ServerOutputReader().schedule();
        this.updateExecutionContext(null);
        UIUtils.asyncExec(this::onDataSourceChange);
    }

    public boolean validateEditorInputState() {
        StyledText textWidget;
        boolean res = super.validateEditorInputState();
        if (res && (textWidget = this.getViewer().getTextWidget()) != null && !textWidget.isDisposed()) {
            textWidget.setFocus();
        }
        return res;
    }

    private void createResultTabs() {
        String[] weights;
        this.resultTabs = new CTabFolder((Composite)this.sashForm, 0x800080);
        this.resultTabs.setLayoutData((Object)new GridData(1808));
        this.resultTabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object data = e.item.getData();
                if (data instanceof QueryResultsContainer) {
                    SQLEditor.this.setActiveResultsContainer((QueryResultsContainer)data);
                }
            }
        });
        this.resultTabs.addListener(11, event -> {
            if (!this.sashForm.isDisposed()) {
                int[] weights = this.sashForm.getWeights();
                IPreferenceStore prefs = this.getPreferenceStore();
                if (prefs != null) {
                    prefs.setValue("SQLEditor.resultSet.ratio", String.valueOf(weights[0]) + "-" + weights[1]);
                }
            }
        });
        String resultsPanelRatio = this.getPreferenceStore().getString("SQLEditor.resultSet.ratio");
        if (!CommonUtils.isEmpty((String)resultsPanelRatio) && (weights = resultsPanelRatio.split("-")).length > 1) {
            this.sashForm.setWeights(new int[]{Integer.parseInt(weights[0]), Integer.parseInt(weights[1])});
        }
        this.getTextViewer().getTextWidget().addTraverseListener(e -> {
            ResultSetViewer viewer;
            if (e.detail == 512 && (viewer = this.getActiveResultSetViewer()) != null && viewer.getActivePresentation().getControl().isVisible()) {
                viewer.getActivePresentation().getControl().setFocus();
                e.doit = false;
                e.detail = 0;
            }
        });
        this.resultTabs.setSimple(true);
        ToolBar rsToolbar = new ToolBar((Composite)this.resultTabs, 131392);
        this.toolLogItem = new ToolItem(rsToolbar, 32);
        this.toolLogItem.setText(CoreMessages.sql_editor_resultset_tool_item_log);
        this.toolLogItem.setToolTipText(ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.show.log", (IServiceLocator)this.getSite(), (boolean)false));
        this.toolLogItem.setImage(IMG_LOG);
        this.toolLogItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLEditor.this.showExecutionLogPanel();
            }
        });
        this.toolOutputItem = new ToolItem(rsToolbar, 32);
        this.toolOutputItem.setText(CoreMessages.sql_editor_resultset_tool_item_output);
        this.toolOutputItem.setToolTipText(ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.show.output", (IServiceLocator)this.getSite(), (boolean)false));
        this.toolOutputItem.setImage(IMG_OUTPUT);
        this.toolOutputItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLEditor.this.toolOutputItem.setImage(IMG_OUTPUT);
                SQLEditor.this.showOutputPanel();
            }
        });
        this.resultTabs.setTopRight((Control)rsToolbar);
        this.resultTabs.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CTabItem item;
                if (e.button == 2 && (item = SQLEditor.this.resultTabs.getItem(new Point(e.x, e.y))) != null && item.getShowClose()) {
                    item.dispose();
                }
            }
        });
        this.resultTabs.addListener(8, event -> {
            if (event.button != 1) {
                return;
            }
            CTabItem selectedItem = this.resultTabs.getItem(new Point(event.getBounds().x, event.getBounds().y));
            if (selectedItem != null && selectedItem == this.resultTabs.getSelection()) {
                this.toggleEditorMaximize();
            }
        });
        this.logViewer = new SQLLogPanel((Composite)this.resultTabs, this);
        this.outputViewer = new SQLEditorOutputViewer(this.getSite(), (Composite)this.resultTabs, 0);
        this.createQueryProcessor(true);
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.resultTabs);
        menuMgr.addMenuListener(manager -> {
            CTabItem activeTab;
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.maximize.result.panel"));
            if (this.resultTabs.getItemCount() > 1) {
                manager.add((IAction)new Action("Close multiple results"){

                    public void run() {
                        SQLEditor.this.closeExtraResultTabs(null);
                    }
                });
            }
            if ((activeTab = this.resultTabs.getSelection()) != null && activeTab.getData() instanceof QueryResultsContainer) {
                if (this.resultTabs.indexOf(activeTab) > 0) {
                    final QueryResultsContainer resultsContainer = (QueryResultsContainer)activeTab.getData();
                    manager.add((IContributionItem)new Separator());
                    final boolean isPinned = resultsContainer.isPinned();
                    manager.add((IAction)new Action(isPinned ? "Unpin tab" : "Pin tab"){

                        public void run() {
                            resultsContainer.setPinned(!isPinned);
                        }
                    });
                }
                manager.add((IAction)new Action("Set tab title"){

                    public void run() {
                        EnterNameDialog dialog = new EnterNameDialog(SQLEditor.this.resultTabs.getShell(), "Tab title", activeTab.getText());
                        if (dialog.open() == 0) {
                            activeTab.setText(dialog.getResult());
                        }
                    }
                });
            }
            if (activeTab != null && activeTab.getShowClose()) {
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.close.tab"));
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.resultTabs.setMenu(menu);
    }

    private void setActiveResultsContainer(QueryResultsContainer data) {
        this.curResultsContainer = data;
        this.curQueryProcessor = this.curResultsContainer.queryProcessor;
        ResultSetViewer rsv = this.curResultsContainer.getResultSetController();
    }

    private void showExtraView(ToolItem toolItem, String name, String toolTip, Image image, Control view) {
        CTabItem item;
        CTabItem[] cTabItemArray = this.resultTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            if (item.getData() == view) {
                if (this.resultTabs.getSelection() == item) {
                    item.dispose();
                    toolItem.setSelection(false);
                    return;
                }
                this.resultTabs.setSelection(item);
                return;
            }
            ++n2;
        }
        if (view == this.outputViewer) {
            this.updateOutputViewerIcon(false);
            this.outputViewer.resetNewOutput();
        }
        toolItem.setSelection(true);
        item = new CTabItem(this.resultTabs, 64);
        item.setControl(view);
        item.setText(name);
        item.setToolTipText(toolTip);
        item.setImage(image);
        item.setData((Object)view);
        item.addDisposeListener(e -> toolItem.setSelection(false));
        this.resultTabs.setSelection(item);
    }

    public void closeActiveTab() {
        CTabItem tabItem = this.resultTabs.getSelection();
        if (tabItem != null && tabItem.getShowClose()) {
            tabItem.dispose();
        }
    }

    public void showOutputPanel() {
        if (this.sashForm.getMaximizedControl() != null) {
            this.sashForm.setMaximizedControl(null);
        }
        this.showExtraView(this.toolOutputItem, CoreMessages.editors_sql_output, "Database server output log", IMG_OUTPUT, (Control)this.outputViewer);
    }

    public void showExecutionLogPanel() {
        if (this.sashForm.getMaximizedControl() != null) {
            this.sashForm.setMaximizedControl(null);
        }
        this.showExtraView(this.toolLogItem, CoreMessages.editors_sql_execution_log, "SQL query execution log", IMG_LOG, (Control)this.logViewer);
    }

    public boolean hasMaximizedControl() {
        return this.sashForm.getMaximizedControl() != null;
    }

    public void toggleResultPanel() {
        if (this.sashForm.getMaximizedControl() == null) {
            this.sashForm.setMaximizedControl(this.editorControl);
            this.switchFocus(false);
        } else {
            this.sashForm.setMaximizedControl(null);
            this.switchFocus(true);
        }
    }

    public void toggleEditorMaximize() {
        if (this.sashForm.getMaximizedControl() == null) {
            this.sashForm.setMaximizedControl((Control)this.resultTabs);
            this.switchFocus(true);
        } else {
            this.sashForm.setMaximizedControl(null);
            this.switchFocus(false);
        }
    }

    private void switchFocus(boolean results) {
        if (results) {
            ResultSetViewer activeRS = this.getActiveResultSetViewer();
            if (activeRS != null && activeRS.getActivePresentation() != null) {
                activeRS.getActivePresentation().getControl().setFocus();
            } else {
                CTabItem activeTab = this.resultTabs.getSelection();
                if (activeTab != null && activeTab.getControl() != null) {
                    activeTab.getControl().setFocus();
                }
            }
        } else {
            this.editorControl.setFocus();
        }
    }

    public void toggleActivePanel() {
        if (this.sashForm.getMaximizedControl() == null) {
            if (UIUtils.hasFocus((Control)this.resultTabs)) {
                this.switchFocus(false);
            } else {
                this.switchFocus(true);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.updateResultSetOrientation();
    }

    private void updateResultSetOrientation() {
        try {
            this.resultSetOrientation = ResultSetOrientation.valueOf(this.getActivePreferenceStore().getString("SQLEditor.resultSet.orientation"));
        }
        catch (IllegalArgumentException e) {
            this.resultSetOrientation = ResultSetOrientation.HORIZONTAL;
        }
        if (this.sashForm != null) {
            this.sashForm.setOrientation(this.resultSetOrientation.getSashOrientation());
        }
    }

    @Override
    protected void doSetInput(IEditorInput editorInput) throws CoreException {
        try {
            IFile file;
            if (editorInput instanceof IFileEditorInput && !(file = ((IFileEditorInput)editorInput).getFile()).exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error checking SQL file", (Throwable)e);
        }
        try {
            super.doSetInput(editorInput);
        }
        catch (Throwable e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)out, true));
            editorInput = new StringEditorInput("Error", CommonUtils.truncateString((String)out.toString(), (int)10000), true, "UTF-8");
            this.doSetInput(editorInput);
            log.error((Object)"Error loading input SQL file", e);
        }
        this.syntaxLoaded = false;
        this.setDataSourceContainer(EditorUtils.getInputDataSource(editorInput));
        this.setPartName(this.getEditorName());
        if (this.isNonPersistentEditor()) {
            this.setTitleImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_CONSOLE));
        }
        this.editorImage = this.getTitleImage();
    }

    public String getTitleToolTip() {
        String scriptPath;
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (dataSourceContainer == null) {
            return super.getTitleToolTip();
        }
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            scriptPath = ((IFileEditorInput)editorInput).getFile().getFullPath().toString();
        } else if (editorInput instanceof IPathEditorInput) {
            scriptPath = ((IPathEditorInput)editorInput).getPath().toString();
        } else if (editorInput instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)editorInput).getURI();
            scriptPath = "file".equals(uri.getScheme()) ? new File(uri).getAbsolutePath() : uri.toString();
        } else if (editorInput instanceof INonPersistentEditorInput) {
            scriptPath = "SQL Console";
        } else {
            scriptPath = editorInput.getName();
            if (CommonUtils.isEmpty((String)scriptPath)) {
                scriptPath = "<not a file>";
            }
        }
        return "Script: " + scriptPath + " \nConnection: " + dataSourceContainer.getName() + " \nType: " + dataSourceContainer.getDriver().getFullName() + " \nURL: " + dataSourceContainer.getConnectionConfiguration().getUrl();
    }

    private String getEditorName() {
        String scriptName;
        IFile file = EditorUtils.getFileFromInput(this.getEditorInput());
        if (file != null) {
            scriptName = file.getFullPath().removeFileExtension().lastSegment();
        } else {
            File localFile = EditorUtils.getLocalFileFromInput(this.getEditorInput());
            if (localFile != null) {
                return localFile.getName();
            }
            scriptName = this.getEditorInput().getName();
        }
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        DBPPreferenceStore preferenceStore = this.getActivePreferenceStore();
        String pattern = preferenceStore.getString("script.title.pattern");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(VAR_CONNECTION_NAME, dataSourceContainer == null ? "none" : dataSourceContainer.getName());
        vars.put(VAR_FILE_NAME, scriptName);
        vars.put(VAR_FILE_EXT, file == null ? "" : file.getFullPath().getFileExtension());
        vars.put(VAR_DRIVER_NAME, dataSourceContainer == null ? "?" : dataSourceContainer.getDriver().getFullName());
        return GeneralUtils.replaceVariables((String)pattern, (GeneralUtils.IVariableResolver)new GeneralUtils.MapResolver(vars));
    }

    public void setFocus() {
        super.setFocus();
    }

    public void explainQueryPlan() {
        SQLScriptElement scriptElement = this.extractActiveQuery();
        if (scriptElement == null) {
            this.setStatus(CoreMessages.editors_sql_status_empty_query_string, DBPMessageType.ERROR);
            return;
        }
        if (!(scriptElement instanceof SQLQuery)) {
            this.setStatus("Can't explain plan for command", DBPMessageType.ERROR);
            return;
        }
        this.explainQueryPlan((SQLQuery)scriptElement);
    }

    private void explainQueryPlan(SQLQuery sqlQuery) {
        CTabItem item;
        DBCQueryPlanner planner = (DBCQueryPlanner)DBUtils.getAdapter(DBCQueryPlanner.class, (Object)this.getDataSource());
        if (planner == null) {
            DBUserInterface.getInstance().showError("Execution plan", "Execution plan explain isn't supported by current datasource");
            return;
        }
        DBCPlanStyle planStyle = planner.getPlanStyle();
        if (planStyle == DBCPlanStyle.QUERY) {
            this.explainPlanFromQuery(planner, sqlQuery);
            return;
        }
        ExplainPlanViewer planView = null;
        CTabItem[] cTabItemArray = this.resultTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExplainPlanViewer pv;
            item = cTabItemArray[n2];
            if (item.getData() instanceof ExplainPlanViewer && (pv = (ExplainPlanViewer)item.getData()).getQuery() != null && pv.getQuery().equals((Object)sqlQuery)) {
                this.resultTabs.setSelection(item);
                planView = pv;
                break;
            }
            ++n2;
        }
        if (planView == null) {
            planView = new ExplainPlanViewer((IWorkbenchPart)this, (Composite)this.resultTabs);
            item = new CTabItem(this.resultTabs, 64);
            item.setControl(planView.getControl());
            item.setText("Exec. Plan");
            item.setToolTipText("Execution plan for\n" + sqlQuery.getText());
            item.setImage(IMG_EXPLAIN_PLAN);
            item.setData((Object)planView);
            UIUtils.disposeControlOnItemDispose((CTabItem)item);
            this.resultTabs.setSelection(item);
        }
        try {
            planView.explainQueryPlan(this.getExecutionContext(), sqlQuery);
        }
        catch (DBCException e) {
            DBUserInterface.getInstance().showError(CoreMessages.editors_sql_error_execution_plan_title, CoreMessages.editors_sql_error_execution_plan_message, (Throwable)e);
        }
    }

    private void explainPlanFromQuery(DBCQueryPlanner planner, SQLQuery sqlQuery) {
        String[] planQueryString = new String[1];
        DBRRunnableWithProgress queryObtainTask = monitor -> {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (DBCSession session = this.executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Prepare plan query");){
                    DBCPlan plan = planner.planQueryExecution(session, sqlQuery.getText());
                    stringArray[0] = plan.getPlanQueryString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        };
        if (RuntimeUtils.runTask((DBRRunnableWithProgress)queryObtainTask, (String)"Retrieve plan query", (long)5000L) && !CommonUtils.isEmpty((String)planQueryString[0])) {
            SQLQuery planQuery = new SQLQuery(this.getDataSource(), planQueryString[0]);
            this.processQueries(Collections.singletonList(planQuery), true, false, true, null);
        }
    }

    public void processSQL(boolean newTab, boolean script) {
        this.processSQL(newTab, script, null, null);
    }

    public void processSQL(boolean newTab, boolean script, SQLQueryTransformer transformer, @Nullable SQLQueryListener queryListener) {
        List<SQLScriptElement> elements;
        Document document = this.getDocument();
        if (document == null) {
            this.setStatus(CoreMessages.editors_sql_status_cant_obtain_document, DBPMessageType.ERROR);
            return;
        }
        if (script) {
            ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
            elements = selection.getLength() > 1 ? this.extractScriptQueries(selection.getOffset(), selection.getLength(), true, false, true) : this.extractScriptQueries(0, document.getLength(), true, false, true);
        } else {
            SQLScriptElement sqlQuery = this.extractActiveQuery();
            if (sqlQuery == null) {
                DBUserInterface.getInstance().showError(CoreMessages.editors_sql_status_empty_query_string, CoreMessages.editors_sql_status_empty_query_string);
                return;
            }
            elements = Collections.singletonList(sqlQuery);
        }
        try {
            DBPDataSource dataSource;
            if (transformer != null && (dataSource = this.getDataSource()) instanceof SQLDataSource) {
                ArrayList<SQLScriptElement> xQueries = new ArrayList<SQLScriptElement>(elements.size());
                for (SQLScriptElement element : elements) {
                    if (element instanceof SQLQuery) {
                        SQLQuery query = transformer.transformQuery((SQLDataSource)dataSource, this.getSyntaxManager(), (SQLQuery)element);
                        if (!CommonUtils.isEmpty((Collection)query.getParameters())) {
                            query.setParameters(this.parseParameters(query.getText()));
                        }
                        xQueries.add((SQLScriptElement)query);
                        continue;
                    }
                    xQueries.add(element);
                }
                elements = xQueries;
            }
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("Bad query", "Can't execute query", (Throwable)e);
            return;
        }
        this.processQueries(elements, newTab, false, true, queryListener);
    }

    public void exportDataFromQuery() {
        SQLScriptElement sqlQuery = this.extractActiveQuery();
        if (sqlQuery instanceof SQLQuery) {
            this.processQueries(Collections.singletonList(sqlQuery), false, true, true, null);
        } else {
            DBUserInterface.getInstance().showError("Extract data", "Can't extract data from control command");
        }
    }

    private void processQueries(@NotNull List<SQLScriptElement> queries, boolean newTab, boolean export, boolean checkSession, @Nullable SQLQueryListener queryListener) {
        boolean isSingleQuery;
        if (queries.isEmpty()) {
            return;
        }
        DBPDataSourceContainer container = this.getDataSourceContainer();
        if (checkSession) {
            try {
                DBRProgressListener connectListener = status -> {
                    if (!status.isOK() || container == null || !container.isConnected()) {
                        DBUserInterface.getInstance().showError(CoreMessages.editors_sql_error_cant_obtain_session, null, status);
                        return;
                    }
                    this.updateExecutionContext(() -> UIUtils.syncExec(() -> this.processQueries(queries, newTab, export, false, queryListener)));
                };
                if (!this.checkSession(connectListener)) {
                    return;
                }
            }
            catch (DBException ex) {
                ResultSetViewer viewer = this.getActiveResultSetViewer();
                if (viewer != null) {
                    viewer.setStatus(ex.getMessage(), DBPMessageType.ERROR);
                }
                DBUserInterface.getInstance().showError(CoreMessages.editors_sql_error_cant_obtain_session, ex.getMessage());
                return;
            }
        }
        if (this.dataSourceContainer == null) {
            return;
        }
        boolean bl = isSingleQuery = queries.size() == 1;
        if (isSingleQuery && queries.get(0) instanceof SQLQuery) {
            SQLQuery query = (SQLQuery)queries.get(0);
            if (query.isDeleteUpdateDangerous()) {
                String targetName = "multiple tables";
                if (query.getSingleSource() != null) {
                    targetName = query.getSingleSource().getEntityName();
                }
                if (ConfirmationDialog.showConfirmDialogEx(this.getSite().getShell(), "dangerous_sql", 5, 4, query.getType().name(), targetName) != 0) {
                    return;
                }
            }
        } else if (newTab && queries.size() > 10 && ConfirmationDialog.showConfirmDialogEx(this.getSite().getShell(), "mass_parallel_sql", 5, 4, queries.size()) != 0) {
            return;
        }
        if (this.sashForm.getMaximizedControl() != null) {
            this.sashForm.setMaximizedControl(null);
        }
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnExecute") && this.isDirty()) {
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        if (!newTab || !isSingleQuery) {
            this.closeExtraResultTabs(null);
        }
        if (newTab) {
            int i = 0;
            while (i < queries.size()) {
                SQLScriptElement query = queries.get(i);
                QueryProcessor queryProcessor = i == 0 && !isSingleQuery ? this.curQueryProcessor : this.createQueryProcessor(queries.size() == 1);
                queryProcessor.processQueries(Collections.singletonList(query), true, export, this.getActivePreferenceStore().getBoolean("SQLEditor.resultSet.closeOnError"), queryListener);
                ++i;
            }
        } else {
            CTabItem selectedTab;
            QueryResultsContainer firstResults = this.curQueryProcessor.getFirstResults();
            if (firstResults.isPinned()) {
                this.curQueryProcessor = this.queryProcessors.get(0);
            }
            this.closeExtraResultTabs(this.curQueryProcessor);
            if (firstResults.tabItem != null && ((selectedTab = this.resultTabs.getSelection()) == null || selectedTab.getData() != this.outputViewer)) {
                this.resultTabs.setSelection(firstResults.tabItem);
            }
            this.curQueryProcessor.processQueries(queries, false, export, false, queryListener);
        }
    }

    private void setStatus(String status, DBPMessageType messageType) {
        ResultSetViewer resultsView = this.getActiveResultSetViewer();
        if (resultsView != null) {
            resultsView.setStatus(status, messageType);
        }
    }

    private void closeExtraResultTabs(@Nullable QueryProcessor queryProcessor) {
        int i = this.resultTabs.getItemCount() - 1;
        while (i > 0) {
            CTabItem item = this.resultTabs.getItem(i);
            if (item.getData() instanceof QueryResultsContainer && item.getShowClose()) {
                QueryResultsContainer resultsProvider = (QueryResultsContainer)item.getData();
                if (!(queryProcessor != null && queryProcessor != resultsProvider.queryProcessor || queryProcessor != null && queryProcessor.resultContainers.size() < 2)) {
                    item.dispose();
                }
            }
            --i;
        }
    }

    private boolean checkSession(DBRProgressListener onFinish) throws DBException {
        DBPDataSourceContainer ds = this.getDataSourceContainer();
        if (ds == null) {
            throw new DBException("No active connection");
        }
        if (!ds.isConnected()) {
            boolean doConnect = ds.getPreferenceStore().getBoolean("database.editor.connect.on.execute");
            if (doConnect) {
                return this.checkConnected(true, onFinish);
            }
            throw new DBException("Disconnected from database");
        }
        return true;
    }

    private void fireDataSourceChange() {
        this.updateExecutionContext(null);
        UIUtils.syncExec(this::onDataSourceChange);
    }

    private void onDataSourceChange() {
        ResultSetViewer rsv;
        if (this.sashForm == null || this.sashForm.isDisposed()) {
            this.reloadSyntaxRules();
            return;
        }
        DatabaseEditorUtils.setPartBackground((IEditorPart)this, (Composite)this.sashForm);
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (this.syntaxLoaded && this.lastExecutionContext == executionContext) {
            return;
        }
        if (this.curResultsContainer != null && (rsv = this.curResultsContainer.getResultSetController()) != null) {
            if (executionContext == null) {
                rsv.setStatus(CoreMessages.editors_sql_status_not_connected_to_database);
            } else {
                rsv.setStatus(String.valueOf(CoreMessages.editors_sql_staus_connected_to) + executionContext.getDataSource().getContainer().getName() + "'");
            }
        }
        SQLEditorPropertyTester.firePropertyChange("canExecute");
        SQLEditorPropertyTester.firePropertyChange("canExplain");
        this.reloadSyntaxRules();
        if (this.getDataSourceContainer() == null) {
            this.sashForm.setMaximizedControl(this.editorControl);
        } else {
            this.sashForm.setMaximizedControl(null);
        }
        this.lastExecutionContext = executionContext;
        this.syntaxLoaded = true;
    }

    public void beforeConnect() {
    }

    public void beforeDisconnect() {
        this.closeAllJobs();
    }

    @Override
    public void dispose() {
        this.releaseContainer();
        this.closeAllJobs();
        IEditorInput editorInput = this.getEditorInput();
        IFile sqlFile = EditorUtils.getFileFromInput(editorInput);
        this.logViewer = null;
        this.outputViewer = null;
        this.queryProcessors.clear();
        this.curResultsContainer = null;
        this.curQueryProcessor = null;
        super.dispose();
        if (sqlFile != null && !PlatformUI.getWorkbench().isClosing()) {
            this.deleteFileIfEmpty(sqlFile);
        }
    }

    private void deleteFileIfEmpty(IFile sqlFile) {
        if (sqlFile == null || !sqlFile.exists()) {
            return;
        }
        SQLPreferenceConstants.EmptyScriptCloseBehavior emptyScriptCloseBehavior = SQLPreferenceConstants.EmptyScriptCloseBehavior.getByName(this.getActivePreferenceStore().getString("script.delete.empty"));
        if (emptyScriptCloseBehavior == SQLPreferenceConstants.EmptyScriptCloseBehavior.NOTHING) {
            return;
        }
        File osFile = sqlFile.getLocation().toFile();
        if (!osFile.exists() || osFile.length() != 0L) {
            return;
        }
        try {
            Object[] fileHistory;
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (emptyScriptCloseBehavior == SQLPreferenceConstants.EmptyScriptCloseBehavior.DELETE_NEW && !ArrayUtils.isEmpty((Object[])(fileHistory = sqlFile.getHistory((IProgressMonitor)monitor)))) {
                Object[] objectArray = fileHistory;
                int n = fileHistory.length;
                int n2 = 0;
                while (n2 < n) {
                    block17: {
                        Object historyItem = objectArray[n2];
                        Throwable throwable = null;
                        Object var11_13 = null;
                        try (InputStream contents = historyItem.getContents();){
                            int cValue = contents.read();
                            if (cValue == -1) break block17;
                            return;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    ++n2;
                }
            }
            log.debug((Object)("Delete empty SQL script '" + sqlFile.getFullPath().toOSString() + "'"));
            sqlFile.delete(true, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            log.error((Object)"Can't delete empty script file", (Throwable)e);
        }
    }

    private void closeAllJobs() {
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            queryProcessor.closeJob();
        }
    }

    private int getTotalQueryRunning() {
        int jobsRunning = 0;
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            jobsRunning += queryProcessor.curJobRunning.get();
        }
        return jobsRunning;
    }

    public void handleDataSourceEvent(DBPEvent event) {
        boolean objectEvent;
        boolean dsEvent = event.getObject() == this.getDataSourceContainer();
        boolean bl = objectEvent = event.getObject().getDataSource() == this.getDataSource();
        if (dsEvent || objectEvent) {
            UIUtils.asyncExec(() -> {
                switch (event.getAction()) {
                    case OBJECT_REMOVE: {
                        if (!dsEvent) break;
                        this.setDataSourceContainer(null);
                        break;
                    }
                    case OBJECT_SELECT: {
                        if (!objectEvent) break;
                        this.firePropertyChange(1);
                        break;
                    }
                }
                this.updateExecutionContext(null);
                this.onDataSourceChange();
            });
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (!EditorUtils.isInAutoSaveJob()) {
            monitor.beginTask("Save data changes...", 1);
            try {
                monitor.subTask("Save '" + this.getPartName() + "' changes...");
                SaveJob saveJob = new SaveJob();
                saveJob.schedule();
                UIUtils.waitJobCompletion((AbstractJob)saveJob);
                if (!saveJob.success.booleanValue()) {
                    monitor.setCanceled(true);
                    return;
                }
            }
            finally {
                monitor.done();
            }
        }
        super.doSave(monitor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.saveToExternalFile();
    }

    public int promptToSaveOnClose() {
        int jobsRunning = this.getTotalQueryRunning();
        if (jobsRunning > 0) {
            log.warn((Object)("There are " + jobsRunning + " SQL job(s) still running in the editor"));
        }
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            for (QueryResultsContainer resultsProvider : queryProcessor.getResultContainers()) {
                ResultSetViewer rsv = resultsProvider.getResultSetController();
                if (rsv == null || !rsv.isDirty()) continue;
                return rsv.promptToSaveOnClose();
            }
        }
        if (!DataSourceHandler.checkAndCloseActiveTransaction(new DBCExecutionContext[]{this.executionContext})) {
            return 2;
        }
        if (this.isNonPersistentEditor()) {
            return 1;
        }
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnClose")) {
            return 0;
        }
        return 3;
    }

    @Override
    protected void afterSaveToFile(File saveFile) {
        try {
            IFileStore fileStore = EFS.getStore((URI)saveFile.toURI());
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            EditorUtils.setInputDataSource((IEditorInput)input, this.getDataSourceContainer(), false);
            this.init(this.getEditorSite(), (IEditorInput)input);
        }
        catch (CoreException e) {
            DBUserInterface.getInstance().showError("File save", "Can't open SQL editor from external file", (Throwable)e);
        }
    }

    @Nullable
    private ResultSetViewer getActiveResultSetViewer() {
        if (this.curResultsContainer != null) {
            return this.curResultsContainer.getResultSetController();
        }
        return null;
    }

    private void showScriptPositionRuler(boolean show) {
        IColumnSupport columnSupport = this.getAdapter(IColumnSupport.class);
        if (columnSupport != null) {
            RulerColumnDescriptor positionColumn = RulerColumnRegistry.getDefault().getColumnDescriptor("org.jkiss.dbeaver.ui.editors.columns.script.position");
            columnSupport.setColumnVisible(positionColumn, show);
        }
    }

    private void showStatementInEditor(SQLQuery query, boolean select) {
        UIUtils.runUIJob((String)"Select SQL query in editor", monitor -> {
            if (this.isDisposed()) {
                return;
            }
            if (select) {
                this.selectAndReveal(query.getOffset(), query.getLength());
                this.setStatus(query.getText(), DBPMessageType.INFORMATION);
            } else {
                this.getSourceViewer().revealRange(query.getOffset(), query.getLength());
            }
        });
    }

    @Override
    public void reloadSyntaxRules() {
        super.reloadSyntaxRules();
        if (this.outputViewer != null) {
            this.outputViewer.refreshStyles();
        }
    }

    private QueryProcessor createQueryProcessor(boolean setSelection) {
        QueryProcessor queryProcessor;
        this.curQueryProcessor = queryProcessor = new QueryProcessor();
        this.curResultsContainer = queryProcessor.getFirstResults();
        if (setSelection && this.curResultsContainer.tabItem != null) {
            this.resultTabs.setSelection(this.curResultsContainer.tabItem);
        }
        return queryProcessor;
    }

    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        switch (event.getProperty()) {
            case "sql.parameter.prefix": 
            case "sql.variables.enabled": 
            case "script.sql.ignoreNativeDelimiter": 
            case "sql.parameter.anonymous.enabled": 
            case "sql.parameter.enabled": 
            case "script.sql.delimiter.blank": 
            case "script.sql.delimiter": 
            case "sql.parameter.mark": {
                this.reloadSyntaxRules();
                break;
            }
            case "SQLEditor.resultSet.orientation": {
                this.updateResultSetOrientation();
            }
        }
    }

    private String getResultsTabName(int resultSetNumber, int queryIndex, String name) {
        String tabName = name;
        if (CommonUtils.isEmpty((String)tabName)) {
            tabName = CoreMessages.editors_sql_data_grid;
        }
        if (resultSetNumber > 0) {
            tabName = String.valueOf(tabName) + " - " + (resultSetNumber + 1);
        } else if (queryIndex > 0) {
            tabName = String.valueOf(tabName) + " - " + (queryIndex + 1);
        }
        return tabName;
    }

    public void updateDirtyFlag() {
        this.firePropertyChange(257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpQueryServerOutput(@Nullable SQLQueryResult result) {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null) {
            DBPDataSource dataSource = executionContext.getDataSource();
            DBCServerOutputReader outputReader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)dataSource);
            if (outputReader == null && result != null) {
                outputReader = new DefaultServerOutputReader();
            }
            if (outputReader != null && outputReader.isServerOutputEnabled()) {
                List<ServerOutputInfo> list = this.serverOutputs;
                synchronized (list) {
                    this.serverOutputs.add(new ServerOutputInfo(outputReader, executionContext, result));
                }
            }
        }
    }

    private void runPostExecuteActions(@Nullable SQLQueryResult result) {
        final DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null) {
            DBSObjectSelector objectSelector;
            DBPDataSource dataSource = executionContext.getDataSource();
            if ((result == null || !result.hasError() && this.getActivePreferenceStore().getBoolean("SQLEditor.refreshDefaultsAfterExecute")) && (objectSelector = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)dataSource)) != null) {
                new AbstractJob("Refresh default object"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        try {
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Refresh default object");){
                                objectSelector.refreshDefaultObject(session);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    private void updateOutputViewerIcon(boolean alert) {
        Image image = alert ? IMG_OUTPUT_ALERT : IMG_OUTPUT;
        CTabItem outputItem = UIUtils.getTabItem((CTabFolder)this.resultTabs, (Object)((Object)this.outputViewer));
        if (outputItem != null && outputItem != this.resultTabs.getSelection()) {
            outputItem.setImage(image);
        } else {
            this.toolOutputItem.setImage(image);
        }
    }

    private class CloseContextJob
    extends AbstractJob {
        private final DBCExecutionContext context;

        CloseContextJob(DBCExecutionContext context) {
            super("Close context " + context.getContextName());
            this.context = context;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            monitor.beginTask("Close SQLEditor isolated connection", 1);
            try {
                if (QMUtils.isTransactionActive((DBCExecutionContext)this.context)) {
                    DataSourceHandler.closeActiveTransaction(monitor, this.context, true);
                }
                monitor.subTask("Close context " + this.context.getContextName());
                this.context.close();
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    private class DynamicSelectionProvider
    extends CompositeSelectionProvider {
        private boolean lastFocusInEditor = true;

        private DynamicSelectionProvider() {
        }

        public ISelectionProvider getProvider() {
            boolean focusInEditor;
            ResultSetViewer rsv = SQLEditor.this.getActiveResultSetViewer();
            TextViewer textViewer = SQLEditor.this.getTextViewer();
            boolean bl = focusInEditor = textViewer != null && textViewer.getTextWidget().isFocusControl();
            if (!focusInEditor) {
                focusInEditor = rsv != null && rsv.getActivePresentation().getControl().isFocusControl() ? false : this.lastFocusInEditor;
            }
            this.lastFocusInEditor = focusInEditor;
            if (!focusInEditor && rsv != null) {
                return rsv;
            }
            if (textViewer != null) {
                return textViewer.getSelectionProvider();
            }
            return null;
        }
    }

    private class FindReplaceTarget
    extends DynamicFindReplaceTarget {
        private boolean lastFocusInEditor = true;

        private FindReplaceTarget() {
        }

        public IFindReplaceTarget getTarget() {
            boolean focusInEditor;
            ResultSetViewer rsv = SQLEditor.this.getActiveResultSetViewer();
            TextViewer textViewer = SQLEditor.this.getTextViewer();
            boolean bl = focusInEditor = textViewer != null && textViewer.getTextWidget().isFocusControl();
            if (!focusInEditor) {
                focusInEditor = rsv != null && rsv.getActivePresentation().getControl().isFocusControl() ? false : this.lastFocusInEditor;
            }
            this.lastFocusInEditor = focusInEditor;
            if (!focusInEditor && rsv != null) {
                IFindReplaceTarget nested = rsv.getAdapter(IFindReplaceTarget.class);
                if (nested != null) {
                    return nested;
                }
            } else if (textViewer != null) {
                return textViewer.getFindReplaceTarget();
            }
            return null;
        }
    }

    private class OpenContextJob
    extends AbstractJob {
        private final DBPDataSource dataSource;
        private Throwable error;

        OpenContextJob(DBPDataSource dataSource) {
            super("Open connection to " + dataSource.getContainer().getName());
            this.dataSource = dataSource;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            monitor.beginTask("Open SQLEditor isolated connection", 1);
            try {
                try {
                    String title = "SQLEditor <" + SQLEditor.this.getEditorInput().getName() + ">";
                    monitor.subTask("Open context " + title);
                    SQLEditor.this.executionContext = this.dataSource.openIsolatedContext(monitor, title);
                }
                catch (DBException e) {
                    this.error = e;
                    IStatus iStatus = Status.OK_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            SQLEditor.this.ownContext = true;
            return Status.OK_STATUS;
        }
    }

    private class OutputLogWriter
    extends Writer {
        private OutputLogWriter() {
        }

        @Override
        public void write(@NotNull char[] cbuf, int off, int len) throws IOException {
            UIUtils.syncExec(() -> {
                if (!SQLEditor.this.outputViewer.isDisposed()) {
                    SQLEditor.this.outputViewer.getOutputWriter().write(cbuf, off, len);
                    SQLEditor.this.outputViewer.scrollToEnd();
                    if (!SQLEditor.this.outputViewer.isVisible()) {
                        SQLEditor.this.updateOutputViewerIcon(true);
                    }
                }
            });
        }

        @Override
        public void flush() throws IOException {
            SQLEditor.this.outputViewer.getOutputWriter().flush();
        }

        @Override
        public void close() throws IOException {
        }
    }

    public class QueryProcessor
    implements SQLResultsConsumer {
        private volatile SQLQueryJob curJob;
        private AtomicInteger curJobRunning = new AtomicInteger(0);
        private final List<QueryResultsContainer> resultContainers = new ArrayList<QueryResultsContainer>();
        private volatile DBDDataReceiver curDataReceiver = null;

        QueryProcessor() {
            SQLEditor.this.queryProcessors.add(this);
            this.createResultsProvider(0);
        }

        private QueryResultsContainer createResultsProvider(int resultSetNumber) {
            QueryResultsContainer resultsProvider = new QueryResultsContainer(this, resultSetNumber);
            this.resultContainers.add(resultsProvider);
            return resultsProvider;
        }

        private QueryResultsContainer createResultsProvider(DBSDataContainer dataContainer) {
            QueryResultsContainer resultsProvider = new QueryResultsContainer(this, this.resultContainers.size(), dataContainer);
            this.resultContainers.add(resultsProvider);
            return resultsProvider;
        }

        @NotNull
        QueryResultsContainer getFirstResults() {
            return this.resultContainers.get(0);
        }

        @Nullable
        QueryResultsContainer getResults(SQLQuery query) {
            for (QueryResultsContainer provider : this.resultContainers) {
                if (provider.query != query) continue;
                return provider;
            }
            return null;
        }

        List<QueryResultsContainer> getResultContainers() {
            return this.resultContainers;
        }

        private void closeJob() {
            SQLQueryJob job = this.curJob;
            if (job != null) {
                if (job.getState() == 4) {
                    job.cancel();
                }
                this.curJob.closeJob();
                this.curJob = null;
            }
        }

        void processQueries(List<SQLScriptElement> queries, boolean fetchResults, boolean export, boolean closeTabOnError, SQLQueryListener queryListener) {
            if (queries.isEmpty()) {
                return;
            }
            if (this.curJobRunning.get() > 0) {
                DBUserInterface.getInstance().showError(CoreMessages.editors_sql_error_cant_execute_query_title, CoreMessages.editors_sql_error_cant_execute_query_message);
                return;
            }
            DBCExecutionContext executionContext = SQLEditor.this.getExecutionContext();
            if (executionContext == null) {
                DBUserInterface.getInstance().showError(CoreMessages.editors_sql_error_cant_execute_query_title, CoreMessages.editors_sql_status_not_connected_to_database);
                return;
            }
            boolean isSingleQuery = queries.size() == 1;
            SQLEditor.this.showScriptPositionRuler(true);
            QueryResultsContainer resultsContainer = this.getFirstResults();
            SQLEditorQueryListener listener = new SQLEditorQueryListener(this, closeTabOnError);
            if (queryListener != null) {
                listener.setExtListener(queryListener);
            }
            File localFile = EditorUtils.getLocalFileFromInput(SQLEditor.this.getEditorInput());
            SQLQueryJob job = new SQLQueryJob(SQLEditor.this.getSite(), isSingleQuery ? CoreMessages.editors_sql_job_execute_query : CoreMessages.editors_sql_job_execute_script, executionContext, resultsContainer, queries, new SQLScriptContext(SQLEditor.this.globalScriptContext, executionContext, localFile, (Writer)new OutputLogWriter()), this, listener);
            if (export || isSingleQuery) {
                resultsContainer.query = queries.get(0);
            }
            if (export) {
                resultsContainer.lastGoodQuery = null;
                this.curJob = job;
                ActiveWizardDialog dialog = new ActiveWizardDialog(SQLEditor.this.getSite().getWorkbenchWindow(), (IWizard)new DataTransferWizard(new IDataTransferProducer[]{new DatabaseTransferProducer(resultsContainer, null)}, null), (IStructuredSelection)new StructuredSelection((Object)this));
                dialog.open();
            } else if (isSingleQuery) {
                this.closeJob();
                this.curJob = job;
                ResultSetViewer rsv = resultsContainer.getResultSetController();
                if (rsv != null) {
                    rsv.resetDataFilter(false);
                    rsv.resetHistory();
                    rsv.refresh();
                }
            } else {
                if (fetchResults) {
                    job.setFetchResultSets(true);
                }
                job.schedule();
                this.curJob = job;
            }
        }

        public boolean isDirty() {
            for (QueryResultsContainer resultsProvider : this.resultContainers) {
                ResultSetViewer rsv = resultsProvider.getResultSetController();
                if (rsv == null || !rsv.isDirty()) continue;
                return true;
            }
            return false;
        }

        void removeResults(QueryResultsContainer resultsContainer) {
            if (this.resultContainers.size() > 1) {
                this.resultContainers.remove(resultsContainer);
            } else {
                SQLEditor.this.queryProcessors.remove(this);
                if (SQLEditor.this.curQueryProcessor == this) {
                    if (SQLEditor.this.queryProcessors.isEmpty()) {
                        SQLEditor.this.curQueryProcessor = null;
                        SQLEditor.this.curResultsContainer = null;
                    } else {
                        SQLEditor.this.curQueryProcessor = (QueryProcessor)SQLEditor.this.queryProcessors.get(0);
                        SQLEditor.this.curResultsContainer = SQLEditor.this.curQueryProcessor.getFirstResults();
                    }
                }
            }
        }

        @Override
        @Nullable
        public DBDDataReceiver getDataReceiver(SQLQuery statement, int resultSetNumber) {
            boolean isStatsResult;
            if (this.curDataReceiver != null) {
                return this.curDataReceiver;
            }
            boolean bl = isStatsResult = statement != null && statement.getData() == SQLQueryJob.STATS_RESULTS;
            if (resultSetNumber >= this.resultContainers.size() && !SQLEditor.this.isDisposed()) {
                UIUtils.syncExec(() -> {
                    QueryResultsContainer queryResultsContainer = this.createResultsProvider(resultSetNumber);
                });
            }
            if (resultSetNumber >= this.resultContainers.size()) {
                return null;
            }
            QueryResultsContainer resultsProvider = this.resultContainers.get(resultSetNumber);
            UIUtils.syncExec(() -> {
                if (statement != null && !SQLEditor.this.resultTabs.isDisposed()) {
                    resultsProvider.query = (SQLScriptElement)statement;
                    resultsProvider.lastGoodQuery = (SQLScriptElement)statement;
                    String tabName = null;
                    String toolTip = CommonUtils.truncateString((String)statement.getText(), (int)1000);
                    if (isStatsResult) {
                        tabName = "Statistics";
                        int queryIndex = SQLEditor.this.queryProcessors.indexOf(this);
                        if (queryIndex > 0) {
                            tabName = String.valueOf(tabName) + " - " + (queryIndex + 1);
                        }
                    }
                    resultsProvider.updateResultsName(tabName, toolTip);
                }
            });
            ResultSetViewer rsv = resultsProvider.getResultSetController();
            return rsv == null ? null : rsv.getDataReceiver();
        }
    }

    public class QueryResultsContainer
    implements DBSDataContainer,
    IResultSetContainer,
    IResultSetListener,
    IDataSourceContainerProvider {
        private final QueryProcessor queryProcessor;
        private final CTabItem tabItem;
        private final ResultSetViewer viewer;
        private final int resultSetNumber;
        private SQLScriptElement query = null;
        private SQLScriptElement lastGoodQuery = null;
        private DBSDataContainer dataContainer;

        private QueryResultsContainer(QueryProcessor queryProcessor, int resultSetNumber) {
            this.queryProcessor = queryProcessor;
            this.resultSetNumber = resultSetNumber;
            boolean detachedViewer = false;
            SQLResultsView sqlView = null;
            if (detachedViewer) {
                try {
                    sqlView = (SQLResultsView)SQLEditor.this.getSite().getPage().showView("org.jkiss.dbeaver.core.sqlResults", null, 3);
                }
                catch (Throwable e2) {
                    DBUserInterface.getInstance().showError("Detached results", "Can't open results view", e2);
                }
            }
            if (sqlView != null) {
                sqlView.setContainer(this);
                this.viewer = sqlView.getViewer();
                this.tabItem = null;
            } else {
                this.viewer = new ResultSetViewer((Composite)SQLEditor.this.resultTabs, SQLEditor.this.getSite(), this);
                this.viewer.addListener(this);
                int tabCount = SQLEditor.this.resultTabs.getItemCount();
                int tabIndex = 0;
                int i = tabCount;
                while (i > 0) {
                    if (SQLEditor.this.resultTabs.getItem(i - 1).getData() instanceof QueryResultsContainer) {
                        tabIndex = i;
                        break;
                    }
                    --i;
                }
                this.tabItem = new CTabItem(SQLEditor.this.resultTabs, 0, tabIndex);
                int queryIndex = SQLEditor.this.queryProcessors.indexOf(queryProcessor);
                String tabName = SQLEditor.this.getResultsTabName(resultSetNumber, queryIndex, null);
                this.tabItem.setText(tabName);
                this.tabItem.setImage(IMG_DATA_GRID);
                this.tabItem.setData((Object)this);
                if (queryIndex > 0 || resultSetNumber > 0) {
                    this.tabItem.setShowClose(true);
                }
                this.tabItem.setControl((Control)this.viewer.getControl());
                UIUtils.disposeControlOnItemDispose((CTabItem)this.tabItem);
            }
            this.viewer.getControl().addDisposeListener(e -> {
                this.queryProcessor.removeResults(this);
                if (this == SQLEditor.this.curResultsContainer) {
                    SQLEditor.this.curResultsContainer = null;
                }
            });
        }

        QueryResultsContainer(QueryProcessor queryProcessor, int resultSetNumber, DBSDataContainer dataContainer) {
            this(queryProcessor, resultSetNumber);
            this.dataContainer = dataContainer;
            this.updateResultsName(sQLEditor.getResultsTabName(resultSetNumber, 0, dataContainer.getName()), null);
        }

        void updateResultsName(String resultSetName, String toolTip) {
            if (this.tabItem != null && !this.tabItem.isDisposed()) {
                if (!CommonUtils.isEmpty((String)resultSetName)) {
                    this.tabItem.setText(resultSetName);
                }
                this.tabItem.setToolTipText(toolTip);
            }
        }

        boolean isPinned() {
            return this.tabItem != null && SQLEditor.this.resultTabs.indexOf(this.tabItem) > 0 && !this.tabItem.getShowClose();
        }

        void setPinned(boolean pinned) {
            this.tabItem.setShowClose(!pinned);
            this.tabItem.setImage(pinned ? IMG_DATA_GRID_LOCKED : IMG_DATA_GRID);
        }

        @Override
        public DBCExecutionContext getExecutionContext() {
            return SQLEditor.this.getExecutionContext();
        }

        @Override
        @Nullable
        public ResultSetViewer getResultSetController() {
            return this.viewer;
        }

        @Override
        @Nullable
        public DBSDataContainer getDataContainer() {
            return this;
        }

        @Override
        public boolean isReadyToRun() {
            return this.queryProcessor.curJob == null || this.queryProcessor.curJobRunning.get() == 0;
        }

        @Override
        public void openNewContainer(DBRProgressMonitor monitor, DBSDataContainer dataContainer, DBDDataFilter newFilter) {
            UIUtils.syncExec(() -> {
                QueryResultsContainer resultsProvider = this.queryProcessor.createResultsProvider(dataContainer);
                resultsProvider.tabItem.getParent().setSelection(resultsProvider.tabItem);
                SQLEditor.this.setActiveResultsContainer(resultsProvider);
                resultsProvider.viewer.refreshWithFilter(newFilter);
            });
        }

        @Override
        public IResultSetDecorator createResultSetDecorator() {
            return new QueryResultsDecorator(){

                @Override
                public String getEmptyDataDescription() {
                    String execQuery = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.run.statement", (IServiceLocator)SQLEditor.this.getSite(), (boolean)true);
                    String execScript = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.run.script", (IServiceLocator)SQLEditor.this.getSite(), (boolean)true);
                    return NLS.bind((String)CoreMessages.sql_editor_resultset_filter_panel_control_execute_to_see_reslut, (Object)execQuery, (Object)execScript);
                }
            };
        }

        public int getSupportedFeatures() {
            if (this.dataContainer != null) {
                return this.dataContainer.getSupportedFeatures();
            }
            int features = 0;
            features |= 1;
            if (this.getQueryResultCounts() <= 1) {
                features |= 4;
            }
            return features;
        }

        @NotNull
        public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags) throws DBCException {
            SQLQuery query;
            if (this.dataContainer != null) {
                return this.dataContainer.readData(source, session, dataReceiver, dataFilter, firstRow, maxRows, flags);
            }
            SQLQueryJob job = this.queryProcessor.curJob;
            if (job == null) {
                throw new DBCException("No active query - can't read data");
            }
            if (this.query instanceof SQLQuery && (query = (SQLQuery)this.query).getResultsMaxRows() >= 0) {
                firstRow = query.getResultsOffset();
                maxRows = query.getResultsMaxRows();
            }
            try {
                if (dataReceiver != this.viewer.getDataReceiver()) {
                    this.queryProcessor.curDataReceiver = dataReceiver;
                } else {
                    this.queryProcessor.curDataReceiver = null;
                }
                int resultCounts = this.getQueryResultCounts();
                if (resultCounts <= 1 && this.resultSetNumber > 0) {
                    job.setFetchResultSetNumber(this.resultSetNumber);
                } else {
                    job.setFetchResultSetNumber(-1);
                }
                job.setResultSetLimit(firstRow, maxRows);
                job.setDataFilter(dataFilter);
                job.extractData(session, this.query, resultCounts > 1 ? 0 : this.resultSetNumber);
                this.lastGoodQuery = job.getLastGoodQuery();
                DBCStatistics dBCStatistics = job.getStatistics();
                return dBCStatistics;
            }
            finally {
                this.queryProcessor.curDataReceiver = null;
            }
        }

        private int getQueryResultCounts() {
            int resultCounts = 0;
            for (QueryResultsContainer qrc : this.queryProcessor.resultContainers) {
                if (qrc.query != this.query) continue;
                ++resultCounts;
            }
            return resultCounts;
        }

        /*
         * Unable to fully structure code
         */
        public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, DBDDataFilter dataFilter) throws DBCException {
            if (this.dataContainer != null) {
                return this.dataContainer.countData(source, session, dataFilter);
            }
            dataSource = this.getDataSource();
            if (!(dataSource instanceof SQLDataSource)) {
                throw new DBCException("Query transform is not supported by datasource");
            }
            if (!(this.query instanceof SQLQuery)) {
                throw new DBCException("Can't count rows for control command");
            }
            try {
                countQuery = new SQLQueryTransformerCount().transformQuery((SQLDataSource)dataSource, SQLEditor.this.getSyntaxManager(), (SQLQuery)this.query);
                if (!CommonUtils.isEmpty((Collection)countQuery.getParameters())) {
                    countQuery.setParameters(SQLEditor.this.parseParameters(countQuery.getText()));
                }
                var6_7 = null;
                var7_9 = null;
                try {
                    dbStatement = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.QUERY, (SQLQuery)countQuery, (long)0L, (long)0L);
                    try {
                        if (dbStatement.executeStatement()) {
                            var9_12 = null;
                            var10_14 = null;
                            try {
                                rs = dbStatement.openResultSet();
                                try {
                                    if (rs.nextRow()) {
                                        countValue = rs.getAttributeValue(0);
                                        if (countValue instanceof Number) {
                                            v0 = ((Number)countValue).longValue();
                                            while (true) {
                                                if (dbStatement != null) {
                                                    dbStatement.close();
                                                }
                                                return v0;
                                            }
                                        }
                                        throw new DBCException("Unexpected row count value: " + countValue);
                                    }
                                    throw new DBCException("Row count result is empty");
                                }
                                finally {
                                    if (rs == null) ** continue;
                                    rs.close();
                                }
                            }
                            catch (Throwable var10_15) {
                                if (var9_12 == null) {
                                    var9_12 = var10_15;
                                } else if (var9_12 != var10_15) {
                                    var9_12.addSuppressed(var10_15);
                                }
                                throw var9_12;
                            }
                        }
                        throw new DBCException("Row count query didn't return any value");
                    }
                    catch (Throwable var6_8) {
                        if (dbStatement != null) {
                            dbStatement.close();
                        }
                        throw var6_8;
                    }
                }
                catch (Throwable var7_10) {
                    if (var6_7 == null) {
                        var6_7 = var7_10;
                    } else if (var6_7 != var7_10) {
                        var6_7.addSuppressed(var7_10);
                    }
                    throw var6_7;
                }
            }
            catch (DBException e) {
                throw new DBCException("Error executing row count", (Throwable)e);
            }
        }

        @Nullable
        public String getDescription() {
            if (this.dataContainer != null) {
                return this.dataContainer.getDescription();
            }
            return CoreMessages.editors_sql_description;
        }

        @Nullable
        public DBSObject getParentObject() {
            return this.getDataSourceContainer();
        }

        @Nullable
        public DBPDataSource getDataSource() {
            return SQLEditor.this.getDataSource();
        }

        public boolean isPersisted() {
            return this.dataContainer == null || this.dataContainer.isPersisted();
        }

        @NotNull
        public String getName() {
            String name;
            if (this.dataContainer != null) {
                return this.dataContainer.getName();
            }
            String string = this.lastGoodQuery != null ? this.lastGoodQuery.getOriginalText() : (name = this.query == null ? null : this.query.getOriginalText());
            if (name == null) {
                name = "SQL";
            }
            return name;
        }

        @Nullable
        public DBPDataSourceContainer getDataSourceContainer() {
            return SQLEditor.this.getDataSourceContainer();
        }

        public String toString() {
            if (this.dataContainer != null) {
                return this.dataContainer.toString();
            }
            return this.query == null ? "SQL Query / " + SQLEditor.this.getEditorInput().getName() : this.query.getOriginalText();
        }

        @Override
        public void handleResultSetLoad() {
        }

        @Override
        public void handleResultSetChange() {
            SQLEditor.this.updateDirtyFlag();
        }

        @Override
        public void handleResultSetSelectionChange(SelectionChangedEvent event) {
        }
    }

    public static enum ResultSetOrientation {
        HORIZONTAL(512, "Horizontal", "Results are below the editor", true),
        VERTICAL(256, "Vertical", "Results are to the right from editor", true),
        DETACHED(512, "Detached", "Results are in separate view", false);

        private final int sashOrientation;
        private final String label;
        private final String description;
        private final boolean supported;

        private ResultSetOrientation(int sashOrientation, String label, String description, boolean supported) {
            this.sashOrientation = sashOrientation;
            this.label = label;
            this.description = description;
            this.supported = supported;
        }

        public int getSashOrientation() {
            return this.sashOrientation;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isSupported() {
            return this.supported;
        }
    }

    public static class ResultSetOrientationMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (!(activeEditor instanceof SQLEditorBase)) {
                return new IContributionItem[0];
            }
            final DBPPreferenceStore preferenceStore = ((SQLEditorBase)activeEditor).getActivePreferenceStore();
            String curPresentation = preferenceStore.getString("SQLEditor.resultSet.orientation");
            ResultSetOrientation[] orientations = ResultSetOrientation.values();
            ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>(orientations.length);
            ResultSetOrientation[] resultSetOrientationArray = orientations;
            int n = orientations.length;
            int n2 = 0;
            while (n2 < n) {
                final ResultSetOrientation orientation = resultSetOrientationArray[n2];
                Action action = new Action(orientation.getLabel(), 8){

                    public void run() {
                        preferenceStore.setValue("SQLEditor.resultSet.orientation", orientation.name());
                        PrefUtils.savePreferenceStore((DBPPreferenceStore)preferenceStore);
                    }
                };
                action.setDescription(orientation.getDescription());
                if (!orientation.isSupported()) {
                    action.setEnabled(false);
                }
                if (orientation.name().equals(curPresentation)) {
                    action.setChecked(true);
                }
                items.add(new ActionContributionItem((IAction)action));
                ++n2;
            }
            return items.toArray(new IContributionItem[items.size()]);
        }
    }

    private class SQLEditorQueryListener
    implements SQLQueryListener {
        private final QueryProcessor queryProcessor;
        private boolean scriptMode;
        private long lastUIUpdateTime;
        private final ITextSelection originalSelection;
        private int topOffset;
        private int visibleLength;
        private boolean closeTabOnError;
        private SQLQueryListener extListener;

        private SQLEditorQueryListener(QueryProcessor queryProcessor, boolean closeTabOnError) {
            this.originalSelection = (ITextSelection)SQLEditor.this.getSelectionProvider().getSelection();
            this.queryProcessor = queryProcessor;
            this.closeTabOnError = closeTabOnError;
        }

        public SQLQueryListener getExtListener() {
            return this.extListener;
        }

        public void setExtListener(SQLQueryListener extListener) {
            this.extListener = extListener;
        }

        @Override
        public void onStartScript() {
            try {
                this.lastUIUpdateTime = -1L;
                this.scriptMode = true;
                UIUtils.syncExec(() -> {
                    if (SQLEditor.this.isDisposed()) {
                        return;
                    }
                    if (SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.maxEditorOnScriptExecute")) {
                        SQLEditor.this.sashForm.setMaximizedControl(SQLEditor.this.editorControl);
                    }
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onStartScript();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStartQuery(DBCSession session, SQLQuery query) {
            try {
                boolean isInExecute;
                boolean bl = isInExecute = SQLEditor.this.getTotalQueryRunning() > 0;
                if (!isInExecute) {
                    UIUtils.asyncExec(() -> SQLEditor.this.setTitleImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT_EXECUTE)));
                }
                this.queryProcessor.curJobRunning.incrementAndGet();
                List list = SQLEditor.this.runningQueries;
                synchronized (list) {
                    SQLEditor.this.runningQueries.add(query);
                }
                if (this.lastUIUpdateTime < 0L || System.currentTimeMillis() - this.lastUIUpdateTime > 100L) {
                    UIUtils.syncExec(() -> {
                        TextViewer textViewer = SQLEditor.this.getTextViewer();
                        if (textViewer != null) {
                            this.topOffset = textViewer.getTopIndexStartOffset();
                            this.visibleLength = textViewer.getBottomIndexEndOffset() - this.topOffset;
                        }
                    });
                    if (this.scriptMode) {
                        SQLEditor.this.showStatementInEditor(query, false);
                    }
                    this.lastUIUpdateTime = System.currentTimeMillis();
                }
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onStartQuery(session, query);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEndQuery(DBCSession session, SQLQueryResult result) {
            try {
                List list = SQLEditor.this.runningQueries;
                synchronized (list) {
                    SQLEditor.this.runningQueries.remove(result.getStatement());
                }
                this.queryProcessor.curJobRunning.decrementAndGet();
                if (SQLEditor.this.getTotalQueryRunning() <= 0) {
                    UIUtils.asyncExec(() -> SQLEditor.this.setTitleImage(SQLEditor.this.editorImage));
                }
                if (SQLEditor.this.isDisposed()) {
                    return;
                }
                UIUtils.runUIJob((String)"Process SQL query result", monitor -> {
                    this.processQueryResult(session, result);
                    SQLEditor.this.updateDirtyFlag();
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onEndQuery(session, result);
                }
            }
        }

        private void processQueryResult(DBCSession session, SQLQueryResult result) {
            QueryResultsContainer results;
            SQLEditor.this.dumpQueryServerOutput(result);
            if (!this.scriptMode) {
                SQLEditor.this.runPostExecuteActions(result);
            }
            SQLQuery query = result.getStatement();
            Throwable error = result.getError();
            if (error != null) {
                SQLEditor.this.setStatus(GeneralUtils.getFirstMessage((Throwable)error), DBPMessageType.ERROR);
                if (!SQLEditor.this.scrollCursorToError(session.getProgressMonitor(), query, error)) {
                    int errorQueryOffset = query.getOffset();
                    int errorQueryLength = query.getLength();
                    if (errorQueryOffset >= 0 && errorQueryLength > 0) {
                        if (this.scriptMode) {
                            SQLEditor.this.getSelectionProvider().setSelection((ISelection)new TextSelection(errorQueryOffset, errorQueryLength));
                        } else {
                            SQLEditor.this.getSelectionProvider().setSelection((ISelection)this.originalSelection);
                        }
                    }
                }
            } else if (!this.scriptMode && SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.resetCursorOnExecute")) {
                SQLEditor.this.getSelectionProvider().setSelection((ISelection)this.originalSelection);
            }
            for (QueryResultsContainer cr : this.queryProcessor.resultContainers) {
                cr.viewer.updateFiltersText(false);
            }
            if ((this.scriptMode || this.queryProcessor.getResultContainers().size() == 1) && (results = this.queryProcessor.getResults(query)) != null) {
                int queryIndex = SQLEditor.this.queryProcessors.indexOf(this.queryProcessor);
                String resultSetName = SQLEditor.this.getResultsTabName(results.resultSetNumber, queryIndex, result.getResultSetName());
                results.updateResultsName(resultSetName, null);
            }
            if (this.closeTabOnError && error != null) {
                UIUtils.asyncExec(() -> {
                    CTabItem tabItem = this.queryProcessor.getFirstResults().tabItem;
                    if (tabItem != null && tabItem.getShowClose()) {
                        tabItem.dispose();
                    }
                });
            }
            if (SQLEditor.this.dataSourceContainer != null && !this.scriptMode && SQLEditor.this.dataSourceContainer.getPreferenceStore().getBoolean("SQLEditor.beepOnQueryEnd")) {
                Display.getCurrent().beep();
            }
            if (result.getQueryTime() > DBeaverCore.getGlobalPreferenceStore().getLong("agent.long.operation.timeout") * 1000L) {
                DBeaverUI.notifyAgent("Query completed [" + SQLEditor.this.getEditorInput().getName() + "]" + GeneralUtils.getDefaultLineSeparator() + CommonUtils.truncateString((String)query.getText(), (int)200), !result.hasError() ? 1 : 4);
            }
        }

        @Override
        public void onEndScript(DBCStatistics statistics, boolean hasErrors) {
            try {
                if (SQLEditor.this.isDisposed()) {
                    return;
                }
                SQLEditor.this.runPostExecuteActions(null);
                UIUtils.syncExec(() -> {
                    QueryResultsContainer results;
                    ResultSetViewer viewer;
                    if (SQLEditor.this.isDisposed()) {
                        return;
                    }
                    SQLEditor.this.sashForm.setMaximizedControl(null);
                    if (!hasErrors) {
                        SQLEditor.this.getSelectionProvider().setSelection((ISelection)this.originalSelection);
                    }
                    if ((viewer = (results = this.queryProcessor.getFirstResults()).getResultSetController()) != null) {
                        viewer.getModel().setStatistics(statistics);
                        viewer.updateStatusMessage();
                    }
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onEndScript(statistics, hasErrors);
                }
            }
        }
    }

    private class SaveJob
    extends AbstractJob {
        private transient Boolean success;

        SaveJob() {
            super("Save '" + SQLEditor.this.getPartName() + "' data changes...");
            this.success = null;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                for (QueryProcessor queryProcessor : SQLEditor.this.queryProcessors) {
                    for (QueryResultsContainer resultsProvider : queryProcessor.getResultContainers()) {
                        ResultSetViewer rsv = resultsProvider.getResultSetController();
                        if (rsv == null || !rsv.isDirty()) continue;
                        rsv.doSave(monitor);
                    }
                }
                this.success = true;
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Throwable e) {
                this.success = false;
                log.error((Object)e);
                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                return iStatus;
            }
            finally {
                if (this.success == null) {
                    this.success = true;
                }
            }
        }
    }

    private static class ServerOutputInfo {
        private final DBCServerOutputReader outputReader;
        private final DBCExecutionContext executionContext;
        private final SQLQueryResult result;

        ServerOutputInfo(DBCServerOutputReader outputReader, DBCExecutionContext executionContext, SQLQueryResult result) {
            this.outputReader = outputReader;
            this.executionContext = executionContext;
            this.result = result;
        }
    }

    private class ServerOutputReader
    extends AbstractJob {
        ServerOutputReader() {
            super("Dump server output");
            this.setSystem(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (!DBeaverCore.isClosing() && SQLEditor.this.sashForm != null && !SQLEditor.this.sashForm.isDisposed()) {
                this.dumpOutput(monitor);
                this.schedule(200L);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpOutput(DBRProgressMonitor monitor) {
            String dumpString;
            ArrayList outputs;
            List list = SQLEditor.this.serverOutputs;
            synchronized (list) {
                outputs = new ArrayList(SQLEditor.this.serverOutputs);
                SQLEditor.this.serverOutputs.clear();
            }
            StringWriter dump = new StringWriter();
            for (ServerOutputInfo info : outputs) {
                try {
                    info.outputReader.readServerOutput(monitor, info.executionContext, info.result, null, new PrintWriter((Writer)dump, true));
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            DBCServerOutputReader outputReader = null;
            DBCExecutionContext executionContext = SQLEditor.this.getExecutionContext();
            if (executionContext != null) {
                DBPDataSource dataSource = executionContext.getDataSource();
                outputReader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)dataSource);
            }
            if (outputReader != null && outputReader.isAsyncOutputReadSupported()) {
                for (QueryProcessor qp : SQLEditor.this.queryProcessors) {
                    DBCStatement statement;
                    SQLQueryJob queryJob = qp.curJob;
                    if (queryJob == null || (statement = queryJob.getCurrentStatement()) == null) continue;
                    try {
                        outputReader.readServerOutput(monitor, executionContext, null, statement, new PrintWriter((Writer)dump, true));
                    }
                    catch (DBCException e) {
                        log.error((Object)e);
                    }
                }
            }
            if (!(dumpString = dump.toString()).isEmpty()) {
                UIUtils.asyncExec(() -> {
                    if (SQLEditor.this.outputViewer.isDisposed()) {
                        return;
                    }
                    try {
                        IOUtils.copyText((Reader)new StringReader(dumpString), (Writer)SQLEditor.this.outputViewer.getOutputWriter());
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                    if (SQLEditor.this.outputViewer.isHasNewOutput()) {
                        SQLEditor.this.outputViewer.scrollToEnd();
                        SQLEditor.this.updateOutputViewerIcon(true);
                    }
                });
            }
        }
    }
}

