/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.registry.editor.EntityEditorDescriptor;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.IProgressControlProvider;
import org.jkiss.dbeaver.ui.controls.ObjectEditorPageControl;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderListener;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderComposite;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderInfo;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorContributorUser;
import org.jkiss.dbeaver.ui.editors.entity.GlobalContributorManager;
import org.jkiss.dbeaver.ui.editors.entity.IEntityEditorContext;
import org.jkiss.dbeaver.ui.editors.entity.properties.TabbedFolderPageEditor;
import org.jkiss.dbeaver.ui.editors.entity.properties.TabbedFolderPageNode;
import org.jkiss.dbeaver.ui.editors.entity.properties.TabbedFolderPageProperties;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class ObjectPropertiesEditor
extends AbstractDatabaseObjectEditor<DBSObject>
implements IRefreshablePart,
IProgressControlProvider,
ITabbedFolderContainer,
ISearchContextProvider,
INavigatorModelView,
IEntityEditorContext {
    private static final Log log = Log.getLog(ObjectPropertiesEditor.class);
    private TabbedFolderComposite folderComposite;
    private ObjectEditorPageControl pageControl;
    private final List<ITabbedFolderListener> folderListeners = new ArrayList<ITabbedFolderListener>();
    private String curFolderId;
    private final List<ISaveablePart> nestedSaveable = new ArrayList<ISaveablePart>();
    private final Map<ITabbedFolder, IEditorActionBarContributor> pageContributors = new HashMap<ITabbedFolder, IEditorActionBarContributor>();
    private SashForm sashForm;
    private boolean activated = false;
    private Composite propsPlaceholder;
    @Nullable
    private TabbedFolderPageProperties propertiesPanel;

    public void createPartControl(Composite parent) {
        this.pageControl = new ObjectEditorPageControl(parent, 0x10000000, this);
        this.pageControl.setShowDivider(true);
        Composite container = new Composite((Composite)this.pageControl, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 5;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        container.setLayout((Layout)gl);
        container.setLayoutData((Object)new GridData(1808));
        this.pageControl.createProgressPanel();
        this.createPropertyBrowser(container);
    }

    private void createPropertyBrowser(Composite container) {
        TabbedFolderInfo[] folders = this.collectFolders((IWorkbenchPart)this);
        if (folders.length == 0) {
            this.createPropertiesPanel(container);
        } else {
            Composite foldersParent = container;
            if (DBeaverCore.getGlobalPreferenceStore().getBoolean("entity.editor.info.detach")) {
                this.sashForm = UIUtils.createPartDivider((IWorkbenchPart)this.getSite().getPart(), (Composite)container, (int)512);
                this.sashForm.setLayoutData((Object)new GridData(1808));
                foldersParent = this.sashForm;
                this.createPropertiesPanel((Composite)this.sashForm);
            }
            this.createFoldersPanel(foldersParent, folders);
        }
    }

    private void createPropertiesPanel(Composite container) {
        this.propsPlaceholder = UIUtils.createPlaceholder((Composite)container, (int)2, (int)0);
        this.propsPlaceholder.setLayoutData((Object)new GridData(1808));
    }

    private Composite createFoldersPanel(Composite parent, TabbedFolderInfo[] folders) {
        int n;
        boolean single;
        Composite foldersPlaceholder = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)0);
        foldersPlaceholder.setLayoutData((Object)new GridData(1808));
        boolean bl = single = folders.length < 4;
        if (single) {
            TabbedFolderInfo[] tabbedFolderInfoArray = folders;
            n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                TabbedFolderInfo fi = tabbedFolderInfoArray[n2];
                if (!fi.isEmbeddable()) {
                    single = false;
                }
                ++n2;
            }
        }
        this.folderComposite = new TabbedFolderComposite(foldersPlaceholder, 0x4000 | (single ? 4 : 2));
        this.folderComposite.setLayoutData(new GridData(1808));
        String objectId = "PropertiesEditor." + this.getDatabaseObject().getClass().getName();
        this.folderComposite.setFolders(objectId, folders);
        GlobalContributorManager contributorManager = GlobalContributorManager.getInstance();
        TabbedFolderInfo[] tabbedFolderInfoArray = folders;
        int n3 = folders.length;
        n = 0;
        while (n < n3) {
            IEditorActionBarContributor contributor;
            TabbedFolderInfo folder = tabbedFolderInfoArray[n];
            ITabbedFolder page = folder.getContents();
            if (page instanceof IDatabaseEditorContributorUser && (contributor = ((IDatabaseEditorContributorUser)((Object)page)).getContributor(contributorManager)) != null) {
                contributorManager.addContributor(contributor, this);
                this.pageContributors.put(page, contributor);
            }
            if (page instanceof ISaveablePart) {
                this.nestedSaveable.add((ISaveablePart)page);
            }
            ++n;
        }
        String folderId = this.getEditorInput().getDefaultFolderId();
        if (folderId != null) {
            this.folderComposite.switchFolder(folderId);
        }
        this.folderComposite.addFolderListener(new ITabbedFolderListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void folderSelected(String folderId) {
                if (CommonUtils.equalObjects((Object)ObjectPropertiesEditor.this.curFolderId, (Object)folderId)) {
                    return;
                }
                List list = ObjectPropertiesEditor.this.folderListeners;
                synchronized (list) {
                    ObjectPropertiesEditor.this.curFolderId = folderId;
                    for (ITabbedFolderListener listener : ObjectPropertiesEditor.this.folderListeners) {
                        listener.folderSelected(folderId);
                    }
                }
            }
        });
        return foldersPlaceholder;
    }

    private void updateSashWidths() {
        int sashPanelHeight;
        if (this.sashForm.isDisposed()) {
            return;
        }
        String sashStateStr = DBeaverCore.getGlobalPreferenceStore().getString("entity.editor.info.sash.state");
        int n = sashPanelHeight = !CommonUtils.isEmpty((String)sashStateStr) ? Integer.parseInt(sashStateStr) : 400;
        if (sashPanelHeight < 0) {
            sashPanelHeight = 0;
        }
        if (sashPanelHeight > 1000) {
            sashPanelHeight = 1000;
        }
        this.sashForm.setWeights(new int[]{sashPanelHeight, 1000 - sashPanelHeight});
        this.sashForm.layout();
        this.sashForm.getChildren()[0].addListener(11, event -> {
            int[] weights;
            if (this.sashForm != null && (weights = this.sashForm.getWeights()) != null && weights.length > 0) {
                int topWeight = weights[0];
                if (topWeight == 0) {
                    topWeight = 1;
                }
                DBeaverCore.getGlobalPreferenceStore().setValue("entity.editor.info.sash.state", topWeight);
            }
        });
    }

    @Override
    public void activatePart() {
        if (this.activated) {
            return;
        }
        this.activated = true;
        if (DBeaverCore.getGlobalPreferenceStore().getBoolean("entity.editor.info.detach")) {
            this.propertiesPanel = new TabbedFolderPageProperties((IWorkbenchPart)this, this.getEditorInput());
            this.propertiesPanel.createControl(this.propsPlaceholder);
        }
        this.pageControl.layout(true);
        if (this.propsPlaceholder != null) {
            this.propsPlaceholder.layout(true);
        }
        if (this.sashForm != null) {
            Runnable sashUpdater = this::updateSashWidths;
            if (this.sashForm.getSize().y > 0) {
                sashUpdater.run();
            } else {
                UIUtils.asyncExec((Runnable)sashUpdater);
            }
        }
    }

    public void dispose() {
        GlobalContributorManager contributorManager = GlobalContributorManager.getInstance();
        for (IEditorActionBarContributor contributor : this.pageContributors.values()) {
            contributorManager.removeContributor(contributor, this);
        }
        this.pageContributors.clear();
        super.dispose();
    }

    public void setFocus() {
        if (this.folderComposite != null) {
            ITabbedFolder selectedPage = this.folderComposite.getActiveFolder();
            if (selectedPage != null) {
                selectedPage.setFocus();
            }
        } else if (this.pageControl != null) {
            this.pageControl.setFocus();
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        for (ISaveablePart sp : this.nestedSaveable) {
            if (!sp.isDirty()) continue;
            sp.doSave(monitor);
        }
    }

    @Override
    public void doSaveAs() {
        ITabbedFolder activeFolder = this.getActiveFolder();
        if (activeFolder instanceof ISaveablePart) {
            ((ISaveablePart)activeFolder).doSaveAs();
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    @Override
    public boolean isDirty() {
        for (ISaveablePart sp : this.nestedSaveable) {
            if (!sp.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    @Nullable
    public ProgressPageControl getProgressControl() {
        return this.pageControl;
    }

    @Override
    @Nullable
    public ITabbedFolder getActiveFolder() {
        return this.folderComposite == null ? null : this.folderComposite.getActiveFolder();
    }

    @Override
    public boolean switchFolder(String folderId) {
        if (this.folderComposite != null) {
            return this.folderComposite.switchFolder(folderId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFolderListener(ITabbedFolderListener listener) {
        List<ITabbedFolderListener> list = this.folderListeners;
        synchronized (list) {
            this.folderListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFolderListener(ITabbedFolderListener listener) {
        List<ITabbedFolderListener> list = this.folderListeners;
        synchronized (list) {
            this.folderListeners.remove(listener);
        }
    }

    @Nullable
    private ISearchContextProvider getFolderSearch() {
        ITabbedFolder activeFolder = this.getActiveFolder();
        if (activeFolder instanceof ISearchContextProvider) {
            return (ISearchContextProvider)activeFolder;
        }
        return null;
    }

    public boolean isSearchPossible() {
        return true;
    }

    public boolean isSearchEnabled() {
        ISearchContextProvider provider = this.getFolderSearch();
        return provider != null && provider.isSearchEnabled();
    }

    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        ISearchContextProvider folderSearch = this.getFolderSearch();
        if (folderSearch != null) {
            return folderSearch.performSearch(searchType);
        }
        return false;
    }

    public void refreshPart(Object source, boolean force) {
        if (this.propertiesPanel != null) {
            this.propertiesPanel.refreshPart(source, force);
        }
        if (this.folderComposite != null && this.folderComposite.getFolders() != null) {
            TabbedFolderInfo[] tabbedFolderInfoArray = this.folderComposite.getFolders();
            int n = tabbedFolderInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                TabbedFolderInfo folder = tabbedFolderInfoArray[n2];
                if (folder.getContents() instanceof IRefreshablePart) {
                    ((IRefreshablePart)folder.getContents()).refreshPart(source, force);
                }
                ++n2;
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result = null;
        ITabbedFolder activeFolder = this.getActiveFolder();
        if (activeFolder != null) {
            if (activeFolder instanceof IAdaptable) {
                result = ((IAdaptable)activeFolder).getAdapter(adapter);
            } else if (adapter.isAssignableFrom(activeFolder.getClass())) {
                result = activeFolder;
            }
        }
        if (result != null) {
            return adapter.cast(result);
        }
        return null;
    }

    public TabbedFolderInfo[] collectFolders(IWorkbenchPart part) {
        ArrayList<TabbedFolderInfo> tabList = new ArrayList<TabbedFolderInfo>();
        this.makeStandardPropertiesTabs(tabList);
        if (part instanceof IDatabaseEditor) {
            this.makeDatabaseEditorTabs((IDatabaseEditor)part, tabList);
        }
        return tabList.toArray(new TabbedFolderInfo[tabList.size()]);
    }

    private void makeStandardPropertiesTabs(List<TabbedFolderInfo> tabList) {
        if (!DBeaverCore.getGlobalPreferenceStore().getBoolean("entity.editor.info.detach")) {
            tabList.add(new TabbedFolderInfo("standard", CoreMessages.ui_properties_category_information, (DBPImage)DBIcon.TREE_INFO, "General information", false, new TabbedFolderPageProperties((IWorkbenchPart)this, this.getEditorInput())));
        }
    }

    private void makeDatabaseEditorTabs(final IDatabaseEditor part, final List<TabbedFolderInfo> tabList) {
        List<EntityEditorDescriptor> editors;
        final DBNDatabaseNode node = part.getEditorInput().getNavigatorNode();
        if (node == null) {
            return;
        }
        DBSObject object = node.getObject();
        if (!node.getMeta().isStandaloneNode()) {
            DBRRunnableWithProgress tabsCollector = new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) {
                    ObjectPropertiesEditor.collectNavigatorTabs(monitor, part, (DBNNode)node, tabList);
                }
            };
            try {
                if (node.needsInitialization()) {
                    UIUtils.runInProgressService((DBRRunnableWithProgress)tabsCollector);
                } else {
                    tabsCollector.run((DBRProgressMonitor)new VoidProgressMonitor());
                }
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!CommonUtils.isEmpty(editors = EntityEditorsRegistry.getInstance().getEntityEditors((DBPObject)object, this, null))) {
            for (EntityEditorDescriptor descriptor : editors) {
                if (descriptor.getType() != EntityEditorDescriptor.Type.folder) continue;
                tabList.add(new TabbedFolderInfo(descriptor.getId(), descriptor.getName(), descriptor.getIcon(), descriptor.getDescription(), descriptor.isEmbeddable(), new TabbedFolderPageEditor(this, descriptor)));
            }
        }
    }

    private static void collectNavigatorTabs(DBRProgressMonitor monitor, IDatabaseEditor part, DBNNode node, List<TabbedFolderInfo> tabList) {
        if ((!(node instanceof DBNDataSource) || ((DBNDataSource)node).getDataSourceContainer().isConnected()) && node != null) {
            DBNDatabaseNode databaseNode;
            List subNodes;
            try {
                DBNNode[] children = NavigatorUtils.getNodeChildrenFiltered(monitor, node, false);
                if (children != null) {
                    DBNNode[] dBNNodeArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBNNode child = dBNNodeArray[n2];
                        if (child instanceof DBNDatabaseFolder) {
                            DBNDatabaseFolder folder = (DBNDatabaseFolder)child;
                            monitor.subTask(String.valueOf(CoreMessages.ui_properties_task_add_folder) + child.getNodeName() + "'");
                            tabList.add(new TabbedFolderInfo(folder.getNodeName(), folder.getNodeName(), folder.getNodeIconDefault(), child.getNodeDescription(), false, new TabbedFolderPageNode(part, (DBNNode)folder, null)));
                        }
                        ++n2;
                    }
                }
            }
            catch (DBException e) {
                log.error((Object)"Error initializing property tabs", (Throwable)e);
            }
            if (node instanceof DBNDatabaseNode && (subNodes = (databaseNode = (DBNDatabaseNode)node).getMeta().getChildren((DBNNode)databaseNode)) != null) {
                for (DBXTreeNode child : subNodes) {
                    if (!(child instanceof DBXTreeItem)) continue;
                    try {
                        if (((DBXTreeItem)child).isOptional() && !databaseNode.hasChildren(monitor, child)) continue;
                        monitor.subTask(String.valueOf(CoreMessages.ui_properties_task_add_node) + node.getNodeName() + "'");
                        String nodeName = child.getChildrenType(databaseNode.getObject().getDataSource());
                        tabList.add(new TabbedFolderInfo(nodeName, nodeName, node.getNodeIconDefault(), node.getNodeDescription(), false, new TabbedFolderPageNode(part, node, child)));
                    }
                    catch (DBException e) {
                        log.debug((Object)"Can't add child items tab", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public DBNNode getRootNode() {
        ITabbedFolder activeFolder = this.folderComposite.getActiveFolder();
        if (activeFolder instanceof INavigatorModelView) {
            return ((INavigatorModelView)((Object)activeFolder)).getRootNode();
        }
        return null;
    }

    @Override
    @Nullable
    public Viewer getNavigatorViewer() {
        ITabbedFolder activeFolder = this.folderComposite.getActiveFolder();
        if (activeFolder instanceof INavigatorModelView) {
            return ((INavigatorModelView)((Object)activeFolder)).getNavigatorViewer();
        }
        return null;
    }

    @Override
    public boolean isEntityContainer(DBSObjectContainer object) {
        return false;
    }
}

