/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverFileSource;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadPage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

class DriverDownloadManualPage
extends DriverDownloadPage {
    private DriverFileSource fileSource;
    private Table filesTable;

    DriverDownloadManualPage() {
        super(CoreMessages.dialog_driver_download_manual_page_config_driver_file, CoreMessages.dialog_driver_download_manual_page_download_driver_file, null);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        final DriverDescriptor driver = this.getWizard().getDriver();
        this.setMessage(NLS.bind((String)CoreMessages.dialog_driver_download_manual_page_download_config_driver_file, (Object)driver.getFullName()));
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Link infoText = new Link(composite, 0);
        infoText.setText(NLS.bind((String)CoreMessages.dialog_driver_download_manual_page_driver_file_missing_text, (Object)driver.getFullName()));
        infoText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverDownloadManualPage.this.getWizard().getContainer().buttonPressed(2000);
            }
        });
        GridData gd = new GridData(768);
        infoText.setLayoutData((Object)gd);
        Group filesGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_driver_download_manual_page_driver_file, (int)1, (int)-1, (int)-1);
        gd = new GridData(768);
        gd.verticalIndent = 10;
        filesGroup.setLayoutData((Object)gd);
        final Combo sourceCombo = new Combo((Composite)filesGroup, 12);
        for (DriverFileSource source : driver.getDriverFileSources()) {
            sourceCombo.add(source.getName());
        }
        final Link driverLink = new Link((Composite)filesGroup, 0);
        driverLink.setText("<a>" + driver.getDriverFileSources().get(0).getUrl() + "</a>");
        driverLink.setLayoutData((Object)new GridData(768));
        driverLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebUtils.openWebBrowser(driver.getDriverFileSources().get(sourceCombo.getSelectionIndex()).getUrl());
            }
        });
        this.filesTable = new Table((Composite)filesGroup, 67584);
        this.filesTable.setHeaderVisible(true);
        this.filesTable.setLayoutData((Object)new GridData(768));
        UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)CoreMessages.dialog_driver_download_manual_page_column_file);
        UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)CoreMessages.dialog_driver_download_manual_page_column_required);
        UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)CoreMessages.dialog_driver_download_manual_page_column_description);
        sourceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverDownloadManualPage.this.selectFileSource(driver.getDriverFileSources().get(sourceCombo.getSelectionIndex()));
                driverLink.setText("<a>" + driver.getDriverFileSources().get(sourceCombo.getSelectionIndex()).getUrl() + "</a>");
            }
        });
        sourceCombo.select(0);
        this.selectFileSource(driver.getDriverFileSources().get(0));
        UIUtils.packColumns((Table)this.filesTable, (boolean)true);
        this.createLinksPanel(composite);
        composite.setTabList((Control[])ArrayUtils.remove(Control.class, (Object[])composite.getTabList(), (Object)infoText));
        this.setControl((Control)composite);
    }

    private void selectFileSource(DriverFileSource source) {
        this.fileSource = source;
        this.filesTable.removeAll();
        for (DriverFileSource.FileInfo file : this.fileSource.getFiles()) {
            new TableItem(this.filesTable, 0).setText(new String[]{file.getName(), !file.isOptional() ? CoreMessages.dialog_driver_download_manual_page_yes : CoreMessages.dialog_driver_download_manual_page_no, CommonUtils.notEmpty((String)file.getDescription())});
        }
    }

    public boolean isPageComplete() {
        return this.fileSource != null;
    }

    @Override
    void resolveLibraries() {
    }

    @Override
    boolean performFinish() {
        UIUtils.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                WebUtils.openWebBrowser(DriverDownloadManualPage.this.fileSource.getUrl());
            }
        });
        return false;
    }
}

