/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTreeControl;

public class MigrateConnectionWizard
extends Wizard {
    private final DataSourceRegistry registry;
    private final Set<DBPDataSourceContainer> selectedConnections = new HashSet<DBPDataSourceContainer>();
    private PageConnections pageConnections;
    private PageDriver pageDriver;

    public MigrateConnectionWizard(DataSourceRegistry registry, IStructuredSelection selection) {
        this.registry = registry;
        if (selection != null && !selection.isEmpty()) {
            for (Object item : selection) {
                if (item instanceof IDataSourceContainerProvider) {
                    this.selectedConnections.add(((IDataSourceContainerProvider)item).getDataSourceContainer());
                    continue;
                }
                if (item instanceof DBPDataSourceContainer) {
                    this.selectedConnections.add((DBPDataSourceContainer)item);
                    continue;
                }
                if (item instanceof DBSObject) {
                    this.selectedConnections.add(((DBSObject)item).getDataSource().getContainer());
                    continue;
                }
                if (!(item instanceof DBSWrapper)) continue;
                this.selectedConnections.add(((DBSWrapper)item).getObject().getDataSource().getContainer());
            }
        }
        this.setWindowTitle(CoreMessages.dialog_migrate_wizard_window_title);
    }

    public void addPages() {
        this.pageConnections = new PageConnections();
        this.pageDriver = new PageDriver();
        this.addPage((IWizardPage)this.pageConnections);
        this.addPage((IWizardPage)this.pageDriver);
    }

    public IWizardPage getStartingPage() {
        if (!this.selectedConnections.isEmpty()) {
            return this.pageDriver;
        }
        return this.pageConnections;
    }

    public boolean performFinish() {
        List<DataSourceDescriptor> connections = this.pageConnections.getSelectedConnections();
        DriverDescriptor targetDriver = this.pageDriver.selectedDriver;
        for (DataSourceDescriptor conn : connections) {
            conn.setDriver(targetDriver);
            conn.getRegistry().updateDataSource((DBPDataSourceContainer)conn);
        }
        return true;
    }

    class PageConnections
    extends WizardPage {
        private Table connectionsViewer;

        protected PageConnections() {
            super(CoreMessages.dialog_migrate_wizard_name);
            this.setTitle(CoreMessages.dialog_migrate_wizard_start_title);
            this.setDescription(CoreMessages.dialog_migrate_wizard_start_description);
        }

        public void createControl(Composite parent) {
            this.connectionsViewer = new Table(parent, 67618);
            this.connectionsViewer.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PageConnections.this.getContainer().updateButtons();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    PageConnections.this.getContainer().showPage(PageConnections.this.getNextPage());
                }
            });
            if (MigrateConnectionWizard.this.registry != null) {
                for (DataSourceDescriptor ds : MigrateConnectionWizard.this.registry.getDataSources()) {
                    TableItem item = new TableItem(this.connectionsViewer, 0);
                    item.setText(ds.getName());
                    item.setData((Object)ds);
                    item.setImage(DBeaverIcons.getImage((DBPImage)ds.getDriver().getIcon()));
                    if (!MigrateConnectionWizard.this.selectedConnections.contains(ds)) continue;
                    item.setChecked(true);
                }
            }
            this.setControl((Control)this.connectionsViewer);
        }

        public boolean isPageComplete() {
            TableItem[] tableItemArray = this.connectionsViewer.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public List<DataSourceDescriptor> getSelectedConnections() {
            ArrayList<DataSourceDescriptor> result = new ArrayList<DataSourceDescriptor>();
            TableItem[] tableItemArray = this.connectionsViewer.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    result.add((DataSourceDescriptor)item.getData());
                }
                ++n2;
            }
            return result;
        }
    }

    class PageDriver
    extends WizardPage
    implements ISelectionChangedListener {
        private DriverDescriptor selectedDriver;
        private DriverTreeControl driverTreeControl;

        PageDriver() {
            super("migrateConnectionDriver");
            this.setTitle(CoreMessages.dialog_migrate_wizard_choose_driver_title);
            this.setDescription(CoreMessages.dialog_migrate_wizard_choose_driver_description);
        }

        public void createControl(Composite parent) {
            Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
            this.driverTreeControl = new DriverTreeControl(placeholder, (Object)this, DataSourceProviderRegistry.getInstance().getEnabledDataSourceProviders(), true);
            GridData gd = new GridData(1808);
            gd.heightHint = 200;
            this.driverTreeControl.setLayoutData(gd);
            this.setControl((Control)placeholder);
        }

        public boolean isPageComplete() {
            return this.selectedDriver != null;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedObject;
            this.selectedDriver = null;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof DBPDriver) {
                this.selectedDriver = (DriverDescriptor)((Object)selectedObject);
            }
            this.getWizard().getContainer().updateButtons();
        }
    }
}

